#include "../h/ashelp.h"

/******************************************************************************
* Top(result, r, y)
*
* Splits rectangle "r" vertically at coordinate "y" and returns a rectangle
* that includes the split and everything above it.
*
* C Interface:
*
*	void Top(result, r, y)
*	struct rectangle *result, r;
*	word y;
*
* Assembly Interface:
*
*	+---------------------------------+
*	| result			  |  0 (L)
*	+---------------------------------+
*	| r.x            | r.y            |  4 (W), 6 (W)
*	+---------------------------------+
*	| r.w            | r.h            |  8 (W), 10 (W)
*	+---------------------------------+
*	| ///////////////| y              |  14 (W)
*	+---------------------------------+
*
******************************************************************************/

ans	= 0+8
rx	= 4+8
ry	= 6+8
rw	= 8+8
rh	= 10+8
y	= 14+8

	.globl	_Top
	.text
_Top:	link	a6,#0			/* set up stack frame */
	moveml	#D1_D3_,sp@-		/* save registers */
	movemw	a6@(rx),#_D0_D3		/* blast rectangle in */

	movw	a6@(y),d3		/* get dividing Y coordinate */
	subw	d1,d3			/* subtract rectangle top */
	addqw	#1,d3			/* include split in result */

	movl	a6@(ans),a0		/* get the address of the result */
	movemw	#_D0_D3,a0@		/* blast result out */
	moveml	sp@+,#_D1_D3		/* restore registers */
	unlk	a6			/* remove stack frame */
	rts				/* return */
