#include "../h/ashelp.h"

/******************************************************************************
* Right(result, r, y)
*
* Splits rectangle "r" horizontally at coordinate "x" and returns a rectangle
* that includes the split and everything to its right.
*
* C Interface:
*
*	Right(result, r, x)
*	struct rectangle *result, r;
*	word x;
*
* Assembly Interface:
*
*	+---------------------------------+
*	| answer			  |  0 (L)
*	+---------------------------------+
*	| r.x            | r.y            |  4 (W), 6 (W)
*	+---------------------------------+
*	| r.w            | r.h            |  8 (W), 10 (W)
*	+---------------------------------+
*	| ///////////////| x              |  14 (W)
*	+---------------------------------+
*
******************************************************************************/

ans	= 0+8
rx	= 4+8
ry	= 6+8
rw	= 8+8
rh	= 10+8
x	= 14+8

	.globl	_Right
	.text
_Right:	link	a6,#0			/* set up stack frame */
	moveml	#D1_D3_,sp@-		/* save registers */
	movemw	a6@(rx),#_D0_D3		/* blast rectangle in */

	addw	d0,d2			/* compute first x beyond right side */
	subw	a6@(x),d2		/* compute width of right portion */
	movw	a6@(x),d0		/* put left side at dividing X */

	movl	a6@(ans),a0		/* get the address of the result */
	movemw	#_D0_D3,a0@		/* blast result out */
	moveml	sp@+,#_D1_D3		/* restore registers */
	unlk	a6			/* remove stack frame */
	rts				/* return */
