/******************************************************************************
* Adjacent(r1, r2)
*
* Returns true if and only if rectangles "r1" and "r2" are adjacent.
*
* C Interface:
*
*	bool Adjacent(r1, r2)
*	struct rectangle r1, r2;
*
* Assembly Interface:
*
*	+---------------------------------+
*	| r1.x           | r1.y           |  0 (W), 2 (W)
*	+---------------------------------+
*	| r1.w           | r1.h           |  4 (W), 6 (W)
*	+---------------------------------+
*	| r2.x           | r2.y           |  8 (W), 10 (W)
*	+---------------------------------+
*	| r2.w           | r2.h           | 12 (W), 14 (W)
*	+---------------------------------+
*
******************************************************************************/

r1x	= 0+8
r1y	= 2+8
r1w	= 4+8
r1h	= 6+8
r2x	= 8+8
r2y	= 10+8
r2w	= 12+8
r2h	= 14+8

	.globl	_Adjacent
	.text
_Adjacent:
	link	a6,#0			/* establish stack frame */
	movw	a6@(r1x),d0		/* get left edge of first rectangle */
	cmpw	a6@(r2x),d0		/* compare with left edge of second */
	bne	1f			/* branch if no horizontal alignment */

	movw	a6@(r1w),d0		/* get width of first rectangle */
	cmpw	a6@(r2w),d0		/* compare with width of second */
	bne	1f			/* branch if widths are different */

	movw	a6@(r1y),d0		/* get top edge of first rectangle */
	addw	a6@(r1h),d0		/* compute bottom neighbor */
	cmpw	a6@(r2y),d0		/* is it the second? */
	beq	3f			/* return true if it is */

	movw	a6@(r2y),d0		/* get top edge of second rectangle */
	addw	a6@(r2h),d0		/* compute bottom neighbor */
	cmpw	a6@(r1y),d0		/* is it the first? */
	beq	3f			/* return true if it is */

    1:	movw	a6@(r1y),d0		/* get top edge of first rectangle */
	cmpw	a6@(r2y),d0		/* compare with top edge of second */
	bne	2f			/* branch if no vertical alignment */

	movw	a6@(r1h),d0		/* get height of first rectangle */
	cmpw	a6@(r2h),d0		/* compare with height of second */
	bne	2f			/* branch if heights are different */

	movw	a6@(r1x),d0		/* get left edge of first rectangle */
	addw	a6@(r1w),d0		/* compute right neighbor */
	cmpw	a6@(r2x),d0		/* is it the second? */
	beq	3f			/* return true if it is */

	movw	a6@(r2x),d0		/* get left edge of second rectangle */
	addw	a6@(r2w),d0		/* compute right neighbor */
	cmpw	a6@(r1x),d0		/* is it the first? */
	beq	3f			/* return true if it is */
	
    2:	clrl	d0			/* get value for false */
	unlk	a6			/* remove stack frame */
	rts				/* return it */

    3:	moveq	#1,d0			/* get value for true */
	unlk	a6			/* remove stack frame */
	rts				/* return it */
