/******************************************************************************
* screen
*
* This extended raster descriptor represents the ISI screen.
*
*******************************************************************************/

	.globl	_screen			/* screen raster */
	.globl	_screen0		/* screen raster */
#ifdef COLOR
	.globl	_screen1		/* screen raster */
	.globl	_screen2		/* screen raster */
	.globl	_screen3		/* screen raster */
#endif COLOR
	.globl	_gpaddr			/* address of gip fifo register */
	.globl	_gpwcs			/* address of gip wcs */
	.globl	_usegp			/* enable mico code operations */
	.data
_screen0:
_screen:
	.word	0xa0			/* width in bytes of one display line */
#ifndef UNIX
	.long   DISPM_START		/* begining of display memory */

	.long	DISPM_END		/* EXTENDED end of display memory */
	.long	SCREEN0END		/* EXTENDED end of visable memory */

_gpaddr:.long	0x7e8000
_gpwcs:	.long	0x7e9000
#else
	.long	_vidbuf			/* virtual address of raster */
	.long	_vidbuf+0x40000		/* EXTENDED end of display memory */
	.long	_vidbuf+0x28000		/* EXTENDED end of visable memory */

#ifdef COLOR
_screen1:
	.word	0xa0			/* width in bytes of one display line */
	.long	_vidbuf+0x40000		/* virtual address of raster */
	.long	_vidbuf+0x80000		/* EXTENDED end of display memory */
	.long	_vidbuf+0x28000		/* EXTENDED end of visable memory */

_screen2:
	.word	0xa0			/* width in bytes of one display line */
	.long	_vidbuf+0x80000		/* virtual address of raster */
	.long	_vidbuf+0xc0000		/* EXTENDED end of display memory */
	.long	_vidbuf+0x28000		/* EXTENDED end of visable memory */

_screen3:
	.word	0xa0			/* width in bytes of one display line */
	.long	_vidbuf+0xc0000		/* virtual address of raster */
	.long	_vidbuf+0x100000	/* EXTENDED end of display memory */
	.long	_vidbuf+0x28000		/* EXTENDED end of visable memory */
#endif COLOR

_gpaddr:.long	0x000000
_gpwcs:	.long	0x000000
#endif UNIX

_usegp:	.long	1
