#include "../h/ashelp.h"
#include "../h/ucode.h"

/******************************************************************************
* LoadLUT(color, red, green, blue)
*
* Sets the value of color in the lookup table to the red/green/blue specified
*
* C Interface:
*
*	LoadLUT(color, red, green, blue)
*	int	color, red, green, blue;
*
* Assembly Interface:
*
*	+---------------------------------+
*	|///////////////////////////|color|  2 (nibble)
*	+---------------------------------+
*	|///////////////////////////|red  |  6 (nibble)
*	+---------------------------------+
*	|///////////////////////////|green| 10 (nibble)
*	+---------------------------------+
*	|///////////////////////////|blue | 14 (nibble)
*	+---------------------------------+
*
******************************************************************************/

	.globl	_LoadLUT
	.text
_LoadLUT:
/*
 * Setup stack frame
 */
	link	a6,#0

	movl	a6@(8),sp@-		/* pass color */
	movl	a6@(20),sp@-		/* pass blue value */
	movl	a6@(16),sp@-		/* pass green value */
	movl	a6@(12),sp@-		/* pass red value */
	movl	#GP_SLUT,sp@-		/* set color command */
	movl	#5,sp@-			/* number of paramters */
	jsr	_UCoutput		/* execute */
	addl	#20,sp			/* clear stack */
	unlk	a6
	rts
