/*
 *	These routines allow for query of current positions et al., for use
 *	by the virtual terminal driver
 */

#include	    <vt_hdrs.h>		/* system wide defines */
#include	    <rectangle.h>	/* rectangle structure */
#include	    <cursor.h>		/* cursor structure */
#include	    <window.h>		/* window structure */

/*
 *	Routine which returns true if the screen coordinate x,y is within the
 *	given window
 */
bool WithinWindow(window, x, y)
struct window *window;
int x, y;
{
    register struct window *w;

    /* loop thru windows for top */
    for (w = desk->next; w != desk; w = w->next) {
	/* if in this window, return true if this is given window else false */
	if (Within(w->obounds, x, y))   return(w == window);
	/* return false if not in this window - go no further */
	else if (w == window) 		return(FALSE);
   }
   /* must be in desktop, return false always */
   return(FALSE);
}


/*
 *	Routine to return the window which the given screen coorordinate x,y
 *	lies 
 */
ContainingWindow(x, y, window)
int x, y;
struct window **window;
{
    register struct window *w;

    /* loop thru windows from the top */
    for (w = desk->next; w != desk; w = w->next) {
	/* check if point is in this window */
	if (Within(w->obounds, x, y)) {
	    *window = w;
	    return;
	}
    }
    /* must be in the desktop, return it */
    *window = desk;
}

/*
 *	Routine to return true if the given screen coordinate x,y lies within
 *	the given pane of the given window
 */
bool WithinPane(window, pane, x, y)
struct window *window;
int pane;
int x, y;
{
    struct rectangle bounds;
    /* if not even in window then stop */
    if (!WithinWindow(window, x, y))
	return(FALSE);

    /* return true if in given pane, else false */
    PaneBounds(window, pane, &bounds);
    return (Within(bounds, x, y));
}

/*
 *	Routine to return the pane and window number of the given screen
 *	coorordinate x,y
 */
ContainingPane(x, y, window, pane)
int x, y;
struct window **window;
int *pane;
{
    register struct window *w;
    register int p;
    struct rectangle bounds;

    /* find containing window */
    ContainingWindow(x, y, window);

    /* loop thru all pains to find correct one */
    for (p = DISPLAY; p <= BRCORNER; p++) {
        PaneBounds(*window, p, &bounds);
        if (Within(bounds, x, y)) {
    	    *pane = p;
    	    return;
        }
    }
    
    /* not in any pane (on border) return -1 */
    *pane = -1;
}

/*
 *	Routine to turn the given screen coordinates into relative x,y
 *	coordinates within the given pane of the given window
 */
MapCoordinates(window, pane, x, y, xp, yp)
struct window *window;
int pane;
int x, y;
int *xp, *yp;
{
    struct rectangle bounds;

    /* find bounds of this pane in window */
    PaneBounds(window, pane, &bounds);

    /* return relative coordinates */
    *xp = x-bounds.x;
    *yp = y-bounds.y;
}
