#include "../h/ucode.h"

/******************************************************************************
* UnsetClipping()
*
* Turns off global micro-code clipping
*
* C Interface:
*
*	UnsetClipping()
*
******************************************************************************/

	.globl	_UnsetClipping
	.text
_UnsetClipping:

#ifdef UCODE_CLIP
/*
 * Setup stack frame
 */
	link	a6,#0			/* establish frame pointer */

/*
 * Make sure that clipping is turned off
 */
	movl	#GP_CLIPOF,sp@-		/* push clip off command */
	movl	#1,sp@-			/* push number of parameters */
	jsr	_UCoutput		/* load command and execute */
	addl	#8,sp			/* level stack */
	clrb	UCclipon		/* flag clipping off */

/*
 * Clean up stack and return
 */
	unlk	a6			/* unlink stack frame */
#endif UCODE_CLIP

	rts
