#include "../h/ashelp.h"
#include "../h/ucode.h"

/******************************************************************************
* SetClipping(x, y, w, h)
*
* Moves the clipping rectangle to ("x", "y") and sets its width and height to
* "w" and "h".  All routines in the graphics library are required to observe
* these limits when drawing.  Initially, the clipping rectangle encompasses
* the entire screen.
*
* C Interface:
*
*	SetClipping(x, y, w, h)
*	int x, y, w, h;
*
* Assembly Interface:
*
*	+---------------------------------+
*	|////////////////| x              |  2 (W)
*	+---------------------------------+
*	|////////////////| y              |  6 (W)
*	+---------------------------------+
*	|////////////////| w              | 10 (W)
*	+---------------------------------+
*	|////////////////| h              | 14 (W)
*	+---------------------------------+
*
******************************************************************************/

	.globl	_SetClipping

#ifdef UCODE_CLIP
	.globl	UCclipon
	.data
UCclipon:
	.byte	0		/* flag if micro code clip is on */
#endif UCODE_CLIP

	.text
_SetClipping:
/*
 * Setup stack frame
 */
	link	a6,#0			/* establish frame pointer */
	movw	d0,sp@-			/* save working register */

/*
 * Copy parameters into clipping variables
 */
	movw	a6@(2+8),d0		/* get lower X */
	movw	d0,cliplx		/* copy into clipping variable */
	addw	a6@(10+8),d0		/* compute upper X */
	movw	d0,clipux		/* copy into clipping variable */

	movw	a6@(6+8),d0		/* get lower Y */
	movw	d0,cliply		/* copy into clipping variable */
	addw	a6@(14+8),d0		/* compute upper Y */
	movw	d0,clipuy		/* copy into clipping variable */

#ifdef UCODE_CLIP
	movemw	#D1_D3_,sp@-		/* save other registers */
/*
 * Make sure that clipping is turned on
 */
	tstb	UCclipon		/* is clipping turned on? */
	bne	1f			/* yes, just set bounds */
	movl	#GP_CLIPON,sp@-		/* push clip on command */
	movl	#1,sp@-			/* push number of parameters */
	jsr	_UCoutput		/* load command and execute */
	addl	#8,sp			/* level stack */
	addb	#1,UCclipon		/* flag clipping on */

/*
 * Setup for micro-code clip
 */
    1:	movw	a6@(2+8),d0		/* get lower X */
	movw	a6@(6+8),d1		/* get lower Y */
	movw	a6@(10+8),d2		/* get width */
	movw	a6@(14+8),d3		/* get height */
	jsr	Adjust			/* make positive */
	movl	d3,sp@-			/* push height */
	movl	d2,sp@-			/* push width */
	movl	d1,sp@-			/* push y0 */
	movl	d0,sp@-			/* push x0 */
	movl	#GP_CLIP,sp@-		/* clip command */
	movl	#5,sp@-			/* number of parameters */
	jsr	_UCoutput		/* load command and execute */
	addl	#24,sp			/* clear stack */
	movemw	sp@+,#_D1_D3		/* restore other registers */
#endif UCODE_CLIP

/*
 * Clean up stack and return
 */
	movw	sp@+,d0			/* restore register */
	unlk	a6			/* unlink stack frame */
	rts				/* return */
