/*
 *	Routine to draw one scanline at the given place in the given color
 *	with the given phase and set clipping bounds.
 */


#include <raster.h>
#include <graphics.h>

Scanline(xl, xr, y, color, pat, xphase, yphase)
int xl, xr, y;
COLORT color;
PATTERN pat;
int xphase, yphase;
{
    int w;
    extern short cliplx, cliply, clipux, clipuy;
    extern short invert[];

    if (y < cliply || y >= clipuy || xr < cliplx || xl >= clipux)
        return;

    if (xl < cliplx)
	xl = cliplx;

    if (xr >= clipux)
	xr = clipux-1;

    if( pat == invert){
	InvertRaster(&screen, xl, y, xr-xl+1, 1);
    }else if( *pat >= 0 ){	/* check for solid */
	ClearRaster(&screen, xl, y, xr-xl+1, 1, color);
    }else{
#ifdef COLOR
	ClearRaster(&screen, xl, y, xr-xl+1, 1, 0);
#endif COLOR
	CopyPattern(&screen, xl, y, xr-xl+1, 1, pat+1, xphase, yphase);
    }
}
