/******************************************************************************
* RClip
*
* This routine clips a rectangle to the clipping boundaries.  It is used
* internally by the other routines of the graphics library.  On entry, the
* registers should contain:
*
*	D0 (W):		X coordinate of target rectangle
*	D1 (W):		Y coordinate of target rectangle
*	D2 (W):		width of target rectangle
*	D3 (W):		height of target rectangle
*
* On exit, the registers contain:
*
*	D0 (W):		X coordinate of clipped rectangle
*	D1 (W):		Y coordinate of clipped rectangle
*	D2 (W):		width of clipped rectangle
*	D3 (W):		height of clipped rectangle
*
* In addition, either the N or Z condition code will be set if the target
* rectangle is not visible.  In this case, the return values are undefined.
*
* Except for the registers used to pass and return values, all registers are
* preserved.
*
******************************************************************************/

	.globl	RClip
	.text
RClip:
/*
 * Compute upper limits (plus one) of target rectangle
 */
	addw	d0,d2			/* compute upper X of targe */
	addw	d1,d3			/* compute upper Y of targe */

/*
 * Clip X coordinate by choosing larger lower X and smaller upper X
 */
	cmpw	cliplx,d0		/* compare lower X' */
	bge	1f			/* branch if target is large */
	movw	cliplx,d0		/* put larger value in D */

    1:	cmpw	clipux,d2		/* compare upper X' */
	ble	2f			/* branch if target is smalle */
	movw	clipux,d2		/* put smaller value in D */

    2:	subw	d0,d2			/* compute width of clipped rectangl */
	ble	return			/* return (with N set) if invisibl */

/*
 * Clip Y coordinates by choosing larger lower Y and smaller upper Y
 */
	cmpw	cliply,d1		/* compare lower Y' */
	bge	3f			/* branch if target is large */
	movw	cliply,d1		/* put larger value in D */

    3:	cmpw	clipuy,d3		/* compare upper Y' */
	ble	4f			/* branch if target is smalle */
	movw	clipuy,d3		/* put smaller value in D */

    4:	subw	d1,d3			/* compute height (and set N) */

return:	rts				/* return */
