#include "../h/ashelp.h"
#include "../h/ucode.h"

/******************************************************************************
* PaintArea(x, y, w, h, mask, color)
*
* Paints each bits of the rectangle of width "w" and height "h" located at 
* coordinates "x" and "y" with color, provided that the corresponding bit of
* "mask" is set.  The destanation area is clipped to the current clipping
* rectangle.
*
* C Interface:
*
*	PaintArea(x, y, w, h, mask, color)
*	int x, y, w, h;
*
* Assembly Interface:
*
*	+---------------------------------+
*	|////////////////| x              |  2 (W)
*	+---------------------------------+
*	|////////////////| y              |  6 (W)
*	+---------------------------------+
*	|////////////////| w              | 10 (W)
*	+---------------------------------+
*	|////////////////| h              | 14 (W)
*	+---------------------------------+
*	| mask                            | 16 (L)
*	+---------------------------------+
*	| color				  | 20 (W)
*	+---------------------------------+
*
******************************************************************************/

	.globl	_PaintArea

	.set x , 2+8
	.set y , 6+8
	.set w , 10+8
	.set h , 14+8
	.set mask , 16+8
	.set color , 20+8

	.text
_PaintArea:
/*
 * Create stack frame
 */
	link	a6,#0			/* establish stack frame */
	moveml	#D0_D7_A0_A4_,sp@-	/* save working registers */

/*
 * Get destination rectangle
 */
	movw	a6@(x),d0		/* get x coordinate */
	movw	a6@(y),d1		/* get y coordinate */
	movw	a6@(w),d2		/* get width */
	movw	a6@(h),d3		/* get height */

/*
 * Set up fake raster descriptor
 */
	movl	a6@(mask),fake+2	/* put in raster address */
	movw	d2,d4			/* copy width */
	movl	#0,a2			/* indicate no source */
	movl	a6@(mask),a3		/* get dest raster address */
	jsr	dispchk			/* check */
	bne	1f			/* no not going to display memory */
	addw	#31,d4			/* round up to long words */
	asrw	#5,d4			/* convert to width in words */
	aslw	#2,d4			/* width in bytes */
	jra	2f			/* and convert to bytes */
1:
	addw	#15,d4			/* round up to words */
	asrw	#4,d4			/* convert to width in words */
	aslw	#1,d4			/* width in bytes */
2:	movw	d4,fake			/* put it in the raster descriptor */

/*
 * Clip to current bounds
 */
	movw	d0,d4			/* save x coordinate before clipping */
	movw	d1,d5			/* save y coordinate before clipping */

	jsr	RClip			/* clip destination coordinates */
	ble	ptar			/* return if not visible */

/*
 * Call PaintRaster, supplying appropriate parameters
 */
	movl	a6@(color),a0		/* get address of color pattern */
	movl	a0,sp@-			/* pass color */
	movl	d3,sp@-			/* pass height */
	movl	d2,sp@-			/* pass width */
	movl	d1,sp@-			/* pass destination y coordinate */
	movl	d0,sp@-			/* pass destination x coordinate */
	movl	#_screen,sp@-		/* pass screen raster descriptor */
	subw	d5,d1			/* compute source y coordinate */
	movl	d1,sp@-			/* pass it */
	subw	d4,d0			/* compute source x coordinate */
	movl	d0,sp@-			/* pass it */
	movl	#fake,sp@-		/* pass mask raster descriptor */

	jsr	_PaintRaster		/* paint the area */

	addl	#36,sp			/* clean parameters off stack */
/*
 * Clean up stack and return
 */
ptar:	moveml	sp@+,#_D0_D7_A0_A4	/* restore registers */
	unlk	a6			/* remove stack frame */
	rts				/* return */

/*
 * raster descriptor for mask
 */
	.data
fake:	.word	0			/* width in bytes */
	.long	0			/* address of raster */
