/*
 *	Routines used to draw a random line (vector) on the screen clipped
 *	to the current clipping bounds.
 */

#include <vt_hdrs.h>
#include <gvector.h>


SetupVector(v, x, dx, dy)
register struct vector *v;
int x, dx, dy;
{
    v->x = x;
    v->dx = (dx > 0) ? dx : -dx;
    v->dy = dy;
    v->acc = (v->dx > dy) ? dy-v->dx/2 : dy/2;
    v->inc = (dx > 0) ? 1 : -1;
    v->cnt = v->dx+dy;
}



int GenerateVector(v)
register struct vector *v;
{
    if (v->dy == 0)
	v->x += (v->inc > 0) ? v->dx : -v->dx;
    else
    {
	v->acc += v->dx;
	while (v->cnt-- > 0 && v->acc > v->dy)
	{
	    v->x += v->inc;
	    v->acc -= v->dy;
	}
    }

    return (v->x);
}



