/*
 *	Routines used when drawing a filled circle or arc on the screen.  See
 *	drawa.c for origns of and explaination of algorithm.
 */

#include <vt_hdrs.h>
#include <gcircle.h>


/*
 *	Routine used to fill in a circle structure given an center point
 *	(x,y) and a radius r
 */
SetupCircle(c, x, y, r)
register struct circle *c;
int x, y, r;
{
    c->x = 0;			/* set starting point to immediate right */
    c->y = r;
    c->xc = x;			/* set center to x,y */
    c->yc = y;
    c->delta = 2-2*r;		/* initial delta movement value for drawing */
}    


/*
 * 	Routine to calculate the next point on a circle given the current
 *	point, center and delta value (see Bresenham algorithm for details) 
 */
int GenerateUpperCircle(c)
register struct circle *c;
{
    register int xo, yo;
    
    /* loop thru circle, starting at given point, until return to point */
    for (yo = c->y; c->y == yo;) {
	/* get current unmmodified x value, needed in return below */
	xo = c->x;
	/* check sign of delta value, calculate appropriate gamma value
  	 * and set new x,y,delta points accordingly - see Bresenham paper */
	if (c->delta < 0) {
	    /* check gamma value = 2*delta + 2*y - 1 */
	    if ((2*c->delta + 2*c->y - 1) <= 0) c->delta += (2 * (++c->x) + 1);
	    else c->delta += (2*((++c->x) - (--c->y)) + 2);

	} else {
	    /* check gamma value = 2*delta - 2*x - 1 */
	    if ((2*c->delta - 2*c->x - 1) > 0) c->delta += (-(2 *(--c->y)) + 1);
	    else c->delta += (2*((++c->x) - (--c->y)) + 2);
	}
    }
    /* return second to last x point */
    return(c->xc+xo);
}
    

/*
 *	Same algotihm as above except for lower half of a circle 
 */
int GenerateLowerCircle(c)
register struct circle *c;
{
    register int xo, yo;
    
    yo = c->y;
    for (xo = c->x; c->x == xo && c->y > 0;) {
	if (c->delta < 0) {
	    if (2*c->delta+2*c->y-1 <= 0) c->delta += 2*(++c->x)+1;
	    else c->delta += 2*((++c->x)-(--c->y))+2;
	} else {
	    if (2*c->delta-2*c->x-1 > 0) c->delta += -(2*(--c->y))+1;
	    else c->delta += 2*((++c->x)-(--c->y))+2;
	}
    }
    
   return(c->xc+yo);
}



