#include "../h/ashelp.h"
#include "../h/ucode.h"

/******************************************************************************
* DrawString(x, y, font, color, length, string)
*
* Draws "string" at location ("x", "y") of the screen using "font" and
* "color".  The string is terminated whenever "length" characters have been
* drawn or a null character is reached.  The string is clipped to the current
* clipping rectangle.
* NOTE: whenever mote - pixel conversions are done, 8 motes/pixel is assumed.
*
* C Interface:
*
*	DrawString(x, y, plane, color, length, string)
*	int x, y;
*	font_plane *plane;
*	COLORT color;
*	int length;
*	char *string;
*
* Assembly Interface:
*
*	+---------------------------------+
*	| ///////////////| x              |  2 (W)
*	+---------------------------------+
*	|////////////////| y              |  6 (W)
*	+---------------------------------+
*	| plane                           |  8 (L)
*	+---------------------------------+
*	| color                           | 12 (L)
*	+---------------------------------+
*	|////////////////| length         | 18 (W)
*	+---------------------------------+
*	| string                          | 20 (L)
*	+---------------------------------+
*
******************************************************************************/

	.globl	_DrawString
	.text
_DrawString:
/*
 * Create stack frame and get parameters
 */
	link	a6,#0			/* establish stack frame */
	moveml	#D0_D7_A0_A4_,sp@-	/* save working registers */

	movw	a6@(2+8),d5		/* get x coordinate */
	movw	a6@(6+8),d6		/* get y coordinate */
	movl	a6@(8+8),a0		/* get font plane descriptors address */
	movl	a6@(12+8),d0		/* get color */
	movw	a6@(18+8),d7		/* get length */
	movl	a6@(20+8),a1		/* get string address */

/*
 * Setup stack frame for PaintRaster
 */
	clrl	sp@-			/* space for pointer to char rasters */
	clrw	sp@-			/* reserve space for raster width */
	movl	d0,sp@-			/* pass color */
	clrl	sp@-			/* reserve space for height */
	clrl	sp@-			/* reserve space for width */
	clrl	sp@-			/* reserve space for destination y */
	clrl	sp@-			/* reserve space for destination x */
	movl	#_screen,sp@-		/* pass screen descriptor */
	clrl	sp@-			/* reserve space for source y */
	clrl	sp@-			/* reserve space for source x */
	movl	sp,d4			/* get copy of sp */
	addl	#32,d4			/* make pointer to character descriptor */
	movl	d4,sp@-			/* pass character descriptor */

/*
 * Draw characters until exhausted
 */
	tstw	d7			/* is it a null string */
	beq	dst2			/* exit if so */

	subqw	#1,d7			/* adjust length for dbf */

dst1:	movb	a1@+,d4			/* get a character */
	beq	dst2			/* exit loop if no more */
	andw	#0x7f,d4		/* extend to a word */
	subw	#0x20,d4		/* reduce to range 0-95 */
	bmi	3f			/* skip if not in range */
	aslw	#3,d4			/* turn it into a table index */
	lea	a0@(0,d4:W),a2		/* get dispatch entry for character */

	movb	a2@(4),d0		/* get x offset of character */
	extw	d0			/* extend to word */
#ifndef PIXELS
	aslw	#3,d0			/* * 8 to convert to motes */
#endif PIXELS
	addw	d5,d0			/* compute destination x */
	movw	d0,a3			/* save it */

	movb	a2@(5),d1		/* get y offset of character */
	extw	d1			/* extend to word */
#ifndef PIXELS
	aslw	#3,d1			/* * 8 to convert to motes */
#endif PIXELS
	addw	d6,d1			/* compute destination y */
	movw	d1,a4			/* save it */

	moveq	#0,d2			/* clear d2 */
	movb	a2@(2),d2		/* get raster width */

	movl	d2,d3			/* get copy of char width in pixels */
#ifndef PIXELS
	aslw	#3,d2			/* * 8 to convert to motes */
#endif PIXELS
#ifdef FONTS_LONGWORD
	addw	#31,d3			/* round up to a long word width */
	lsrw	#5,d3			/* pixel width in long words for char */
	aslw	#2,d3			/* pixel width in bytes */
#else FONTS_LONGWORD
	addw	#15,d3			/* round up to a word width */
	lsrw	#4,d3			/* pixel width in words for this char */
	aslw	#1,d3			/* pixel width in bytes */
#endif FONTS_LONGWORD
	movw	d3,sp@(36)		/* store in local raster descriptor */

	moveq	#0,d3			/* clear d3 */
	movb	a2@(3),d3		/* pass raster height */
#ifndef PIXELS
	aslw	#3,d3			/* * 8 to convert to motes */
#endif PIXELS

	jsr	RClip			/* clip character */
	ble	2f			/* skip drawing if not visible */

	movw	d0,sp@(18)		/* pass clipped X */
	movw	d1,sp@(22)		/* pass clipped Y */
	movw	d2,sp@(26)		/* pass clipped width */
	movw	d3,sp@(30)		/* pass clipped height */

	subw	a3,d0			/* compute x clipping offset */
	movw	d0,sp@(6)		/* pass it */
	movl	a0@(8*96+2),a3		/* get pointer to start of rasters */
	addw	a2@(6),a3		/* add character offset (bytes) */
	movl	a3,sp@(38)		/* store in raster structure */

	subw	a4,d1			/* compute y clipping offset */
	movw	d1,sp@(10)		/* pass as source y */

	jsr	_PaintRaster		/* draw the character */

    2:	moveq	#0,d4			/* clear d4 */
	movb	a2@,d4			/* get character width */
#ifndef PIXELS
	aslw	#3,d4			/* * 8 to convert to motes */
#endif PIXELS
	addw	d4,d5			/* bump destination x */

    3:	dbf	d7,dst1			/* loop until count exhausted */

dst2:	addl	#42,sp			/* remove parameters from stack */

/*
 * Cleanup and return
 */
	moveml	sp@+,#_D0_D7_A0_A4	/* restore working registers */
	unlk	a6			/* unlink stack frame */
	rts				/* return */
