#include "../h/ashelp.h"
#include "../h/ucode.h"

/******************************************************************************
* DrawRectangleInterior(x, y, w, h, color, pat, xphase, yphase)
*
* Fills the interior of the rectangle located at ("x", "y") on the screen
* and having width "w" and height "h" with "color/pat".  "Xphase" and "yphase"
* specify the relationship of the shading pattern to the screen.  The effect
* is that if the point ("xphase", "yphase") were visible, the upper left
* corner of the shading pattern would appear there.  The interior is clipped
* to the current clipping rectangle.
*
* C Interface:
*
*	DrawRectangleInterior(x, y, w, h, color, pat, xphase, yphase)
*	int x, y, w, h, xphase, yphase;
*	PATTERN pat;
*	COLORT	color;
*
* Assembly Interface:
*
*	+---------------------------------+
*	|////////////////| x              |  2 (W)
*	+---------------------------------+
*	|////////////////| y              |  6 (W)
*	+---------------------------------+
*	|////////////////| w              | 10 (W)
*	+---------------------------------+
*	|////////////////| h              | 14 (W)
*	+---------------------------------+
*	| color                           | 16 (L)
*	+---------------------------------+
*	| pat                             | 20 (L)
*	+---------------------------------+
*	|////////////////| xphase         | 26 (W)
*	+---------------------------------+
*	|////////////////| yphase         | 30 (W)
*	+---------------------------------+
*
******************************************************************************/

	.globl	_DrawRectangleInterior

	.set x , 2+8
	.set y , 6+8
	.set w , 10+8
	.set h , 14+8
	.set color , 16+8
	.set pat , 20+8
	.set xphase , 26+8
	.set yphase , 30+8

	.text
_DrawRectangleInterior:
	link	a6,#0			/* create new stack frame */
	moveml	#D0_D7_A0_A1_,sp@-	/* save working registers */
/*
 * Fetch and clip bounds
 */
	movw	a6@(x),d0		/* get X coordinate */
	movw	a6@(y),d1		/* get Y coordiante */
	movw	a6@(w),d2		/* get width */
	movw	a6@(h),d3		/* get height */

	jsr	RClip			/* clip them */
	ble	rplr			/* return if rectangle not visible */

/*
 * Fetch shading, check for solid colors
 */
	movl	a6@(pat),a1		/* get pattern address */
	cmpl	#_invert,a1		/* check for kludge invert pattern */
	beq	invert			/* then go do invert */
	movw	a1@+,d4			/* get color, point to pattern */
	bge	solid			/* branch if solid color */

#ifdef COLOR
	movl	#0,sp@-			/* pass 0 as the color */
	movl	d3,sp@-			/* pass clipped height */
	movl	d2,sp@-			/* pass clipped width */
	movl	d1,sp@-			/* pass clipped Y coordinate */
	movl	d0,sp@-			/* pass clipped X coordinate */
	movl	#_screen,sp@-		/* pass screen raster descriptor */
	jsr	_ClearRaster		/* fill the rectangle */
	addw	#24,sp			/* remove parameters from stack */
#endif
/*
 * Fill rectangle with a pattern
 */
	movl	a6@(yphase-2),sp@-	/* pass Y phase to CopyPattern */
	movl	a6@(xphase-2),sp@-	/* pass X phase */
	movl	a1,sp@-			/* pass address of pattern */
	movl	d3,sp@-			/* pass height */
	movl	d2,sp@-			/* pass width */
	movl	d1,sp@-			/* pass Y coordinate */
	movl	d0,sp@-			/* pass X coordinate */
	movl	#_screen,sp@-		/* pass screen raster descriptor */
	jsr	_CopyPattern		/* fill the rectangle */
	addw	#32,sp			/* clean off stack */

	bra	rplr			/* return */

/*
 * Fill rectangle with a solid color
 */
solid:	
	movl	a6@(color),d4		/* get color address */
	movl	d4,sp@-			/* and pass to ClearRaster */
	movl	d3,sp@-			/* pass clipped height */
	movl	d2,sp@-			/* pass clipped width */
	movl	d1,sp@-			/* pass clipped Y coordinate */
	movl	d0,sp@-			/* pass clipped X coordinate */
	movl	#_screen,sp@-		/* pass screen raster descriptor */
	jsr	_ClearRaster		/* fill the rectangle */
	addw	#24,sp			/* remove parameters from stack */
	bra	rplr			/* return */
/*
 * Invert rectangle
 */
invert:
	movl	d3,sp@-			/* pass clipped height */
	movl	d2,sp@-			/* pass clipped width */
	movl	d1,sp@-			/* pass clipped Y coordinate */
	movl	d0,sp@-			/* pass clipped X coordinate */
	movl	#_screen,sp@-		/* pass screen raster descriptor */
	jsr	_InvertRaster		/* invert the rectangle */
	addw	#20,sp			/* remove parameters from stack */

/*
 * Clean up stack and return
 */
rplr:	moveml	sp@+,#_D0_D7_A0_A1	/* restore working registers */
	unlk	a6			/* unlink stack frame */
	rts				/* and return */
