#include "../h/ashelp.h"
#include "../h/ucode.h"

/******************************************************************************
* DrawRectangleBorder(x, y, w, h, t, color, pat, xphase, yphase)
*
* Draws the border of thickness "t" around the rectangle of width "w" and
* height "h" located at ("x", "y") on the screen.  The color of the border is
* specified by "color".  The border is drawn on the outside of the rectangle.
*
* C Interface:
*
*	DrawRectangleBorder(x, y, w, h, t, color, pat, xphase, yphase)
*	int x, y, w, h, t;
*	COLORT color;
*	PATTERN pat;
*	int	xphase, yphase;
*
* Assembly Interface:
*
*	+---------------------------------+
*	|////////////////| x              |  2 (W)
*	+---------------------------------+
*	|////////////////| y              |  6 (W)
*	+---------------------------------+
*	|////////////////| w              | 10 (W)
*	+---------------------------------+
*	|////////////////| h              | 14 (W)
*	+---------------------------------+
*	|////////////////| t              | 18 (W)
*	+---------------------------------+
*	| color                           | 20 (L)
*	+---------------------------------+
*	| pattern                         | 24 (L)
*	+---------------------------------+
*	|////////////////| xphase         | 30 (W)
*	+---------------------------------+
*	|////////////////| yphase         | 34 (W)
*	+---------------------------------+
*
******************************************************************************/

	.globl	_DrawRectangleBorder

	.set x , 2+8
	.set y , 6+8
	.set w , 10+8
	.set h , 14+8
	.set t , 18+8
	.set color , 20+8
	.set pat , 24+8
	.set xph , 30+8
	.set yph , 34+8

	.text
_DrawRectangleBorder:
/*
 * Setup stack frame
 */
	link	a6,#0			/* create new stack frame */
	moveml	#D0_D5_A0_,sp@-	/* save registers */

/*
 * Get C parameters 
 */
	movw	a6@(x),d0		/* get x coordinate */
	movw	a6@(y),d1		/* get y coordinate */
	movw	a6@(w),d2		/* get width */
	movw	a6@(h),d3		/* get height */
	movw	a6@(t),d4		/* get thickness */
	movl	a6@(color),d5

/*
 * Setup stack frame for ClearRaster
 */
	movl	d5,sp@-			/* push color */
	subl	#16,sp			/* leave room for x, y, w, h */
	movl	#_screen,sp@-		/* push screen raster descriptor */

/*
 * Draw the top side
 */
	movw	a6@(x),d0		/* get rectangle x coordinate */
	subw	a6@(t),d0		/* compute border x */
	movw	a6@(y),d1		/* get rectangle y coordinate */
	subw	a6@(t),d1		/* compute border y */
	movw	a6@(t),d2		/* get border thickness */
	aslw	#1,d2			/* double it */
	addw	a6@(w),d2		/* compute border width */
	movw	a6@(t),d3		/* get border height */

	jsr	RClip			/* clip to clipping rectangle */
	ble	1f			/* jump if nothing visible */
	
	movw	d0,sp@(6)		/* pass x to ClearRaster */
	movw	d1,sp@(10)		/* pass y */
	movw	d2,sp@(14)		/* pass width */
	movw	d3,sp@(18)		/* pass height */

	jsr	_ClearRaster		/* draw the top side */

/*
 * Draw the bottom side
 */
    1:	movw	a6@(x),d0		/* get rectangle x coordinate */
	subw	a6@(t),d0		/* compute border x */
	movw	a6@(y),d1		/* get rectangle y coordinate */
	addw	a6@(h),d1		/* compute border y */
	movw	a6@(t),d2		/* get border thickness */
	aslw	#1,d2			/* double it */
	addw	a6@(w),d2		/* compute border width */
	movw	a6@(t),d3		/* get border height */

	jsr	RClip			/* clip to clipping rectangle */
	ble	2f			/* jump if nothing visible */

	movw	d0,sp@(6)		/* pass x to ClearRaster */
	movw	d1,sp@(10)		/* pass y */
	movw	d2,sp@(14)		/* pass width */
	movw	d3,sp@(18)		/* pass height */

	jsr	_ClearRaster		/* draw bottom side */

/*
 * Draw the left side
 */
    2:	movw	a6@(x),d0		/* get x coordinate of rectangle */
	subw	a6@(t),d0		/* compute x of side */
	movw	a6@(y),d1		/* get y coordinate of side */
	movw	a6@(t),d2		/* get width of side */
	movw	a6@(h),d3		/* get height of side */

	jsr	RClip			/* clip to clipping rectangle */
	ble	3f			/* jump if nothing visible */

	movw	d0,sp@(6)		/* pass x to ClearRaster */
	movw	d1,sp@(10)		/* pass y */
	movw	d2,sp@(14)		/* pass width */
	movw	d3,sp@(18)		/* pass height */

	jsr	_ClearRaster		/* draw left side */

/*
 * Draw the right side
 */
    3:	movw	a6@(x),d0		/* get x coordinate of rectangle */
	addw	a6@(w),d0		/* compute x of side */
	movw	a6@(y),d1		/* get y coordinate of side */
	movw	a6@(t),d2		/* get width of side */
	movw	a6@(h),d3		/* get height of side */

	jsr	RClip			/* clip to clipping rectangle */
	ble	4f			/* jump if nothing visible */

	movw	d0,sp@(6)		/* pass x to ClearRaster */
	movw	d1,sp@(10)		/* pass y */
	movw	d2,sp@(14)		/* pass width */
	movw	d3,sp@(18)		/* pass height */
	jsr	_ClearRaster		/* draw right side */

/*
 * Remove parameters from stack
 */
    4:	addl	#24,sp			/* remove 6 parameters */

/*
 * Clean up stack and return
 */
	moveml	sp@+,#_D0_D5_A0	/* restore registers */
	unlk	a6			/* remove stack frame */
	rts				/* return */
