#include "../h/ashelp.h"

/******************************************************************************
* CharacterWidth(font, character)
*
* Returns the width in pixels of "character" in "font".
*
* C Interface:
*
*	int CharacterWidth(font, character)
*	FONT font;
*	char character;
*
* Assembly Interface:
*
*	+---------------------------------+
*	| font                            |  0 (L)
*	+---------------------------------+
*	|////////////////| character      |  6 (W)
*	+---------------------------------+
*
******************************************************************************/

	.globl	_CharacterWidth
	.text
_CharacterWidth:
/*
 * Create stack frame and get parameters
 */
	link	a6,#0			/* create stack frame */
	moveml	#A0_,sp@-		/* save working registers */

	movl	a6@(8),a0		/* get font address */
	movb	a6@(7+8),d0		/* get character code */

/*
 * Lookup character width in font
 */
	andw	#0xFF,d0		/* strip high bits of character */
	aslw	#3,d0			/* compute offset in info table */
	lea	a0@(8,d0:w),a0		/* compute address of table entry */
	movb	a0@,d0			/* retrieve the width */
	extw	d0			/* extend to word */
	extl	d0			/* extend to long for C */

/*
 * Cleanup and return
 */
	moveml	sp@+,#_A0		/* restore working registers */
	unlk	a6			/* unlink stack frame */
	rts				/* return */
