/******************************************************************************
* ClearArea(x, y, w, h, color)
*
* Fills the rectangular area of width "w" and height "h" located at ("x", "y")
* on the screen with "color".  No clipping is done.
*
* C Interface:
*
*	ClearArea(x, y, w, h, color)
*	int x, y, w, h;
*	COLOR color;
*
* Assembly Interface:
*
*	+---------------------------------+
*	|////////////////| x              |  2 (W)
*	+---------------------------------+
*	|////////////////| y              |  6 (W)
*	+---------------------------------+
*	|////////////////| w              | 10 (W)
*	+---------------------------------+
*	|////////////////| h              | 14 (W)
*	+---------------------------------+
*	| color                           | 16 (L)
*	+---------------------------------+
*
******************************************************************************/

	.globl	_ClearArea
	.text
_ClearArea:
/*
 * Create stack frame
 */
	link	a6,#0			/* establish stack frame */
	movl	a0,sp@-			/* save register */

/*
 * Pass parameters to ClearRaster, supplying a screen raster descriptor
 */
	movl	a6@(16+8),a0		/* get color */
	movl	a0,sp@-			/* pass color portion */
	movl	a6@(12+8),sp@-		/* pass height */
	movl	a6@(8+8),sp@-		/* pass width */
	movl	a6@(4+8),sp@-		/* pass y coordinate */
	movl	a6@(0+8),sp@-		/* pass x coordinate */
	movl	#_screen,sp@-		/* pass screen raster descriptor */

	jsr	_ClearRaster		/* clear the area */

	addl	#24,sp			/* clean parameters off stack */

/*
 * Clean up stack and return
 */
	movl	sp@+,a0			/* restore register */
	unlk	a6			/* remove stack frame */
	rts				/* return */
