#include "../h/ashelp.h"

/******************************************************************************
* CharacterHeight(font, character)
*
* Returns the height in pixels of "character" in "font".
*
* C Interface:
*
*	int CharacterHeight(font, character)
*	FONT font;
*	char character;
*
* Assembly Interface:
*
*	+---------------------------------+
*	| font                            |  0 (L)
*	+---------------------------------+
*	|////////////////| character      |  6 (W)
*	+---------------------------------+
*
******************************************************************************/

	.globl	_CharacterHeight
	.text
_CharacterHeight:
/*
 * Create stack frame and get parameters
 */
	link	a6,#0			/* create stack frame */
	moveml	#A0_,sp@-		/* save working registers */

	movl	a6@(8),a0		/* get font address */
	movb	a6@(7+8),d0		/* get character code */

/*
 * Lookup character height for font
 */
	movb	a0@(6),d0		/* retrieve the height */
	extw	d0			/* extend to word */
	extl	d0			/* extend to long for C */

/*
 * Cleanup and return
 */
	moveml	sp@+,#_A0		/* restore working registers */
	unlk	a6			/* unlink stack frame */
	rts				/* return */
