#include "../h/ashelp.h"

/******************************************************************************
* CharacterBaseline(font, character)
*
* Returns the baseline in pixels of "character" in "font".  This is the number
* of pixels from the top of the character cell to the baseline.
*
* C Interface:
*
*	int CharacterBaseline(font, character)
*	FONT font;
*	char character;
*
* Assembly Interface:
*
*	+---------------------------------+
*	| font                            |  0 (L)
*	+---------------------------------+
*	|////////////////| character      |  6 (W)
*	+---------------------------------+
*
******************************************************************************/

	.globl	_CharacterBaseline
	.text
_CharacterBaseline:

/*
 * Create stack frame and get parameters
 */
	link	a6,#0			/* create stack frame */
	moveml	#A0_,sp@-		/* save working registers */

	movl	a6@(8),a0		/* get font address */
	movb	a6@(7+8),d0		/* get character code */

/*
 * Lookup character baseline for font
 */
	movb	a0@(7),d0		/* retrieve the y reference point */
	negb	d0			/* make positive */
	extw	d0			/* extend to word */
	extl	d0			/* extend to long for C */

/*
 * Cleanup and return
 */
	moveml	sp@+,#_A0		/* restore working registers */
	unlk	a6			/* unlink stack frame */
	rts				/* return */
