/*
 *	This file gives the defines used within the kernel and the screen
 *	primatives to manipulate the bitmap screen.
 */

/*
 *	This file defines the typedefs used for refreance screen types 
 */
#ifndef _VT_TYPES
#define _VT_TYPES

#ifdef KERNEL
/* kernel type defs */

/* fonts, colors, windows, patterns and panes */
typedef unsigned short	Font;
typedef struct window * WINDOW;
typedef int	    	PANE;
typedef	int	    *	PATTERN;
typedef int	    COLORT;

#else
/* process type defs */

/* fonts, colors, windows, patterns and panes */
typedef unsigned short	VT_FONTID;	    /* ID for a particular font */
typedef	int		VT_WINDOW;	    /* window = file descriptor */
typedef	unsigned char	VT_PANEID;	    /* pane window, same as kernel */
typedef	long		*VT_PATTERN;	    /* pointer to bit pattern */
typedef short		VT_COLOR;	    /* index for a particular color */
typedef	short		VT_NOTE;	    /* speaker note */

#endif

/* structure to hold pixels */
typedef struct
{
    short    width;
    short   *address;
} RASTER;

#endif

