/*
 *	This file declares all of the needed space for variables used with
 *	virtual terminals.
 */
 
#include "../h/types.h"		/* kernel type defs */
#include "../h/errno.h"		/* error defines */
#include "../vt/vt_hdrs.h"	/* virtual terminal parameters */
#include "../vt/vt_output.h"	/* vt output defines */
#include "../vt/vt_kernel.h"	/* kernel only vt defines */
#include "../vt/vt_key.h"	/* external virtual key names */

#ifdef COLOR
short	globallut[LUTSIZE];	/* global lookup table */
#endif COLOR
char 		*copybuf;	/* pointer to copy/insert buffer */
char 		*vtpool;	/* pointer to freespace vt pool */
struct	tty	vt_tty[NVT+1];	/* virtual terminal array for sys   */
struct	mark	vt_marks[NVT+1];/* mark structures */
char	markneeded, markrunning;

			    /* virtual terminal that has mouse, keyboard */
int			mactive, kactive;

			/* system loaded colors and color table */
int *			v_color[NCOLOR] = { white,black,gray50,gray25, gray75,
					    gray12,gray87,gray37,gray62,invert };

			/* storage for icon pixel maps */
int			iconf[NISTYLES][128];
int			iconm[NISTYLES][128];

			/* system loaded icon table */
int *			v_icon[] = {0, 0, uarrow, darrow, larrow, rarrow,
					ulcorner, smooth, blast, lrcorner,
					};

struct		itable  v_itable[NICON];

		    /* structure for status line */
struct statline v_status;

		    /* structure for popup menus */
struct popquiz popquiz;

		    /* structure for cursor tracking box */
struct trackcursor trackcursor;

		   /* Mouse response curve */
unsigned char	Mdelta		= 1; 
unsigned char	mousetab[VT_MTABSIZE+1] = {
0,   
 1,  2,  3,  4,  5,  6,  7,  8,  9, 10,
11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
21, 22, 23, 24, 25, 26, 27, 28, 29, 30,
31, 
/* use linear response for higher deltas */ 0
};
