/*
 *	These file defines the incomming keycode values for a standard
 *	IWS keyboard for the shift,control and mouse keys.  These will
 * 	be different on each different keyboard.
 */

#ifndef _VT_KEYIN
#define _VT_KEYIN

#define	    LSHIFTDN	0x68	/* left shift down */
#define	    LSHIFTUP	0xe8	/* left shift up */
#define	    RSHIFTDN	0x37	/* right shift down */
#define	    RSHIFTUP	0xb7	/* right shift up */
#define	    MMIDDLEDN	0x76	/* mouse middle down */
#define	    MMIDDLEUP	0xf6	/* mouse middle up */
#define	    LCTRLDN     0x2b	/* left control down */
#define	    LCTRLUP	0xab	/* left control up */
#define	    RCTRLDN	0x45	/* right control down */
#define	    RCTRLUP	0xc5	/* right control up */
#define	    MRIGHTDN	0x77	/* mouse right down */
#define	    MRIGHTUP	0xf7	/* mouse right up */
#define	    CAPSDN	0x6b	/* caps lock key down */
#define	    CAPSUP	0xeb    /* caps lock key up */
#define	    MLEFTDN	0x75	/* mouse left button down */
#define	    MLEFTUP	0xf5	/* mouse left button up */

#define	    REPEAT	0x80	/* repeat code from iopp */

/*
 *	The following are different bits set in the physical terminal used
 *	to determine the keyboard state 
 */
#define 	M_LEFT		0x01	/* left mouse key down */
#define 	L_SHIFT		0x02	/* left shift down */
#define 	R_SHIFT		0x04	/* right shift down */
#define		M_MIDDLE	0x08	/* middle mouse key down */
#define 	M_RIGHT		0x10	/* right mouse key down */
#define 	L_CTRL		0x20	/* left control down */
#define		R_CTRL		0x40	/* right control down */
#define		CAPS_LOCK	0x80    /* caps lock key is down */


#endif
