#ifndef _VT_KEY
#define _VT_KEY


/* 
 * Output byte-stream definitions
 */

#define CS_DISPLAY_TOKEN	0x93	/* begin output sequence */


/*
 * Simple ASCII input identifier.
 */
#define VT_INPUT_SIMPLE		0x00	/* Simple 8 bit keystroke sent */
 
/*
 * Token codes for other than simple input.
 */
#define VT_NORMAL	'['	/* Escape sequences for non-shifted */
#define VT_SHIFTED	'O'	/* Escape sequences for shifted */
#define VT_CONTROL	'P'	/* Escape sequences for control'ed */
#define VT_SHFTCTRL	'R'	/* Escape sequences for shifted & control'ed */
#define VT_ARROWKEYS	'Z'	/* Arrow key type needed for cursor key mode */

#define VT_HARDKEY		VT_ESC	/* Mouse input report follows */
#define VT_MOUSE		0x9d	/* Mouse input report follows */

/*
 * Names used for mouse button state.  Mouse coordinates reported as
 *	VT_INPUT_MOUSE, button-state, pane-number-high-byte, 
 *	pane-number-low-byte, X-high-byte, X-low-byte,
 *	Y-high-byte, Y-low-byte.
 */
#define	VT_MOUSE_LEFT		0x01	/* left mouse button */
#define	VT_MOUSE_MIDDLE		0x02	/* middle mouse button */
#define	VT_MOUSE_RIGHT		0x04	/* right mouse button */
#define	VT_MOUSE_DOWN		0x10	/* up to down transition */
#define	VT_MOUSE_UP		0x20	/* down to up transition */
#define	VT_MOUSE_NOBUTTON	0x40	/* no button transition occured */
#define	VT_MOUSE_CONTINUOUS	0x80	/* wants continuous mouse coords */

/*
 * Virtual Keyboard key names loaded into translation tables upon 
 * power up.
 *
 * Layout of the character codes:
 *
 */
		/* numeric pad keys */
#define	    VT_PAD0	     0		/* num lock key */
#define	    VT_PAD1	     1		/* undo key */
#define	    VT_PAD2	     2		/* / key */
#define	    VT_PAD3	     3		/* * key */
#define	    VT_PAD4	     4		/* prev/7 key */
#define	    VT_PAD5	     5		/* up/8 key */
#define	    VT_PAD6	     6		/* next/9 key */
#define	    VT_PAD7	     7		/* - key */
#define	    VT_PAD8	     8		/* left/4 key */
#define	    VT_PAD9	     9		/* find/5 key */
#define	    VT_PAD10	     10		/* right/6 key */
#define	    VT_PAD11	     11		/* + key */
#define	    VT_PAD12	     12		/* begin/1 key */
#define	    VT_PAD13	     13		/* down/2 key */
#define	    VT_PAD14	     14		/* end/3 key */
#define	    VT_PAD15	     15		/* enter key */
#define	    VT_PAD16	     16		/* insert/0 key */
#define	    VT_PAD17	     17		/* del/. key */
#define	    VT_PADNOSCRL     18		/* no-scroll key */

	/* names for the arrow keys */
#define	    VT_UPARROW	     'A' 		/* up arrow key */
#define	    VT_LEFTARROW     'D' 		/* left arrow key */
#define	    VT_RIGHTARROW    'C' 		/* right arrow key */
#define	    VT_DOWNARROW     'B' 		/* down arrow key */
		/* Normal ASCII Keys */
	/* Standard ASCII codes */
#define VT_NUL		0x00	/* ASCII Null NUL code */
#define VT_SOH		0x01	/* ASCII Start of header SOH code */
#define VT_STX		0x02	/* ASCII Start of text STX code */
#define VT_ETX		0x03	/* ASCII End of text ETX code */
#define VT_EOT		0x04	/* ASCII End of transmission EOT code */
#define VT_ENQ		0x05	/* ASCII Enquiry ENQ code */
#define VT_ACK		0x06	/* ASCII Acknowledge ACK code */
#define VT_BEL		0x07	/* ASCII Bell BEL code */
#define VT_BS		0x08	/* ASCII Backspace BS code */
#define VT_HT		0x09	/* ASCII Horizontal tab HT code */
#define VT_LF		0x0A	/* ASCII Line feed (newline) LF code */
#define VT_VT		0x0B	/* ASCII Vertical tab VT code */
#define VT_FF		0x0C	/* ASCII Form feed FF code */
#define VT_CR		0x0D	/* ASCII Carrige return CR code */
#define VT_SO		0x0E	/* ASCII Shift out SO code */
#define VT_SI		0x0F	/* ASCII Shift in SI code */
#define VT_DLE		0x10	/* ASCII Data link escape DLE code */
#define VT_DC1		0x11	/* ASCII Xon DC1 code */
#define VT_DC2		0x12	/* ASCII Tape on DC2 code */
#define VT_DC3		0x13	/* ASCII Xoff DC3 code */
#define VT_DC4		0x14	/* ASCII Tape off DC4 code */
#define VT_NAK		0x15	/* ASCII Negative acknowledge NAK code */
#define VT_SYN		0x16	/* ASCII Synchronous idle SYN code */
#define VT_ETB		0x17	/* ASCII End of text buffer ETB code */
#define VT_CAN		0x18	/* ASCII Cancel CAN code */
#define VT_EM		0x19	/* ASCII End of medium EM code */
#define VT_SUB		0x1A	/* ASCII Substitute SUB code */
#define VT_ESC		0x1B	/* ASCII Escape ESC code */
#define VT_FS		0x1C	/* ASCII File seperator FS code */
#define VT_GS		0x1D	/* ASCII Group seperator GS code */
#define VT_RS		0x1E	/* ASCII Record seperator RS code */
#define VT_US		0x1F	/* ASCII Unit seperator US code */
#define VT_SPACE	0x20	/* Space ' ' code */
#define VT_EXCLAIM	0x21	/* Exclamation mark '!' code */
#define VT_DQUOTE	0x22	/* Double quote '"' code */
#define VT_POUND	0x23	/* Pound sign '#' code */
#define VT_DOLLAR	0x24	/* Dollar sign '$' code */
#define VT_PERCENT	0x25	/* Percent sign '%' code */
#define VT_AMPERSAND	0x26	/* Ampersand '&' code */
#define VT_APOSTROPHE	0x27	/* Apostrophe ''' code */
#define VT_LPAREN	0x28	/* Left parenthesis '(' code */
#define VT_RPAREN	0x29	/* Right parenthesis ')' code */
#define VT_ASTERISK	0x2A	/* Asterisk '*' code */
#define VT_PLUS		0x2B	/* Plus sign '+' code */
#define VT_COMMA	0x2C	/* Comma ',' code */
#define VT_MINUS	0x2D	/* Minus sign '-' code */
#define VT_PERIOD	0x2E	/* Period (Decimal point) '.' code */
#define VT_SLASH	0x2F	/* Slash '/' code */
#define VT_ZERO		0x30	/* Digit zero '0' code */
#define VT_ONE		0x31	/* Digit one '1' code */
#define VT_TWO		0x32	/* Digit two '2' code */
#define VT_THREE	0x33	/* Digit three '3' code */
#define VT_FOUR		0x34	/* Digit four '4' code */
#define VT_FIVE		0x35	/* Digit five '5' code */
#define VT_SIX		0x36	/* Digit six '6' code */
#define VT_SEVEN	0x37	/* Digit seven '7' code */
#define VT_EIGHT	0x38	/* Digit eight '8' code */
#define VT_NINE		0x39	/* Digit nine '9' code */
#define VT_COLON	0x3A	/* Colon ':' code */
#define VT_SEMICOLON	0x3B	/* Semicolon ';' code */
#define VT_LESSTHAN	0x3C	/* Less than '<' code */
#define VT_EQUALS	0x3D	/* Equals sign '=' code */
#define VT_GREATERTHAN	0x3E	/* Greater than '>' code */
#define VT_QUESTION	0x3F	/* Question mark '?' code */
#define VT_AT		0x40	/* Commercial at sign '@' code */
#define VT_UPPER_A	0x41	/* Uppercase a 'A' code */
#define VT_UPPER_B	0x42	/* Uppercase b 'B' code */
#define VT_UPPER_C	0x43	/* Uppercase c 'C' code */
#define VT_UPPER_D	0x44	/* Uppercase d 'D' code */
#define VT_UPPER_E	0x45	/* Uppercase e 'E' code */
#define VT_UPPER_F	0x46	/* Uppercase f 'F' code */
#define VT_UPPER_G	0x47	/* Uppercase g 'G' code */
#define VT_UPPER_H	0x48	/* Uppercase h 'H' code */
#define VT_UPPER_I	0x49	/* Uppercase i 'I' code */
#define VT_UPPER_J	0x4A	/* Uppercase j 'J' code */
#define VT_UPPER_K	0x4B	/* Uppercase k 'K' code */
#define VT_UPPER_L	0x4C	/* Uppercase l 'L' code */
#define VT_UPPER_M	0x4D	/* Uppercase m 'M' code */
#define VT_UPPER_N	0x4E	/* Uppercase n 'N' code */
#define VT_UPPER_O	0x4F	/* Uppercase o 'O' code */
#define VT_UPPER_P	0x50	/* Uppercase p 'P' code */
#define VT_UPPER_Q	0x51	/* Uppercase q 'Q' code */
#define VT_UPPER_R	0x52	/* Uppercase r 'R' code */
#define VT_UPPER_S	0x53	/* Uppercase s 'S' code */
#define VT_UPPER_T	0x54	/* Uppercase t 'T' code */
#define VT_UPPER_U	0x55	/* Uppercase u 'U' code */
#define VT_UPPER_V	0x56	/* Uppercase v 'V' code */
#define VT_UPPER_W	0x57	/* Uppercase w 'W' code */
#define VT_UPPER_X	0x58	/* Uppercase x 'X' code */
#define VT_UPPER_Y	0x59	/* Uppercase y 'Y' code */
#define VT_UPPER_Z	0x5A	/* Uppercase z 'Z' code */
#define VT_LSQUARE	0x5B	/* Left square bracket '[' code */
#define VT_BSLASH	0x5C	/* Backslash '\' code */
#define VT_RSQUARE	0x5D	/* Right square bracket ']' code */
#define VT_CARAT	0x5E	/* Carat mark '^' code */
#define VT_UNDERSCORE	0x5F	/* Underscore '_' code */
#define VT_GRAVE	0x60	/* Accent grave mark '`' code */
#define VT_LOWER_A	0x61	/* Lowercase a 'a' code */
#define VT_LOWER_B	0x62	/* Lowercase b 'b' code */
#define VT_LOWER_C	0x63	/* Lowercase c 'c' code */
#define VT_LOWER_D	0x64	/* Lowercase d 'd' code */
#define VT_LOWER_E	0x65	/* Lowercase e 'e' code */
#define VT_LOWER_F	0x66	/* Lowercase f 'f' code */
#define VT_LOWER_G	0x67	/* Lowercase g 'g' code */
#define VT_LOWER_H	0x68	/* Lowercase h 'h' code */
#define VT_LOWER_I	0x69	/* Lowercase i 'i' code */
#define VT_LOWER_J	0x6A	/* Lowercase j 'j' code */
#define VT_LOWER_K	0x6B	/* Lowercase k 'k' code */
#define VT_LOWER_L	0x6C	/* Lowercase l 'l' code */
#define VT_LOWER_M	0x6D	/* Lowercase m 'm' code */
#define VT_LOWER_N	0x6E	/* Lowercase n 'n' code */
#define VT_LOWER_O	0x6F	/* Lowercase o 'o' code */
#define VT_LOWER_P	0x70	/* Lowercase p 'p' code */
#define VT_LOWER_Q	0x71	/* Lowercase q 'q' code */
#define VT_LOWER_R	0x72	/* Lowercase r 'r' code */
#define VT_LOWER_S	0x73	/* Lowercase s 's' code */
#define VT_LOWER_T	0x74	/* Lowercase t 't' code */
#define VT_LOWER_U	0x75	/* Lowercase u 'u' code */
#define VT_LOWER_V	0x76	/* Lowercase v 'v' code */
#define VT_LOWER_W	0x77	/* Lowercase w 'w' code */
#define VT_LOWER_X	0x78	/* Lowercase x 'x' code */
#define VT_LOWER_Y	0x79	/* Lowercase y 'y' code */
#define VT_LOWER_Z	0x7A	/* Lowercase z 'z' code */
#define VT_LCURLEY	0x7B	/* Left curley brace '{' code */
#define VT_VBAR		0x7C	/* Vertical bar '|' code */
#define VT_RCURLEY	0x7D	/* Right curley brace '}' code */
#define VT_TILDE	0x7E	/* Tilde '~' code */
#define VT_DEL		0x7F	/* Delete DEL code */

#endif _VT_KEY
