/*
 *	These are all the structures/defines used by the vt kernel driver.
 *	None of these are shared with processes outside the kernel
 */

#ifndef _VT_KERNEL
#define _VT_KERNEL

#include "../is68k/defs.h"
#include "../vt/vt_key.h"
#include "../h/tty.h"

extern char * 	vtpool;	    /* pointer to freespace pool in vt_space.c */

/*
 * Timeout length in seconds for vtread call.
 * A read on the VT will wait this many seconds 
 * before waking itself up to check for any characters
 * in the canonical queue missed because of interrupt timing.
 */
/* #define VT_READ_TIMEOUT		2	/* No. of seconds before checking */
/*
 * different defines used with the translation tables
 */
#define	    PLANE0  0		/* base english character plane internel id */
#define	    BADCODE 0xff	/* illegal code, do not use	            */

/*
 *	Console size defines
 */
#define CONSW	    880
#define CONSH	    385
/* 
 *	dimensions of status line 
 */
#ifdef TWS
#define SYSY	    741		/* top pixel of status line */
#define SYSW	    1024	/* width and height */
#endif TWS
#ifdef GWS
#define SYSY	    997		/* top pixel of status line */
#define SYSW	    1280	/* width and height */
#endif GWS
#define SYSH	    25
#define SYST	    2		/* border thickness */
#define SYSL	    128		/* max # displayable chars */

/*
 *	defines used with key code translation tables
 */

#ifdef GWS
#define	NKEYS		128	/* max number of keys on keyboard */
#define NPADKEYS	19	/* number of keys on the numeric pad + noscrl */
#endif GWS
#ifdef TWS
#define	NKEYS		118	/* max number of keys on keyboard */
#define NPADKEYS	18	/* max number of keys on the numeric pad */
#endif TWS

#define K_PC     	0	/* PC keyboard */
#define K_STANDARD	1	/* standard keyboard */
#define K_MOUSEMATE     2	/* mousemate keyboard */
#define ICONNAME	32	/* 32 chars in icon name */

struct mark {
    short	req;
    short	x, y;
};
	/* defines for the mark's request data */
#define MARKING	0x8000
#define CANCEL	0x0001
#define DEFAULT	0x0002
#define POPUP	0x0010
#define MARK	0x0020

struct statline {	
    bool		visible;
    unsigned char	message[SYSL];
};
		  
struct popquiz {
    char	buffer[127];
    char	*choice[VT_NCHOICES];
    short	n, current, buttons, baseline, cheight;
    WINDOW	win;
};

struct trackcursor {
    short	type;
    short	xoffset, yoffset;
    short	x, y, w, h;
    short	thickness;
};

/*
 * 	Structure is used to hold the number of arguments needed 
 * 	in a given output escape sequence
*/
struct seqcall {
    char    numa;	/* number of arguments needed */
    int	    (*func)();  /* pointer to escape sequence function */
};

/*
 * 	Structures to define the format of the system wide translation
 * 	tables.  These are used in vtcharin to convert an input keycodes to
 * 	to character codes
*/

struct	value	    {		/* format of single entry in trans_tab */
    unsigned char   c1;		/* low byte */
    unsigned char   c2;		/* high byte */
};

struct	trans_tab   {		/* single translation table */
    struct  value   val[NKEYS];	/* all the values needed    */
};

struct  padtrans_tab {
    struct  value   val[NPADKEYS];	/* all the values needed    */
};

/*
 *	Structure used to hold the icons which the user
 *	agent places upon the desktop.
 */
struct itable {
    short *	maddr;			/* address of mask bit pattern */
    short *	iaddr;			/* address of icon bit pattern */
    short	x, y;			/* upper left corner */
    short	w, h;			/* width & height */
    COLORT	fcol;		    	/* foreground/backgound color */
    COLORT	bcol;
    short	lx, ly;			/* name upper left corner */
    short	lw, lh;			/* name width & height */
    char	name[ICONNAME];    	/* title of icon */
};

/* 
 *	termsw and keybsw are the tables that control entry into terminal 
 *	emulators, and keyboard drivers.
 */

struct termsw {
	char	*name;
	int	(*t_init)();
	int	(*t_disp)();
	int	(*t_ioctl)();
	int	(*t_font)();
	int	(*t_exit)();
	int	(*t_bufon)();
	int	(*t_bufoff)();
	int	(*t_mark)();
	int	(*t_mstop)();
};

/*
 * defines for mark cmd operations
 */

#define MARK_CANCEL	0	/* unmark any marked region		*/
#define MARK_REGION	1	/* start/continue marking at (x,y)	*/
#define MARK_WORD	2	/* unmark, then mark word at (x,y)	*/
#define MARK_LINE	3	/* unmark, then mark line at (x,y)	*/

struct keybsw {
	int	(*k_init)();
	int	(*k_keyin)();
	int	(*k_mouse)();
	int	(*k_exit)();
	int	(*k_ctl)();
};

/* 
 * defines for keyboard control functions
 */ 
#define KNUMERIC	1
#define KCURMOD		2
#define KSETLED		3
#define KMMASK		4	/* set mouse mask */
#define KCLICK		5
#define KBELL		6
#define KGMASK		7	/* get mouse mask */

extern	struct termsw 	termsw[];
extern	struct keybsw 	keybsw[];
extern	int		defterm, deskem, nterms, nkeybs;

#endif
