#include "../h/types.h"
#include "../vt/vt_hdrs.h"
#include "../vt/vt_kernel.h"
#include "../vt/vt_key.h"

/*
 * Routines to handle mouse and keyboard input from the serial I/O drivers
 */

#define LEFT_BUTTON	0x4
#define MID_BUTTON	0x2
#define RIGHT_BUTTON	0x1

#define NPANES		10
#define IBUTTONS	(VT_MOUSE_RIGHT|VT_MOUSE_LEFT|VT_MOUSE_MIDDLE)

extern int	  mactive, kactive;
extern struct tty vt_tty[];
extern char	  mousetab[];
extern struct popquiz	  popquiz;
extern struct trackcursor trackcursor;

char msbuf[5];			/* mouse input buffer */
int mscnt = 0;			/* count of mouse bytes */

int	mousestate = IBUTTONS;
short	minx, miny, maxx, maxy, mousex, mousey;

/*
 * Take the next input character from the mouse input routine for work 
 * station mouse line discipline
 */
vtmouse(c, tp)
register unsigned char c;
struct tty *tp;		/* pointer to tty of mouse serial port */
{
	register unsigned char	button = 0;

	if (mscnt >= 5) mscnt = 0;

	if (mscnt == 0) {
		if ((c >= 0x80) && (c <= 0x87)) { /* start of mouse seq */
			if (c & LEFT_BUTTON)
				button |= VT_MOUSE_LEFT;
			if (c & MID_BUTTON)
				button |= VT_MOUSE_MIDDLE;
			if (c & RIGHT_BUTTON)
				button |= VT_MOUSE_RIGHT;
			msbuf[0] = button;
		
		} else {
			mscnt = 0; /* not a good start, throw away */
			return;
		}
	} else {
		msbuf[mscnt] = c;
		if ((mscnt & 0x1) == 0) {
			/* must be 2 or 4, send x,y report */
			vtmousein(msbuf[0], msbuf[mscnt-1], msbuf[mscnt]);
		}
	}
	mscnt++;
}

vtmousein(buttons,mx,my)
register short	buttons;
register short	mx;		/* mouse x increment */
register short  my;		/* mouse y increment */
{
    register unsigned char  mflag;  /* flag for negative velocity */
    extern int flushvtecho();

    /*
     *	Check for the stupid case (no change in position!)
     */

    if( mx || my){
	/* 
	 *   Scale the mouse input according to mousetab
	 */
	if( mx < 0){ 
	    mflag = 1; mx = -mx;
	} else
	    mflag = 0;
	if (mx > VT_MTABSIZE) {
	    if (mousetab[VT_MTABSIZE] != 0) 
		mx = mousetab[VT_MTABSIZE];
	} else
	    mx = mousetab[mx];
	if (mflag) 
	    mx = -mx;

	if( my < 0){ 
	    mflag = 1; my = -my;
	} else
	    mflag = 0;
	if (my > VT_MTABSIZE) {
	    if (mousetab[VT_MTABSIZE] != 0) 
		my = mousetab[VT_MTABSIZE];
	} else
	    my = mousetab[my];
	if (mflag) 
	    my = -my;

	/*
	 * Set current mouse position
	 */
	mousex += mx;
	mousey -= my;

	/* 
	 * Clip the mouse if needed
	 */
	if (mousex < minx) mousex = minx;
	if (mousey < miny) mousey = miny;
	if (mousex > maxx) mousex = maxx;
	if (mousey > maxy) mousey = maxy;

	/* wake up type ahead daemon to move the cursor */
	wakeup((caddr_t)flushvtecho);
    }

    /* 
     * Send mouse information to the correct window
     */
    vtsendmouse( buttons, mousex, mousey);
}

/*
 * 	Send mouse reports to the correct keyboard driver
 */
vtsendmouse(buttons, x, y)
register short	buttons;
register short	x;		/* mouse x position */
register short	y;		/* mouse y position */
{
    register struct tty    *vp;
    int 		   *window;
    int			   relx, rely, pane, w;
    short		   change;
    register int	   s;

    change = buttons ^ mousestate;

    if (popquiz.win){
	if (change)
	    wakeup((caddr_t)&popquiz.current);
	goto out;
    }else if (trackcursor.type){
	if (change)
	    wakeup((caddr_t)&trackcursor.type);
	goto out;
    }

    if(!change){
	change |= VT_MOUSE_NOBUTTON;
	buttons |= VT_MOUSE_NOBUTTON;
    }
    
    vp = &vt_tty[w = mactive];
    if (WithinWindow( vp->v_win, x, y)){	/* inside mouse-active window */
	if(WithinPane(vp->v_win, DISPLAY, x, y)){
	    pane=DISPLAY;
	}else{
	    for(pane = 0; pane < NPANES; pane++){
		if(WithinPane(vp->v_win, pane, x, y))
		    break;
	    }
	    if(pane == NPANES) 
		    pane = DISPLAY;
	    vp = &vt_tty[0];
	}
    }else{					/* inside some other window  */
	vp = &vt_tty[0];			/* pass info to desktop proc */
	ContainingPane( x, y, &window, &pane);
	if(pane < 0) pane = DISPLAY;
	for(w=0; w<NVT+1; w++){
	    if(vt_tty[w].v_win == window) 
		break;
	}
	if (w == NVT+1)
		w = 0;
    }
    SetActiveCursor(vp->v_win);
    MapCoordinates(vp->v_win, DISPLAY, x, y, &relx, &rely);

    if( change & vp->v_mmask){
	(*keybsw[vp->v_te].k_mouse)
		(vp->v_keyb, buttons, (w<<8)|pane, relx, rely);
    }
out:
    mousestate = buttons & 7;
    return;
}

/*
 * Input routine for workstation keyboard line discipline
 */
vtkeyboard(c, tp)
unsigned char c;
struct tty *tp;
{
    extern int	mark_request();
    extern struct mark	vt_marks[];
    register struct tty *vp = &vt_tty[kactive];
  
    if (vt_marks[kactive].req&MARKING){
	vt_marks[kactive].req |= CANCEL;
	wakeup((caddr_t)mark_request);
    }
    (*keybsw[vp->v_te].k_keyin)(vp->v_keyb, c);
}
