/*#define DEBUG	/* */
#include "../h/param.h"		/* system parameters */
#include "../h/systm.h"		/* system structures */	
#include "../h/dir.h"		/* needed for user.h!, why?? */	
#include "../h/user.h"		/* u area stuff */	
#include "../h/proc.h"		/* proc declarations */	
#include "../h/errno.h"		/* system errors */	
#include "../h/kernel.h"	/* kernel globals */
#include "../vt/vt_hdrs.h"	/* virtual terminal parameters */
#include "../vt/vt_fonts.h"	/* virtual terminal font defines */
#include "../vt/vt_output.h"	/* vt output defines */
#include "../vt/vt_kernel.h"	/* kernel only vt defines */
#include "../machine/board.h"

extern struct tty vt_tty[]; 	 /* tty structures for windows */
extern struct itable v_itable[]; /* icons currently on desktop */
extern struct statline v_status; /* status line */
extern struct popquiz popquiz;   /* popup menu */
extern short  globallut[];
extern char   vidbuf[];
extern int    mousestate;
extern short	minx, miny, maxx, maxy, mousex, mousey;
extern int  iconf[][128];	    /* icon faces */
extern int  iconm[][128]; 	    /* icon masks */

struct dbuffer	{
	struct tty	*vp;
	int		gbuf;
};


char *
dt_init(vp)
struct tty	*vp;
{
    struct dbuffer	*db;
    int	RefreshBackground();

#ifdef DEBUG
cprintf("dt_init\n");
#endif DEBUG
    db = (struct dbuffer *)CreateBlock(sizeof(struct dbuffer));
    if(db){
	db->vp = vp;
	db->gbuf = gr_init(vp);
	SetRefresh(vp->v_win, db, RefreshBackground);
	RefreshBackground(db, SCREENX, SCREENY, SCREENW, SCREENH);
    }
    return((char *)db);
}

dt_exit(db)
struct dbuffer	*db;
{
#ifdef DEBUG
cprintf("dt_exit\n");
#endif DEBUG
    if(db){
	gr_exit(db->gbuf);
	DestroyBlock(db);
    }
}

dt_disp(db, c)
struct dbuffer	*db;
unsigned char	c;
{	
#ifdef DEBUG
cprintf("dt_disp(0x%x)\n", c);
#endif DEBUG
	gr_disp(db->gbuf, c);
}

dt_ioctl(db, cmd, data, flag)
register struct dbuffer * db;
caddr_t	data;
{
	register short	* shp = (short *) data;
	register struct tty *vp = db->vp;

	switch(cmd){
	/*
	 * Put Icon on Screen and save
	 */
         case TIOUSICON : {
	     register i;
	     register j;
	     register struct itable * itptr;
	     register unsigned char * sp;
	     struct font_plane *charinfo;
#ifdef DEBUG
cprintf("icon->screen\n");
#endif DEBUG
	        /* find empty slot in v_itable for this one */
	        for (i = 0, itptr = v_itable; itptr < &v_itable[NICON];
							       i++, itptr++)
		    if (itptr->iaddr == 0) 
			break;

		/* error, no more room in table */
		if (itptr == &v_itable[NICON]) {
		    *shp = -1;
		    return(ENOVT);
		} else {
		    shp++;		    /* look past first short */
		    if (*shp < 0 || *shp >= NISTYLES){
			shp = (short * ) data;
			*shp = -1;
			return(ENOVT);
		    }
		    itptr->maddr = (short *)&iconm[*shp][0];
		    itptr->iaddr = (short *)&iconf[*shp++][0];
		    GetCurrentPosition(vp->v_win, &(itptr->x), &(itptr->y));
		    itptr->w    = *shp++;
		    itptr->h    = *shp++;
		    itptr->fcol = *shp++;
		    itptr->bcol = *shp++;
		    sp = (unsigned char * ) shp;	/* read in name */
 		    itptr->lw = 0;
		    charinfo = GetFontPlane( DEFPROPFONT, DEFPLANE);
 		    itptr->lh = CharacterHeight( charinfo); 
		    for (j = 0;j < ICONNAME; j++) {
 			itptr->lw += CharacterWidth( charinfo, *sp);
			itptr->name[j] = *sp++; 
		    }
		    DoneWithPlane( DEFPROPFONT, DEFPLANE);
 		    itptr->lx = itptr->x + (itptr->w/2) - (itptr->lw/2);
 		    itptr->ly = itptr->y + itptr->h + 4;
 		    if( itptr->lx < itptr->x){
 			RefreshBackground(vt_tty[0].v_term, itptr->lx, 
						itptr->y, itptr->lw, 
 					      (itptr->h + itptr->lh + 4));
 		    } else {
 			RefreshBackground(vt_tty[0].v_term, itptr->x, 
						itptr->y, itptr->w, 
 					      (itptr->h + itptr->lh + 4));
 		    }
		    shp = (short * ) data;
		    *shp = i;
		}
		break;
	}

	/*
	 * Define an icon
	 */
	case TIOUDEFI : {
	    struct iconpat * ip = (struct iconpat *) data;
	    int size;

#ifdef DEBUG
cprintf("define icon %d\n", ip->index);
#endif DEBUG
	    size = (((ip->width+15)>>4)<<1) * ip->height;
	    if( copyin(ip->face, &iconf[ip->index][0], size) || 
		copyin(ip->mask, &iconm[ip->index][0], size)){
		return(EFAULT);
	    }
	    break;
	}
	    
	/*
	 *	Invert Icon on screen
	 */
	case TIOUIICON : {
	    register COLORT col;
	    register struct itable * itptr;

		itptr = &v_itable[*shp];
		col = itptr->fcol;
		itptr->fcol = itptr->bcol;
		itptr->bcol = col;
 		if( itptr->lx < itptr->x){
 		    RefreshBackground(vt_tty[0].v_term, itptr->lx, 
						itptr->y, itptr->lw, 
 					  (itptr->h + itptr->lh + 4));
 		} else {
 		    RefreshBackground(vt_tty[0].v_term, itptr->x, 
						itptr->y, itptr->w, 
 					  (itptr->h + itptr->lh + 4));
 		}
		break;
	}


	/*
	 *	Delete an icon on the desktop
	 */
	case TIOUDICON : {
	    register struct itable * itptr;

		itptr = &v_itable[*shp];
 		itptr->iaddr = 0;
 		if( itptr->lx < itptr->x){
 		    RefreshBackground(vt_tty[0].v_term, itptr->lx, 
						itptr->y, itptr->lw, 
 					  (itptr->h + itptr->lh + 4));
 		} else {
 		    RefreshBackground(vt_tty[0].v_term, itptr->x, 
						itptr->y, itptr->w, 
 					  (itptr->h + itptr->lh + 4));
 		}
		break;
	}

	/*
	 * Set current mouse mode 
	 */
	case TIOVSETMM: {

	    (*keybsw[vp->v_te].k_ctl)(vp->v_keyb, KMMASK, *shp);
	    break;
	}

	default:
	    return(-1);
	}
	return(0);
}

RefreshBackground(db,x,y,w,h)		/* clear backgound to gray */
struct dbuffer	*db;
register x,y,w,h;	    		/* area to refresh */
{
    register struct itable * iptr;	/* counter */
    register struct tty	   * vp;
    
    if(db){
	vp = db->vp;
	SetPermanentClipping(vp->v_win, x, y, w, h);
#ifdef COLOR
	SetColor(vp->v_win,GRAY50);	/* use gray50 to refresh background */
#else COLOR
	SetPattern(vp->v_win,gray50);	/* use gray50 to refresh background */
#endif COLOR
	SetPosition(vp->v_win,x,y);
	PaintRectangleInterior(vp->v_win,w,h);
#ifndef COLOR
	SetPattern(vp->v_win, solid);
#endif COLOR
	/* refresh any icons on screen that need it */
	w += x;
	h += y;
	for (iptr = v_itable; iptr < &v_itable[NICON]; iptr++) {
	    if (iptr->iaddr){ 
		/* check icon */
		if( Rover(x,y,w,h,iptr->x,iptr->y,iptr->w,iptr->h)) {
		    SetPosition(vp->v_win, iptr->x, iptr->y);
		    DisplayScreenIcon(vp, iptr);
		}
		/* check icon label */
		if( Rover(x,y,w,h,iptr->lx,iptr->ly,iptr->lw,iptr->lh)) {
		    SetPosition(vp->v_win, iptr->lx, iptr->ly);
		    DisplayIconLabel(vp, iptr);
		}
	    }
	}
	/* refresh status line if needed */
	if (SYSY <= y + h) 
		DisplayStatusLine();
	SetPermanentClipping(vp->v_win, 0, 0, SCREENW, SCREENH);
    }
}

/*
 * Routine to test if two given rectangles overlap, same as in low level
 * primatives
 */
Rover(rx,ry,rcx,rcy,sx,sy,sw,sh)
{

    register scx = sx + sw;
    register scy = sy + sh;

    return(rx < scx && sx < rcx && ry < scy && sy < rcy);
} 


/*
 *	Routine to display/erase the current status line
 */
DisplayStatusLine()
{
    register struct tty * tp = &vt_tty[0];

    if (v_status.visible) {
	SetPosition(tp->v_win, 0, SYSY);
	SetColor(tp->v_win,BLACK);
	PaintRectangleInterior(tp->v_win, SYSW, SYST);
	BumpYPosition(tp->v_win, SYST);
	SetColor(tp->v_win,WHITE);
	PaintRectangleInterior(tp->v_win, SYSW,SYSH);
	BumpPosition(tp->v_win, SYSW/2, SYSH - 8);
	SetJustification(tp->v_win, CENTER);
	SetColor(tp->v_win,BLACK);
	SetBColor(tp->v_win,WHITE);
	SetFont(tp->v_win, DEFPROPFONT);
	PaintString(tp->v_win, -1, v_status.message);
    }
}

EraseStatusLine()
{
    v_status.visible = 0;
    RefreshBackground( vt_tty[0].v_term, 0, SYSY, SYSW, SYSH+SYST);
}


DisplayScreenIcon(tp,ient)
register struct tty    * tp;			/* physical terminal */
register struct itable * ient;			/* this icno */
{
#ifdef COLOR
    RASTER	s, d;
    register short	i;

    s.address = (short *)ient->maddr;
    s.width = ((ient->w+15)>>4)<<1;

    d.address = (short *)(vidbuf+0x28000);
    d.width = ((ient->w+31)>>5)<<2;

    CopyRaster(&s, 0, 0, &d, 0, 0, ient->w, ient->h);

    /* paint in a background and the icon */
    SetColor(tp->v_win,ient->bcol); 
    PaintIcon(tp->v_win, vidbuf+0x28000, ient->w, ient->h);

    s.address = (short *)ient->iaddr;
    CopyRaster(&s, 0, 0, &d, 0, 0, ient->w, ient->h);

    SetColor(tp->v_win,ient->fcol); 
    PaintIcon(tp->v_win, vidbuf+0x28000, ient->w, ient->h);

#else
    SetColor(tp->v_win,ient->bcol); 
    PaintIcon(tp->v_win, ient->maddr, ient->w, ient->h);
    SetColor(tp->v_win,ient->fcol); 
    PaintIcon(tp->v_win, ient->iaddr, ient->w, ient->h);
#endif
}

DisplayIconLabel(tp,ient)
register struct tty    * tp;			/* physical terminal */
register struct itable * ient;			/* this icon */
{
    /* put up label */
    BumpPosition(tp->v_win, ient->lw/2, 
		 CharacterBaseline(GetFontPlane(DEFPROPFONT, DEFPLANE)));
    DoneWithPlane( DEFPROPFONT, DEFPLANE);
    SetJustification(tp->v_win, CENTER);
    SetFont(tp->v_win, DEFPROPFONT);
    SetColor(tp->v_win,ient->fcol); 
    SetBColor(tp->v_win,ient->bcol); 
    PaintString(tp->v_win,ICONNAME,ient->name);
}

DisplayPopQuiz(vp, p)
struct  tty     *vp;
char	*p;
{
    register i=0;
    short	x, y, x1, y1, w=0, h, sw;
    struct font_plane *charinfo, *tcharinfo;
    char	*bp;
    extern unsigned char    cflag;	    /* mouse cursor move flag */
    extern int globalmask[], globalface[];

    GetWindowPosition( vp->v_win, &x, &y);
    GetCurrentPosition( vp->v_win, &x1, &y1);
    x += x1; y += y1;
    while( popquiz.win){	/* somebody else is displaying a pop-up */
	sleep( (caddr_t)&popquiz.current, PZERO);	/* don't interrupt me */
    }
    if ((mousestate&7) == 7)	/* return if no buttons are down */
	return(0);
    popquiz.buttons = mousestate;
    popquiz.win = (WINDOW )1;
    bp = popquiz.buffer;
    charinfo = GetFontPlane(DEFPROPFONT, DEFPLANE);
    tcharinfo = GetFontPlane(DEFTITLEFONT, DEFPLANE);
    popquiz.cheight = CharacterHeight( charinfo) + 8;
    popquiz.baseline = CharacterBaseline( charinfo);
    h = -popquiz.cheight;	/* we don't count the height of the title */
    while (*p && i< VT_NCHOICES){		/* setup up the pop-quiz */
	popquiz.choice[i] = bp;
	sw = 0;
	while (*bp++ = *p){
	    if (i == 0){
		sw += CharacterWidth( tcharinfo, *p++);
	    } else {
		sw += CharacterWidth( charinfo, *p++);
	    }
	}
	if (sw > w) w = sw;
	h += popquiz.cheight;
	p++; i++;
    }
    DoneWithPlane( DEFPROPFONT, DEFPLANE);
    DoneWithPlane( DEFTITLEFONT, DEFPLANE);
    popquiz.n = i;
    popquiz.current = 0;
    cflag++;
    w+=8;
    if(x < (w>>1))
	x = w>>1;
    else if (x+(w>>1)>SCREENW)
	x = SCREENW-(w>>1);
    if(y < 16)
	y = 16;
    else if ((y+15+h)>SCREENH)
	y = SCREENH-h-15;
    popquiz.win = CreateWindow(x-(w>>1),y+15,w,h,0,QUIZ);
    DefineGlobalCursor(popquiz.win, globalmask, globalface, 5, 3, 0);
    SetActiveCursor(popquiz.win);
    SetWindowTitle( popquiz.win, popquiz.choice[0]);
    SetFont(popquiz.win, DEFPROPFONT);
    SetPosition( popquiz.win, 4, popquiz.baseline+4);
    for( i=1; i<popquiz.n; i++){
	PaintString( popquiz.win, -1, popquiz.choice[i]);
	BumpYPosition( popquiz.win, popquiz.cheight);
    }
    cflag--;
    if( mousestate == popquiz.buttons){
	sleep( (caddr_t)&popquiz.current, PZERO);   /* wait for the selection */
    }
    cflag++;
    DestroyWindow(popquiz.win);
    popquiz.win = NULL;
    cflag--;
    return(popquiz.current);
}

mark_request(vp, buttons, x, y)
struct	tty	*vp;
short	buttons, x, y;
{
    extern char	markneeded, markrunning;
    extern struct mark	vt_marks[];
    struct mark	*mp;
    int	flushvtecho();

    mp = &vt_marks[vp-&vt_tty[0]];

    if (buttons & VT_MOUSE_CONTINUOUS){
	if (mp->req & MARKING){
	    mp->req |= MARK;
	    mp->x = x; mp->y = y;
	}else {
	    return;
	}
    }else if (buttons & VT_MOUSE_LEFT){
	if (buttons & VT_MOUSE_DOWN){
	    vp->v_mmask |= VT_MOUSE_NOBUTTON;
	    if (mp->req & MARKING)
		mp->req |= CANCEL;
	    mp->req |= MARK;
	    mp->x = x; mp->y = y;
	}else{
	    if (mp->req & MARKING)
		vp->v_mmask &= ~VT_MOUSE_NOBUTTON;
	    return;
	}
    }else if (buttons&VT_MOUSE_DOWN){
	if (buttons&VT_MOUSE_MIDDLE){
	    mp->req |= POPUP;
	    mp->x = x; mp->y = y;
	}else if (buttons&VT_MOUSE_RIGHT){
	    mp->req |= DEFAULT;
	    mp->x = x; mp->y = y;
	}
    }

		
    if(!markneeded && !markrunning){
	markneeded++;
	wakeup((caddr_t)flushvtecho);
    }else{
	wakeup((caddr_t)mark_request);
    }
}

mark_daemon()
{
    extern char	markneeded, markrunning;
    markneeded = 0;
    if(!markrunning){
	/* create a mark daemon */
	markrunning++;
	if (newproc(0)) {
	    spl0();
	    u.u_procp->p_flag |= SLOAD|SSYS;
#ifdef	M68020
	    setctx(u.u_procp->p_context = CTX_SYS);
#endif	M68020
	    strcpy(u.u_comm, "marking");
	    while(1) {
		extern struct mark	vt_marks[];
		extern char	*copybuf;
		struct mark	*mp;
		struct tty	*vp;
		short		i, x1, y1, x;
		char		*cp;

		for(i=0; i<=NVT; i++){
		    mp = &vt_marks[i];
		    vp = &vt_tty[i];
		    if (mp->req){
			if((!termsw[vp->v_te].t_mark) || mp->req == MARKING){
			    continue;
			}
			if(mp->req&CANCEL){
			    mp->req &= ~(CANCEL|MARKING);
			    vp->t_state &= ~TS_BUSY;
			    (*termsw[vp->v_te].t_mark) 
					(vp->v_term, MARK_CANCEL, 0, 0);
			}
		        if (mp->req&DEFAULT){
			    mp->req &= ~DEFAULT;
			    if(mp->req&MARKING){
				mp->req &= ~MARKING;
				vp->t_state &= ~TS_BUSY;
				cp =(char *)(*termsw[vp->v_te].t_mstop)
							    (vp->v_term);
				if(cp){
				    if(copybuf)
					DestroyBlock(copybuf);
				    copybuf = cp;
				}
			    }else{
				if (copybuf){
				    cp = copybuf;
				    while (*cp){
					x = vp->t_rawq.c_cc + vp->t_canq.c_cc;
					if (x >= TTYHOG/2 && 
					    ((vp->t_flags & (RAW|CBREAK)) || 
					    (vp->t_canq.c_cc > 0))) {
						sleep((caddr_t)&lbolt, TTIPRI);
					}
					(*keybsw[vp->v_te].k_keyin)
						(vp->v_keyb, *cp++);
				    }
				}
			    }
			}else if(mp->req&POPUP){
			    mp->req &= ~POPUP;
			    GetCurrentPosition( vp->v_win, &x1, &y1);
			    SetPosition(vp->v_win, mp->x, mp->y);
			    if(mp->req&MARKING){
				switch(DisplayPopQuiz(vp, 
				    "Marking\0Copy\0Cancel\0Extend mark\0")){
				case 1:
				    mp->req &= ~MARKING;
				    vp->t_state &= ~TS_BUSY;
				    cp =(char *)(*termsw[vp->v_te].t_mstop)
								(vp->v_term);
				    if(cp){
					if(copybuf)
					    DestroyBlock(copybuf);
					copybuf = cp;
				    }
				    break;
				case 2:
				    mp->req = 0;
				    vp->t_state &= ~TS_BUSY;
				    (*termsw[vp->v_te].t_mark) 
					(vp->v_term, MARK_CANCEL, 0, 0);
				    break;
				case 3:
				    (*termsw[vp->v_te].t_mark)
					(vp->v_term, MARK_REGION, mp->x, mp->y);
				    break;
				}
			    }else{
				switch(DisplayPopQuiz(vp, 
				    "Text\0Insert\0Mark line\0Mark word\0")){
				case 1:
				    if (copybuf){
					mp->req &= ~MARKING;
					vp->t_state &= ~TS_BUSY;
					cp = copybuf;
					while (*cp){
					    x = vp->t_rawq.c_cc+vp->t_canq.c_cc;
					    if (x >= TTYHOG/2 && 
					    ((vp->t_flags & (RAW|CBREAK))|| 
					    (vp->t_canq.c_cc > 0))) {
						sleep((caddr_t)&lbolt,TTIPRI);
					    }
					    (*keybsw[vp->v_te].k_keyin)
						(vp->v_keyb, *cp++);
					}
				    }
				    break;
				case 2:
				    mp->req |= MARKING;
				    vp->t_state |= TS_BUSY;
				    (*termsw[vp->v_te].t_mark)
					(vp->v_term, MARK_LINE, mp->x, mp->y);
				    break;
				case 3:
				    mp->req |= MARKING;
				    vp->t_state |= TS_BUSY;
				    (*termsw[vp->v_te].t_mark)
					(vp->v_term, MARK_WORD, mp->x, mp->y);
				    break;
				}
			    }
			    SetPosition(vp->v_win, x1, y1);
			}else if (mp->req&MARK){
			    mp->req &= ~MARK;
			    mp->req |= MARKING;
			    vp->t_state |= TS_BUSY;
			    (*termsw[vp->v_te].t_mark)
				    (vp->v_term, MARK_REGION, mp->x, mp->y);
			}
		    }
		}
		sleep(mark_request, TTIPRI);
	    }
	    /*markrunning = 0;*/
	    /* exit and cleanup? */
	}
    }
}

#ifdef COLOR
findcolor(type, r, g, b)
int	type, r, g, b;
{
    short	R, G, B;
    register c;

    switch(type){
    case VT_SHARE:
	for (c=0; c<LUTSIZE; c++){
	    if (globallut[c] >0){
		GetGlobalLUT(c, &R, &G, &B);
		if(r == R && g == G && b == B)
		    return(c);
	    }
	}
	/* no currently shared colors match, so look for a free one */
	/* fall thru to ... */
    case VT_OWN:
	for (c=0; c<LUTSIZE; c++){
	    if (globallut[c] == VT_FREE)
		return(c);
	}
	break;
    }
    return(-1);
}
#endif COLOR
