/*#define DEBUG		/* */
#include "../machine/reg.h"
#include "../h/param.h"		/* system parameters */
#include "../h/systm.h"		/* system sturcts et al */
#include "../h/dir.h"		/* directories and files */
#include "../h/user.h"		/* user block */
#include "../h/file.h"		/* file structure */
#include "../h/proc.h"		/* process strucutures */
#include "../h/inode.h"		/* inodes */
#include "../h/conf.h"		/* cnofiguration */
#include "../h/buf.h"		/* buffers */
#include "../h/dk.h"		/* disk stuff */
#include "../h/uio.h"		/* user input/output struct */
#include "../h/kernel.h"	/* need lbolt and hz */
#include "../h/signal.h"	/* signal defines */
#include "../h/errno.h"		/* error defines */
#include "../vt/vt_hdrs.h"	/* virtual terminal parameters */
#include "../vt/vt_fonts.h"	/* font defines and structures */
#include "../vt/vt_output.h"	/* vt output defines */
#include "../vt/vt_kernel.h"	/* kernel only vt defines */
#include "../vt/vt_key.h"	/* external virtual key names */
#include "../vt/vt_keyin.h"	/* internal virtual key names */

#ifdef GWS
#include "../is68kdev/pdma.h"	/* pseudo dma defs */
#include "../is68kdev/sioreg.h"	/* serial I/O register defs */
#include "../machine/board.h"
extern struct pdma sio_pdma[];
#endif GWS

#include "../h/vm.h"
#include "../h/msgbuf.h"

extern int		gpaddr;
extern struct tty	vt_tty[];	/* system wide virtual terms */
extern int *		v_color[];	/* different colors for system */
extern int 		flushvtecho();
extern int		mactive, kactive;
extern short		mousex, mousey;

short	consx, consy, consw, consh;

/*
 * open the desktop and window 1 for kernel printfs during startup
 */
vt_cninit()
{
    register int	i;

#ifdef DEBUG
cprintf("vt_cninit(), bufx = %d\n", msgbuf.msg_bufx);
#endif
    mousex = 10; mousey = 10;
    if(vtopen(0, 0)){
	return;
    }else{
	vtcopen(1, 0);
    }
}

vt_cnputc(c)
char	c;
{
    register struct tty *vp = &vt_tty[NVT];

    /* no graphics processor? we're done! */
    if(!gpaddr)	
	return;

    /* open the console if it isn't already open */
    if ((vp->t_state & TS_ISOPEN)==0){
	vtcopen(1,0);
    }
    if(c != '\0'){
	if(c == '\n')
	    (*termsw[vp->v_te].t_disp)(vp->v_term, '\r');
	/* use the console window's terminal emulator to display the char */
	(*termsw[vp->v_te].t_disp)(vp->v_term, c);
    }
}

/*
 * console open routine
 */
#define ISPEED 	B9600
#define IFLAGS	(EVENP|ODDP|ECHO|CRMOD)

vtcopen(dev)
dev_t dev;
{
	struct tty * vp = &vt_tty[NVT];
	int	error, vtstart();

#ifdef DEBUG
cprintf("vtcopen()\n");
#endif
	if((vp->t_state & TS_ISOPEN)==0){
	    vp->t_oproc = vtstart;
	    vp->t_state |= TS_WOPEN;
	    kactive = NVT;
	    ttychars(vp);
	    vp->t_ispeed = vp->t_ospeed = ISPEED;
	    vp->t_flags = IFLAGS;
	    vp->v_win = (int *)CreateWindow(consx,consy,consw,consh,0,NORMAL);
	    SetWindowTitle(vp->v_win, "Console");
	    gsignal(vt_tty[0].t_pgrp, SIGREF);	/* tell dm about it */
	    vtopen1(vp);
	}
	vp->t_state |= TS_CARR_ON;
	
	error = (*linesw[vp->t_line].l_open)(dev, vp);
	if(error){
		return(error);
	}else{
		if(vp->t_pgrp == 0)
			vp->t_pgrp = u.u_procp->p_pgrp;
	}
	return(0);
}

/*
 * console close routine
 */
vtcclose(tp)
	register struct tty *tp;
{
#ifdef DEBUG
cprintf("vtcclose()!");
#endif
	/* signify that not process group is associated with the console */
	/* but don't make it go away! */
	vt_tty[NVT].t_pgrp = 0;
}

/*
 * console write routine
 * output to both the serial port and the graphics device
 */

vtcwrite(tp, uio)
register struct uio * uio;	/* user io structure */
{
#ifdef DEBUG
cprintf("vtcwrite()\n");
#endif
	return(vtwrite(NVT, uio));
}



/*
 * console read routine
 * read from the input queue of the designated console vtty
 */

vtcread(tp, uio)
register struct uio * uio;	/* user io structure */
{
#ifdef DEBUG
cprintf("vtcread()\n");
#endif
	return(vtread(NVT, uio));
}

/*
 * console ioctl routine
 */
vtcioctl(tp, cmd, data, flag)
{
	int	r;

	r = vtioctl(NVT, cmd, data, flag);
	if(r < 0)
		return(EIO);
	return(r);
}
