/*	sys_process.c	6.1	83/07/29	*/

#include "../machine/reg.h"
#include "../machine/psl.h"
#include "../machine/pte.h"

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/proc.h"
#include "../h/inode.h"
#include "../h/text.h"
#include "../h/seg.h"
#include "../h/vm.h"
#include "../h/buf.h"
#include "../h/acct.h"

/*
 * Priority for tracing
 */
#define	IPCPRI	PZERO

/*
 * Tracing variables.
 * Used to pass trace command from
 * parent to child being traced.
 * This data base cannot be
 * shared and is locked
 * per user.
 */
struct {
	int	ip_lock;
	int	ip_req;
	int	*ip_addr;
	int	ip_data;
#ifdef	CDB
	char	ip_comm[MAXNAMLEN + 1];	/* copy of u_comm for request 13 */
#endif	CDB
} ipc;

/*
 * sys-trace system call.
 */
ptrace()
{
	register struct proc *p;
	register struct a {
		int	req;
		int	pid;
		int	*addr;
		int	data;
	} *uap;
#ifdef	CDB
	int	req;
#endif	CDB

	uap = (struct a *)u.u_ap;
	if (uap->req <= 0) {
		u.u_procp->p_flag |= STRC;
#ifdef	CDB
		u.u_procp->p_dptr = 0; /* debugger will change if desired */
#endif	CDB
		if (ipc.ip_lock) {
			ipc.ip_lock = 0;
			wakeup((caddr_t)&ipc);
		}
		return;
	}
	p = pfind(uap->pid);
#ifdef	CDB
	req = uap->req;		/* remember this for post-procxmt processing */
	if (uap->req == 10) {
		u.u_r.r_val1 = -1;	/* debugger attaching to process */
		if (p == 0) {
			u.u_error = ESRCH;
			return;
		}
		/* check on permissions or else large security problems */
		if (u.u_ruid == p->p_uid || u.u_uid == p->p_uid || suser()) {
			p->p_dptr = u.u_procp;	/* point target to debugger */
			p->p_flag |= STRC;	/* now being traced */
			u.u_r.r_val1 = 0;
		} else
			u.u_error = EPERM;
		return;
	}

	if (p == 0 || p->p_stat != SSTOP ||
	    ((u.u_procp != p->p_dptr) && (p->p_ppid != u.u_procp->p_pid)) ||
#else	CDB
	if (p == 0 || p->p_stat != SSTOP || p->p_ppid != u.u_procp->p_pid ||
#endif	CDB
	    !(p->p_flag & STRC)) {
		u.u_error = ESRCH;
		return;
	}
#ifdef	CDB
	if (uap->req == 12) { 	/* debugger wants the ppid of this process */
		u.u_r.r_val1 = p->p_ppid;
		return;
	}
#endif	CDB
	while (ipc.ip_lock) {
		sleep((caddr_t)&ipc, IPCPRI);
	}
	ipc.ip_lock = p->p_pid;
	ipc.ip_data = uap->data;
	ipc.ip_addr = uap->addr;
	ipc.ip_req = uap->req;
	p->p_flag &= ~SWTED;
	while (ipc.ip_req > 0) {
		if (p->p_stat==SSTOP)
			setrun(p);
		sleep((caddr_t)&ipc, IPCPRI);
	}
	u.u_r.r_val1 = ipc.ip_data;
	if (ipc.ip_req < 0) {
		u.u_error = EIO;
		ipc.ip_req = 0;
	}
#ifdef	CDB
	if (req == 13)			/* copy name into user's buffer */
		copyout(ipc.ip_comm, uap->addr, sizeof(ipc.ip_comm));
#endif	CDB
	ipc.ip_lock = 0;
	wakeup((caddr_t)&ipc);
}

#ifdef vax
#define	NIPCREG 16
int ipcreg[NIPCREG] =
	{R0,R1,R2,R3,R4,R5,R6,R7,R8,R9,R10,R11,AP,FP,SP,PC};
#else
#define	NIPCREG 17
int ipcreg[NIPCREG] =
	{R0,R1,R2,R3,R4,R5,R6,R7,R8,R9,R10,R11,R12,R13,R14,R15,PC};
#endif

#define	PHYSOFF(p, o) \
	((u_short *)(p)+((o)/sizeof(u_short)))

/*
 * Code that the child process
 * executes to implement the command
 * of the parent process in tracing.
 */
procxmt()
{
	register int i;
	register *p;
	register struct text *xp;

	if (ipc.ip_lock != u.u_procp->p_pid)
		return (0);
	u.u_procp->p_slptime = 0;
	i = ipc.ip_req;
	ipc.ip_req = 0;
	switch (i) {

	/* read user I */
	case 1:
		if (!useracc((caddr_t)ipc.ip_addr, 4, B_READ))
			goto error;
		ipc.ip_data = fuiword((caddr_t)ipc.ip_addr);
		break;

	/* read user D */
	case 2:
		if (!useracc((caddr_t)ipc.ip_addr, 4, B_READ))
			goto error;
		ipc.ip_data = fuword((caddr_t)ipc.ip_addr);
		break;

	/* read u */
	case 3:
		i = (int)ipc.ip_addr;
		if (i<0 || i >= ctob(UPAGES))
			goto error;
		ipc.ip_data = *(int *)PHYSOFF(&u, i);
		break;

	/* write user I */
	/* Must set up to allow writing */
	case 4:
		/*
		 * If text, must assure exclusive use
		 */
		if (xp = u.u_procp->p_textp) {
			if (xp->x_count!=1 || xp->x_iptr->i_mode&ISVTX)
				goto error;
			xp->x_iptr->i_flag &= ~ITEXT;
		}
		i = -1;
		if ((i = suiword((caddr_t)ipc.ip_addr, ipc.ip_data)) < 0) {
			if (chgprot((caddr_t)ipc.ip_addr, RW) &&
			    chgprot((caddr_t)ipc.ip_addr+(sizeof(int)-1), RW))
				i = suiword((caddr_t)ipc.ip_addr, ipc.ip_data);
			(void) chgprot((caddr_t)ipc.ip_addr, RO);
			(void) chgprot((caddr_t)ipc.ip_addr+(sizeof(int)-1), RO);
		}
		if (i < 0)
			goto error;
		if (xp)
			xp->x_flag |= XWRIT;
		break;

	/* write user D */
	case 5:
		if (suword((caddr_t)ipc.ip_addr, 0) < 0)
			goto error;
		(void) suword((caddr_t)ipc.ip_addr, ipc.ip_data);
		break;

	/* write u */
	case 6:
		i = (int)ipc.ip_addr;
		p = (int *)PHYSOFF(&u, i);
		for (i=0; i<NIPCREG; i++)
			if (p == &u.u_ar0[ipcreg[i]])
				goto ok;
		if (p == &u.u_ar0[PS]) {
			ipc.ip_data |= PSL_USERSET;
			ipc.ip_data &=  ~PSL_USERCLR;
			goto ok;
		}
		goto error;

	ok:
		*p = ipc.ip_data;
		break;

#ifdef	CDB
#define SIG_FREE_PROC	0x7f
	case 11:
		ipc.ip_data = SIG_FREE_PROC;	/* signal to free process we */
		u.u_procp->p_dptr = 0;		/* aren't its debugger */
		/* ... fall through into continue code */
#endif	CDB

	/* set signal and continue */
	/* one version causes a trace-trap */
	case 9:
	case 7:
		if ((int)ipc.ip_addr != 1)
			u.u_ar0[PC] = (int)ipc.ip_addr;
#ifdef	CDB
		if (((unsigned)ipc.ip_data > NSIG)
		   && ((unsigned)ipc.ip_data != SIG_FREE_PROC))
			goto error;
#else	CDB
		if ((unsigned)ipc.ip_data > NSIG)
			goto error;
#endif	CDB
		u.u_procp->p_cursig = ipc.ip_data;	/* see issig */
		if (i == 9) 
			u.u_ar0[PS] |= PSL_T;
		wakeup((caddr_t)&ipc);
		return (1);

#ifdef	CDB
	/* copy contents of u_comm (program name) to ip_comm */
	case 13:
		bcopy(u.u_comm, ipc.ip_comm, sizeof(ipc.ip_comm));
		ipc.ip_data = 0;
		break;
#endif	CDB

	/* force exit */
	case 8:
		wakeup((caddr_t)&ipc);
		Rexit(u.u_procp->p_cursig);

	default:
	error:
		ipc.ip_req = -1;
	}
	wakeup((caddr_t)&ipc);
	return (0);
}
