/*	kern_exit.c	6.1	83/07/29	*/

#include "../machine/reg.h"
#include "../machine/psl.h"

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/map.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/kernel.h"
#include "../h/proc.h"
#include "../h/buf.h"
#include "../h/wait.h"
#include "../h/vm.h"
#include "../h/file.h"
#include "../h/mbuf.h"
#include "../h/inode.h"

/*
 * Exit system call: pass back caller's arg
 */
rexit()
{
	register struct a {
		int	rval;
	} *uap;

	uap = (struct a *)u.u_ap;
	exit((uap->rval & 0377) << 8);
}

/*
 * Release resources.
 * Save u. area for parent to look at.
 * Enter zombie state.
 * Wake up parent and init processes,
 * and dispose of children.
 */
exit(rv)
	int rv;
{
	register int i;
	register struct proc *p, *q;
	register int x;
	struct mbuf *m = m_getclr(M_WAIT, MT_ZOMBIE);

#ifdef PGINPROF
	vmsizmon();
#endif
	p = u.u_procp;
#ifdef	REALTIME
	if (p->p_flag & SPLOCK)
		punlock();
	p->p_flag &= ~(STRC|SULOCK|SPHIGH);
#else	REALTIME
	p->p_flag &= ~(STRC|SULOCK);
#endif	REALTIME
	p->p_flag |= SWEXIT;
	p->p_sigignore = ~0;
	p->p_cpticks = 0;
	p->p_pctcpu = 0;
	for (i = 0; i < NSIG; i++)
		u.u_signal[i] = SIG_IGN;
	untimeout(realitexpire, (caddr_t)p);
	/*
	 * Release virtual memory.  If we resulted from
	 * a vfork(), instead give the resources back to
	 * the parent.
	 */
	if ((p->p_flag & SVFORK) == 0)
		vrelvm();
	else {
		p->p_flag &= ~SVFORK;
		p->p_flag |= SKEEP;
		wakeup((caddr_t)p);
		while ((p->p_flag & SVFDONE) == 0)
			sleep((caddr_t)p, PZERO - 1);
		p->p_flag &= ~(SVFDONE|SKEEP);
	}
	for (i = 0; i < NOFILE; i++) {
		struct file *f;

		f = u.u_ofile[i];
		u.u_ofile[i] = NULL;
		u.u_pofile[i] = 0;
		closef(f);
	}
	if (u.u_cdir) {
		ilock(u.u_cdir);
		iput(u.u_cdir);
	}
	if (u.u_rdir) {
		ilock(u.u_rdir);
		iput(u.u_rdir);
	}
	u.u_rlimit[RLIMIT_FSIZE].rlim_cur = RLIM_INFINITY;
	acct();
#ifdef QUOTA
	qclean();
#endif
	vrelpt(u.u_procp);
	vrelu(u.u_procp, 0);
	(void) spl5();		/* hack for mem alloc race XXX */
	multprog--;
	p->p_stat = SZOMB;
	noproc = 1;
	{	/* free up any WIPC packets hung on this process */
		register struct link {
			struct link *next;
		} *lp;

		while (lp = (struct link *)p->p_Wrecq) {
			p->p_Wrecq = (struct Wrproc *)lp->next;
			Wrelse((struct Wrproc *)lp);	/* dummy if not WIPC */
		}
		while (lp = (struct link *)p->p_Wrepq) {
			p->p_Wrepq = (struct Wrproc *)lp->next;
			Wrelse((struct Wrproc *)lp);	/* dummy if not WIPC */
		}
	}
	i = PIDHASH(p->p_pid);
	x = p - proc;
	if (pidhash[i] == x)
		pidhash[i] = p->p_idhash;
	else {
		for (i = pidhash[i]; i != 0; i = proc[i].p_idhash)
			if (proc[i].p_idhash == x) {
				proc[i].p_idhash = p->p_idhash;
				goto done;
			}
		panic("exit");
	}
	if (p->p_pid == 1)
		panic("init died");
done:
	p->p_xstat = rv;
if (m == 0)
panic("exit: m_getclr");
	p->p_ru = mtod(m, struct rusage *);
	*p->p_ru = u.u_ru;
	ruadd(p->p_ru, &u.u_cru);
	for (q = proc; q < procNPROC; q++) {
#ifdef	CDB
		if (q->p_dptr == p) {
			q->p_dptr = (struct proc *) 0;
			q->p_flag &= ~STRC;
			psignal(q, SIGKILL);
		}
#endif	CDB
		if (q->p_pptr == p) {
			if (q->p_osptr)
				q->p_osptr->p_ysptr = q->p_ysptr;
			if (q->p_ysptr)
				q->p_ysptr->p_osptr = q->p_osptr;
			if (proc[1].p_cptr)
				proc[1].p_cptr->p_ysptr = q;
			q->p_osptr = proc[1].p_cptr;
			q->p_ysptr = NULL;
			proc[1].p_cptr = q;

			q->p_pptr = &proc[1];
			q->p_ppid = 1;
			wakeup((caddr_t)&proc[1]);
			/*
			 * Traced processes are killed
			 * since their existence means someone is screwing up.
			 * Stopped processes are sent a hangup and a continue.
			 * This is designed to be ``safe'' for setuid
			 * processes since they must be willing to tolerate
			 * hangups anyways.
			 */
			if (q->p_flag&STRC) {
				q->p_flag &= ~STRC;
				psignal(q, SIGKILL);
			} else if (q->p_stat == SSTOP) {
				psignal(q, SIGHUP);
				psignal(q, SIGCONT);
			}
			/*
			 * Protect this process from future
			 * tty signals, clear TSTP/TTIN/TTOU if pending.
			 */
			(void) spgrp(q, -1);
		}
	}
#ifdef	CDB
	if ((p->p_dptr != 0) && (p->p_dptr != p->p_pptr)) {
		psignal(p->p_dptr, SIGCHLD);
		wakeup((caddr_t)p->p_dptr);
	} else {
		psignal(p->p_pptr, SIGCHLD);
		wakeup((caddr_t)p->p_pptr);
	}
#else	CDB
	psignal(p->p_pptr, SIGCHLD);
	wakeup((caddr_t)p->p_pptr);
#endif	CDB
	swtch();
}

#ifdef vax
#define	RZERO	R0
#define	RONE	R1
#else
#define	RZERO	D1
#define	RONE	A0
#endif
wait()
{
	struct rusage ru, *rup;

	if ((u.u_ar0[PS] & PSL_ALLCC) != PSL_ALLCC) {
		u.u_error = wait1(0, (struct rusage *)0);
		return;
	}
	rup = (struct rusage *)u.u_ar0[RONE];
	u.u_error = wait1(u.u_ar0[RZERO], &ru);
	if (u.u_error)
		return;
	(void) copyout((caddr_t)&ru, (caddr_t)rup, sizeof (struct rusage));
}
#undef RZERO
#undef RONE

/*
 * Wait system call.
 * Search for a terminated (zombie) child,
 * finally lay it to rest, and collect its status.
 * Look also for stopped (traced) children,
 * and pass back status from them.
 */
wait1(options, ru)
	register int options;
	struct rusage *ru;
{
	register f;
	register struct proc *p, *q;

	f = 0;
loop:
	for (p = proc; p < procNPROC; p++)
#ifdef	CDB
	    if ((p->p_dptr == u.u_procp) || (p->p_pptr == u.u_procp)) {
		f++;
		if ((p->p_dptr != 0) && (p->p_dptr != u.u_procp))
		    /* parent may know about him, but the debugger goes first */
		    continue;
#else	CDB
	    if (p->p_pptr == u.u_procp) {
		f++;
#endif	CDB
		if (p->p_stat == SZOMB) {
			u.u_r.r_val1 = p->p_pid;
			u.u_r.r_val2 = p->p_xstat;
#ifdef	CDB
			if ((p->p_dptr != 0) && (p->p_dptr != p->p_pptr)) {
				/* 
				 * We have to wakeup the parent,  since we 
				 * short circuited this in the exit() code.
				 */
				p->p_dptr = 0;
				psignal(p->p_pptr, SIGCHLD);
				wakeup((caddr_t)p->p_pptr);
				return(0);
			} 
#endif	CDB
			p->p_xstat = 0;
			if (ru)
				*ru = *p->p_ru;
			ruadd(&u.u_cru, p->p_ru);
			(void) m_free(dtom(p->p_ru));
			p->p_ru = 0;
			p->p_stat = NULL;
			p->p_pid = 0;
			p->p_ppid = 0;
			if (q = p->p_ysptr)
				q->p_osptr = p->p_osptr;
			if (q = p->p_osptr)
				q->p_ysptr = p->p_ysptr;
			if ((q = p->p_pptr)->p_cptr == p)
				q->p_cptr = p->p_osptr;
			p->p_pptr = 0;
#ifdef	CDB
			p->p_dptr = 0;
#endif	CDB
			p->p_ysptr = 0;
			p->p_osptr = 0;
			p->p_cptr = 0;
			p->p_sig = 0;
			p->p_sigcatch = 0;
			p->p_sigignore = 0;
			p->p_sigmask = 0;
			p->p_pgrp = 0;
			p->p_flag = 0;
			p->p_wchan = 0;
			p->p_cursig = 0;
			return (0);
		}
		if (p->p_stat == SSTOP && (p->p_flag&SWTED)==0 &&
		    (p->p_flag&STRC || options&WUNTRACED)) {
			p->p_flag |= SWTED;
			u.u_r.r_val1 = p->p_pid;
			u.u_r.r_val2 = (p->p_cursig<<8) | WSTOPPED;
			return (0);
		}
	    }
	if (f == 0)
		return (ECHILD);
	if (options&WNOHANG) {
		u.u_r.r_val1 = 0;
		return (0);
	}
	if ((u.u_procp->p_flag&SOUSIG) == 0 && setjmp(&u.u_qsave)) {
		u.u_eosys = RESTARTSYS;
		return (0);
	}
	sleep((caddr_t)u.u_procp, PWAIT);
	goto loop;
}
