/*	init_main.c	6.2	84/01/03	*/

#include "../machine/pte.h"

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/kernel.h"
#include "../h/fs.h"
#include "../h/mount.h"
#include "../h/map.h"
#include "../h/proc.h"
#include "../h/inode.h"
#include "../h/seg.h"
#include "../h/conf.h"
#include "../h/buf.h"
#include "../h/vm.h"
#include "../h/cmap.h"
#include "../h/text.h"
#include "../h/clist.h"
#include "../h/quota.h"
#include "../machine/reg.h"
#ifdef	vax
#include "../machine/cpu.h"
#else
#include "../machine/board.h"
#endif

extern unsigned short mymid, servermid;

extern	struct user u;		/* have to declare it somewhere! */
/*
 * Initialization code.
 * Called from cold start routine as
 * soon as a stack and segmentation
 * have been established.
 * Functions:
 *	clear and free user core
 *	turn on clock
 *	hand craft 0th process
 *	call all initialization routines
 *	fork - process 0 to schedule
 *	     - process 2 to page out
 *	     - process 1 execute bootstrap
 *
 * loop at loc 13 (0xd) in user mode -- /etc/init
 *	cannot be executed.
 */
main(firstaddr)
	int firstaddr;
{
	register int i;
	register struct proc *p;
	struct fs *fs;
	int s;

	rqinit();
/*#include "loop.h"				/* */
	startup(firstaddr);

	/*
	 * set up system process 0 (swapper)
	 */
	p = &proc[0];
	p->p_p0br = u.u_pcb.pcb_p0br;
	p->p_szpt = 1;
	p->p_addr = uaddr(p);
	p->p_stat = SRUN;
#ifdef	REALTIME
	p->p_flag |= SLOAD|SSYS|SPHIGH;
#else	REALTIME
	p->p_flag |= SLOAD|SSYS;
#endif	REALTIME
#ifdef	M68020
	p->p_context = CTX_SYS;
#endif	M68020
	p->p_nice = NZERO;
	setredzone(p->p_addr, (caddr_t)&u);
	u.u_procp = p;
	u.u_cmask = CMASK;
	for (i = 1; i < NGROUPS; i++)
		u.u_groups[i] = NOGROUP;
	for (i = 0; i < sizeof(u.u_rlimit)/sizeof(u.u_rlimit[0]); i++)
		u.u_rlimit[i].rlim_cur = u.u_rlimit[i].rlim_max = 
		    RLIM_INFINITY;
	u.u_rlimit[RLIMIT_STACK].rlim_cur = 512*1024;
	u.u_rlimit[RLIMIT_STACK].rlim_max = ctob(MAXDSIZ);
	u.u_rlimit[RLIMIT_DATA].rlim_max =
	    u.u_rlimit[RLIMIT_DATA].rlim_cur = ctob(MAXDSIZ);
	p->p_maxrss = RLIM_INFINITY/NBPG;

	qtinit();					/* if not QUOTA dummy */
	p->p_quota = u.u_quota = getquota(0, 0, Q_NDQ);	/* if not QUOTA dummy */

	startrtclock();
/*#include "kg.h"			/* */
/*#if NKG > 0 || Nkg > 0		/* */
	startkgclock();
/*#endif				/* */

	/*
	 * Initialize tables, protocols, and set up well-known inodes.
	 */
	mbinit();
	cinit();			/* needed by dmc-11 driver */
/*#ifdef INET				/* */
/*#if NLOOP > 0 || Nloop > 0		/* */
	loattach();			/* XXX */
/*#endif				/* */
	/*
	 * Block reception of incoming packets
	 * until protocols have been initialized.
	 */
	s = splimp();
	ifinit();
/*#endif				/* */
	domaininit();
/*#ifdef INET				/* */
	splx(s);
/*#endif				/* */
	ihinit();
	bhinit();
	binit();
	bswinit();
	nchinit();
/*#ifdef GPROF				/* */
	kmstartup();
/*#endif				/* */

	if (!mymid) {		/* not DISKLESS */
		fs = mountfs(rootdev, 0, (struct inode *)0);
		if (fs == 0)
			panic("iinit");
		bcopy("/", fs->fs_fsmnt, 2);

		inittodr(fs->fs_time);
	}
	boottime = time;

/* kick off timeout driven events by calling first time */
	roundrobin();
	schedcpu();
	schedpaging();

/* set up the root file system */
	if (mymid) {		/* DISKLESS */
		u.u_Rrcdirmid = servermid;
		u.u_Rrrdirmid = servermid;
		rootdir = NULL;
		u.u_cdir = NULL;
		u.u_rdir = NULL;
	} else {
		rootdir = iget(rootdev, fs, (ino_t)ROOTINO);
		iunlock(rootdir);
		u.u_cdir = iget(rootdev, fs, (ino_t)ROOTINO);
		iunlock(u.u_cdir);
		u.u_rdir = NULL;
	}

	u.u_dmap = zdmap;
	u.u_smap = zdmap;

	/*
	 * Set the scan rate and other parameters of the paging subsystem.
	 */
	setupclock();

	/*
	 * make page-out daemon (process 2)
	 * the daemon has ctopt(nswbuf*CLSIZE*KLMAX) pages of page
	 * table so that it can map dirty pages into
	 * its address space during asychronous pushes.
	 */
	mpid = 1;
	proc[0].p_szpt = clrnd(ctopt(nswbuf*CLSIZE*KLMAX + UPAGES));
	proc[1].p_stat = SZOMB;		/* force it to be in proc slot 2 */
	if (newproc(0)) {
		proc[2].p_flag |= SLOAD|SSYS;
		proc[2].p_dsize = u.u_dsize = nswbuf*CLSIZE*KLMAX; 
		strcpy(u.u_comm, "pagedaemon");
#ifdef	REALTIME
		highpri();	/* page daemon is high priority process. */
#endif	REALTIME
#ifdef	M68020
		setctx(p->p_context = CTX_SYS);
#endif	M68020
		pageout();
		/*NOTREACHED*/
	}
	proc[0].p_szpt = CLSIZE;

	GP_fork();		/* if not GP then this is a dummy routine */
	BarfServer();		/* if not BARF then this is a dummy routine */

	/*
	 * make init process and enter scheduling loop
	 */
	mpid = 0;
	proc[1].p_stat = 0;
	if (newproc(0)) {
		extern caddr_t icode;
		extern int szicode;

		strcpy(u.u_comm, "init");
		expand(clrnd((int)btoc(szicode)), 0);
		(void) swpexpand(u.u_dsize, 0, &u.u_dmap, &u.u_smap);
#ifdef	M68020
		setctx(u.u_procp->p_context = CTX_INVALID);
#endif	M68020
		(void) copyout((caddr_t)icode, (caddr_t)0, (unsigned)szicode);
#ifdef	REALTIME
		highpri();	/* init is high priority process. */
#endif	REALTIME
		if (servermid) {		/* DISKLESS */
			unsigned long rpid;

			if ((rpid = MidToRpid(servermid)) == 0)
				panic("no remote server");
			if (REMchdirec(rpid, "/", 1))
				panic("no root directory");
		}
		/*
		 * Return goes to loc. 0 of user init code just copied out.
		 */
		return;
	}
	strcpy(u.u_comm, "scheduler");
	proc[0].p_szpt = 1;
	sched();
}

/*
 * Initialize hash links for buffers.
 */
bhinit()
{
	register int i;
	register struct bufhd *bp;

	for (bp = bufhash, i = 0; i < BUFHSZ; i++, bp++)
		bp->b_forw = bp->b_back = (struct buf *)bp;
}

/*
 * Initialize the buffer I/O system by freeing
 * all buffers and setting all device buffer lists to empty.
 */
binit()
{
	register struct buf *bp, *dp;
	register int i;
	struct swdevt *swp;
	int base, residual;

	for (dp = bfreelist; dp < &bfreelist[BQUEUES]; dp++) {
		dp->b_forw = dp->b_back = dp->av_forw = dp->av_back = dp;
		dp->b_flags = B_HEAD;
	}
#ifdef	QBUS
	/*
	 * Add in 18 bit addressable buffers
	 */
	for (i = 0; i < NBUF18; i++) {
		bp = &buf18[i];
		bp->b_dev = NODEV;
		bp->b_bcount = 0;
		bp->b_un.b_addr = (char *)0;
		bp->b_bufsize = 0;
		binshash(bp, &bfreelist[BQ_EMPTY]);
		bp->b_flags = B_18BIT | B_BUSY|B_INVAL;
		brelse(bp);
	}
#endif  QBUS
	/*
	 * Add in dynamic buffers
	 */
	base = bufpages / nbuf;
	residual = bufpages % nbuf;
	for (i = 0; i < nbuf; i++) {
		bp = &buf[i];
		bp->b_dev = NODEV;
		bp->b_bcount = 0;
#ifdef vax
		bp->b_un.b_addr = buffers + i * MAXBSIZE;
		if (i < residual)
			bp->b_bufsize = (base + 1) * CLBYTES;
		else
			bp->b_bufsize = base * CLBYTES;
		binshash(bp, &bfreelist[BQ_AGE]);
		bp->b_flags = B_BUSY|B_INVAL;
#else
		bp->b_un.b_addr = (char *)0;
		bp->b_bufsize = 0;
		binshash(bp, &bfreelist[BQ_EMPTY]);
		bp->b_flags = B_EBLK|B_22BIT | B_BUSY|B_INVAL;
#endif
		brelse(bp);
	}
	/*
	 * Count swap devices, and adjust total swap space available.
	 * Some of this space will not be available until a vswapon()
	 * system is issued, usually when the system goes multi-user.
	 */
	nswdev = 0;
	nswap = 0;
	for (swp = swdevt; swp->sw_dev; swp++) {
		nswdev++;
		if (swp->sw_nblks > nswap)
			nswap = swp->sw_nblks;
	}
	if (nswdev == 0)
		panic("binit");
	if (nswdev > 1)
		nswap = ((nswap + dmmax - 1) / dmmax) * dmmax;
	nswap *= nswdev;
	maxpgio *= nswdev;
	if (swfree(0))
		panic("binit: swfree");
}

/*
 * Initialize linked list of free swap
 * headers. These do not actually point
 * to buffers, but rather to pages that
 * are being swapped in and out.
 */
bswinit()
{
	register int i;
	register struct buf *sp = swbuf;

	bswlist.av_forw = sp;
	for (i=0; i<nswbuf-1; i++, sp++)
		sp->av_forw = sp+1;
	sp->av_forw = NULL;
}

/*
 * Initialize clist by freeing all character blocks, then count
 * number of character devices. (Once-only routine)
 */
cinit()
{
	register int ccp;
	register struct cblock *cp;

	ccp = (int)cfree;
	ccp = (ccp+CROUND) & ~CROUND;
	for(cp=(struct cblock *)ccp; cp < &cfree[nclist-1]; cp++) {
		cp->c_next = cfreelist;
		cfreelist = cp;
		cfreecount += CBSIZE;
	}
}
