/*#define	NOVFORK	/**/
/*	Rsyscalls.c	6.5.1	85/02/28	*/

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/kernel.h"
#include "../h/file.h"
#include "../h/stat.h"
#include "../h/inode.h"
#include "../h/fs.h"
#include "../h/buf.h"
#include "../h/proc.h"
#include "../h/quota.h"
#include "../h/uio.h"
#include "../h/socket.h"
#include "../h/socketvar.h"
#include "../h/nami.h"
#include "../h/mount.h"

int	rem_rw(), rem_ioctl(), rem_select(), rem_close();
struct 	fileops remoteops =
	{ rem_rw, rem_ioctl, rem_select, rem_close };
int	ino_rw(), ino_ioctl(), ino_select();
struct 	fileops rinodeops =
	{ ino_rw, ino_ioctl, ino_select, rem_close };
struct 	fileops inodeops;

struct buf *RemotePathBP;	/* gets set in namei */
unsigned long RemoteRpid;	/* gets set in namei */
int RemoteNamed;		/* gets set in namei */
unsigned long MidToRpid();

/*
 * Allocate an incore inode for access to a local device.
 *  This inode never gets written back out to disk (for now).
 */
struct inode *
GetInode(rpid, rfdes)
  unsigned long rpid;
  int rfdes;
  {
	struct inode ino, *iset();

	REMGetInode(rpid, rfdes, &ino, sizeof ino);
	if (u.u_error)
		return NULL;
	ino.i_flag |= ILOCKED;
	ino.i_count = 1;
	ino.i_number += rpid & 0xFF000000;
	ino.i_fs = NULL;
	ino.i_lastr = 0;
	return iset(&ino);
}

Rrexit()
  {
	struct a {
		int	rval;
	} *uap;

	Rexit((((struct a *)u.u_ap)->rval & 0377) << 8);
}

Rexit(val)
  int val;
  {
	register struct Rrpid *p = u.u_Rrpid, *q;
	register unsigned long rpid;
	register unsigned short i, j;

	for (i = 0;  i < NOFILE+3;  i += 1) {
		if (rpid = p->u_m_rpid) {
			REMexit(rpid);
			q = p;
			for (j = i;  j < NOFILE+3;  j += 1) {
				if (q->u_m_rpid == rpid)
					q->u_m_rpid = 0;
				q += 1;
			}
		}
		p += 1;
	}
	exit(val);
}

/*
 * Fork system call, with remote capability.
 */
Rfork()
  {
	u.u_cdmap = zdmap;
	u.u_csmap = zdmap;
	if (swpexpand(u.u_dsize, u.u_ssize, &u.u_cdmap, &u.u_csmap) == 0) {
		u.u_r.r_val2 = 0;
		return;
	}
	Rfork1(0);
}

Rvfork()
  {
#ifdef	NOVFORK
	Rfork();
#else	NOVFORK
	Rfork1(1);
#endif	NOVFORK
}

Rfork1(isvfork)
  int isvfork;
  {
	register struct Rrpid *p0, *p1, *q0, *q1;
	register unsigned long rpid;
	register short i, j;
	struct Rrpid chrpid[NOFILE+3];	/* watch out if NOFILE gets too big */

	q0 = chrpid;
	for (i = 0;  i < NOFILE+3;  i += 1)
		q0++->u_m_rpid = 0;

	/*
	 * First replicate all our cousins.
	 *  Keep track of their rpids in chrpid.
	 */
	p0 = u.u_Rrpid;
	q0 = chrpid;
	i = NOFILE+3;
	while (--i >= 0) {
		if (rpid = p0++->u_m_rpid) {
			p1 = u.u_Rrpid;
			q1 = chrpid;
			j = NOFILE+3 - i;
			while (--j) {
				if (p1++->u_m_rpid == rpid) {
					q0->u_m_rpid = q1->u_m_rpid;
					break;	/* already replicated */
				}
				q1 += 1;
			}
			if (j == 0  &&  REMfork(rpid, &q0->u_m_rpid))
				if (u.u_error == ESRCH) {
					InvalidateRpid(rpid);
					u.u_error = 0;
				} else
					break;
		}
		q0 += 1;
	}
	if (u.u_error == 0)
		fork1(isvfork);

	/*
	 * If an error has been encountered, either in forking our
	 *  cousins or in forking ourself, we must kill off any
	 *  new cousins that we did manage to create.
	 */
	if (u.u_error) {
		int errsav = u.u_error;
		u.u_error = 0;
		q0 = chrpid;
		i = NOFILE+3;
		while (--i >= 0) {
			if (rpid = q0++->u_m_rpid) {
				q1 = chrpid;
				j = NOFILE+3 - i;
				while (--j > 0  &&  q1++->u_m_rpid != rpid)
					;
				if (j == 0) {
					u.u_error = 0;	/* is this necessary? */
					REMexit(rpid);
				}
			}
		}
		u.u_error = errsav;
	} else if (u.u_r.r_val2) {
		p0 = u.u_Rrpid;
		q0 = chrpid;
		i = NOFILE+3;
		while (--i >= 0)
			p0++->u_m_rpid = q0++->u_m_rpid;
	}
}

/*
 * Change current working directory (``.'').
 */
Rchdir()
  {
	Rchdirec(&u.u_cdir, &u.u_Rrcdirmid);
}

/*
 * Change notion of root (``/'') directory.
 */
Rchroot()
  {
	if (suser())
		Rchdirec(&u.u_rdir, &u.u_Rrrdirmid);
}

/*
 * Common routine for chroot and chdir.
 */
Rchdirec(ipp, midp)
  register struct inode **ipp;
  register unsigned short *midp;
  {
	register struct buf *bp;
	register unsigned long rpid;
	register unsigned short mid;

	u.u_Rok = 2;
	if (setjmp(&u.u_Rsave) == 0) {
		chdirec(ipp);
		u.u_Rok = 0;
		if (u.u_error == 0  &&  *midp) {
			if (rpid = MidToRpid(*midp))
				REMchdirec(rpid, (char *)-1, ipp == &u.u_rdir);
			*midp = 0;	/* changed to current machine */
		}
		return;
	}
	u.u_Rok = 0;
	bp = RemotePathBP;
	mid = RemoteRpid >> 16;
	if (u.u_error == 0) {
		REMchdirec(RemoteRpid, bp->b_un.b_addr, ipp == &u.u_rdir);
		brelse(bp);
		if (u.u_error == 0) {
			if (*midp  &&  *midp != mid  &&
			    (rpid = MidToRpid(*midp)))
				REMchdirec(rpid, (char *)-1, ipp == &u.u_rdir);
			*midp = mid;
		}
	}
}

/*
 * Open system call, with remote capability.
 */
Ropen()
  {
	struct a {
		char	*fname;
		int	mode;
		int	crtmode;
	} *uap = (struct a *) u.u_ap;

	Rcopen(uap->mode-FOPEN, uap->crtmode);
}

/*
 * Creat system call, with remote capability.
 */
Rcreat()
  {
	struct a {
		char	*fname;
		int	fmode;
	} *uap = (struct a *)u.u_ap;

	Rcopen(FWRITE|FCREAT|FTRUNC, uap->fmode);
}

/*
 * Common code for open and creat, with remote capability.
 */
Rcopen(mode, arg)
  int mode;
  int arg;
  {
	register struct file *fp = NULL;
	register struct buf *bp;
	register struct inode *ip = NULL;
	register unsigned long rpid;
	int rfdes, ftype, i, rnamed;

	u.u_Rok = 2;
	if (setjmp(&u.u_Rsave) == 0) {
		copen(mode, arg);
		u.u_Rok = 0;
		return;
	}
	u.u_Rok = 0;
	bp = RemotePathBP;
	rpid = RemoteRpid;
	rnamed = RemoteNamed;
	if (u.u_error  ||  (fp = falloc()) == NULL) {
		brelse(bp);
		return;
	}
	i = u.u_r.r_val1;
#define	FLDEV	020000		/* should be in file.h */
	if (rnamed == 0)
		mode |= FLDEV;
	REMcopen(rpid, bp->b_un.b_addr, mode, arg, &rfdes, &ftype);
	if (u.u_error == EXDEV) {
		extern struct inode *iset();

		u.u_error = 0;
		ip = (struct inode *)bp->b_un.b_addr;
		ip->i_flag |= ILOCKED;
		ip->i_count = 1;
		ip->i_number += rpid & 0xFF000000;
		ip->i_fs = NULL;
		ip->i_lastr = 0;
		ip = iset(ip);
		iunlock(ip);
		brelse(bp);
		fp->f_flag = mode&FMASK;
		fp->f_type = DTYPE_INODE;
		fp->f_ops = &inodeops;
		fp->f_data = (caddr_t)ip;
		if (setjmp(&u.u_qsave)) {
			if (u.u_error == 0)
				u.u_error = EINTR;
			u.u_ofile[i] = NULL;
			closef(fp);
			return;
		}
		if ((u.u_error = openi(ip, mode)) == 0)
			return;
		u.u_ofile[i] = NULL;
		fp->f_count--;
		irele(ip);
		return;
	}
	brelse(bp);
	if (u.u_error)
		goto bad;
	ftype &= IFMT;
	goto new;
	if (rootdev == makedev(6, 0)  &&
	    (ftype == IFCHR  ||  ftype == IFBLK)) {
		if ((ip = GetInode(rpid, rfdes)) != NULL) {
			iunlock(ip);
			fp->f_flag = mode&FMASK;
			fp->f_type = DTYPE_INODE;
			fp->f_ops = &rinodeops;
			fp->f_data = (caddr_t)ip;
			fp->f_mid = rpid >> 16;
			fp->f_rfdes = rfdes;
			if (setjmp(&u.u_qsave)) {
				if (u.u_error == 0)
					u.u_error = EINTR;
				u.u_ofile[i] = NULL;
				closef(fp);
				REMclose(rpid, rfdes);
				return;
			}
			u.u_error = openi(ip, mode);
			if (u.u_error == 0) {
				ip->i_count++;
				return;
			}
			u.u_ofile[i] = NULL;
			closef(fp);
			REMclose(rpid, rfdes);
			return;
		} else
			REMclose(rpid, rfdes);
	} else {
  new:
		fp->f_flag = mode&FMASK;
		fp->f_type = DTYPE_REMOTE;
		fp->f_ops = &remoteops;	/* XXX */
		fp->f_data = NULL;
		fp->f_mid = rpid >> 16;
		fp->f_rfdes = rfdes;
		if (ftype != IFCHR)		/* if not a char device, then */
			fp->f_flag |= FSELTRUE;	/*  select always rtrns true  */
	}
  bad:
	if (u.u_error  &&  fp) {
		u.u_ofile[i] = NULL;
		fp->f_count--;
	}
}

rem_close(fp)
  register struct file *fp;
  {
	unsigned long rpid;

	/*
	 * If we are exiting then we already terminated all our cousins
	 *  in which case we don't have to worry about remote closing.
	 */
	if ((u.u_procp->p_flag & SWEXIT) == 0)
		if (rpid = MidToRpid(fp->f_mid))
			REMclose(rpid, fp->f_rfdes);
	fp->f_mid = 0;
	if (fp->f_data)
		ino_close(fp);
}

rem_rw(fp, rw, uio)
  register struct file *fp;
  enum uio_rw rw;
  register struct uio *uio;
  {
	int i = (rw == UIO_READ) ? 0 : (fp->f_flag & FAPPEND) ? 2 : 1;
	unsigned long rpid;

	if (rpid = MidToRpid(fp->f_mid)) {
		u.u_Ruio = uio;		/* to be used during copyto/copyfrom */
		i = REMrw(i, rpid, fp->f_rfdes, uio->uio_iov->iov_base,
			  uio->uio_offset, uio->uio_resid, &uio->uio_resid);
		u.u_Ruio = NULL;
		return i;
	}
	return u.u_error;
}

rem_ioctl(fp, com, data)
  struct file *fp;
  int com;
  char *data;
  {
	unsigned long rpid;

	if (rpid = MidToRpid(fp->f_mid))
		return REMioctl(rpid, fp->f_rfdes, com, data);
	return u.u_error;
}

rem_select(fp, which)
  struct file *fp;
  int which;
  {
	unsigned long rpid;

	if (fp->f_flag & FSELTRUE)
		return 1;
	if (rpid = MidToRpid(fp->f_mid))
		return REMselect(rpid, fp->f_rfdes, which);
	return 0;
}

/*
 * Stat system call, with remote capability.  This version follows links.
 */
Rstat()
  {
	Rstat1(1);
}

/*
 * Lstat system call, with remote capability.
 *  This version does not follow links.
 */
Rlstat()
  {
	Rstat1(0);
}

Rstat1(follow)
  int follow;
  {
	register struct a {
		char	*fname;
		struct stat *ub;
	} *uap = (struct a *)u.u_ap;
	register struct buf *bp;

	u.u_Rok = 2;
	if (setjmp(&u.u_Rsave) == 0) {
		stat1(follow);
		u.u_Rok = 0;
		return;
	}
	u.u_Rok = 0;
	bp = RemotePathBP;
	if (u.u_error == 0) {
		REMstat(RemoteRpid, bp->b_un.b_addr, follow);
		if (u.u_error == 0)
			u.u_error = copyout(bp->b_un.b_addr, uap->ub,
							sizeof(struct stat));
	}
	brelse(bp);
}

Rfstat()
{
	register struct file *fp;
	register struct a {
		int	fdes;
		struct	stat *sb;
	} *uap = (struct a *)u.u_ap;
	unsigned long rpid;

	if (fp = getf(uap->fdes)) {
		if (fp->f_type == DTYPE_REMOTE) {
			if (rpid = MidToRpid(fp->f_mid))
				REMfstat(rpid, fp->f_rfdes,
					uap->sb, sizeof(struct stat), 0);
		} else {
			fstat();
		}
	}
}

/*
 * Access system call, with remote capability.
 */
Rsaccess()
  {
	struct a {
		char	*fname;
		int	fmode;
	};
	register struct buf *bp;
	int svuid, svgid;

	svuid = u.u_uid;
	svgid = u.u_gid;
	u.u_Rok = 2;
	if (setjmp(&u.u_Rsave) == 0) {
		saccess();
		u.u_Rok = 0;
		u.u_uid = svuid;
		u.u_gid = svgid;
		return;
	}
	u.u_Rok = 0;
	u.u_uid = svuid;
	u.u_gid = svgid;
	bp = RemotePathBP;
	if (u.u_error == 0)
		REMaccess(RemoteRpid, bp->b_un.b_addr,
						((struct a *)u.u_ap)->fmode);
	brelse(bp);
}

Runlink()
  {
	struct buf *bp;

	u.u_Rok = 2;
	if (setjmp(&u.u_Rsave) == 0) {
		unlink();
		u.u_Rok = 0;
		return;
	}
	u.u_Rok = 0;
	bp = RemotePathBP;
	if (u.u_error == 0)
		REMunlink(RemoteRpid, bp->b_un.b_addr);
	brelse(bp);
}

Rlseek()
  {
	register struct a {
		int	fd;
		off_t	off;
		int	sbase;
	} *uap = (struct a *)u.u_ap;
	struct file *getinode();
	register struct file *fp = getinode(uap->fd);
	struct stat sb;
	unsigned long rpid;

	if (fp == NULL)
		return;
	if (fp->f_type != DTYPE_REMOTE  ||  uap->sbase != L_XTND) {
		lseek();
		return;
	}
	if (rpid = MidToRpid(fp->f_mid))
		REMfstat(rpid, fp->f_rfdes, &sb, sizeof sb, 1);
	if (u.u_error == 0)
		u.u_r.r_off = fp->f_offset = uap->off + sb.st_size;
}

Rlink()
  {
	register struct a {
		char	*target;
		char	*linkname;
	} *uap = (struct a *)u.u_ap;

	u.u_Rok = 2;
	if (setjmp(&u.u_Rsave) == 0) {
		register struct inode *ip, *xp;

		ip = namei(uchar, LOOKUP, 1);
		u.u_Rok = 0;
		if (ip == NULL)
			return;
		if ((ip->i_mode&IFMT) == IFDIR && !suser()) {
			iput(ip);
			return;
		}
		ip->i_nlink++;
		ip->i_flag |= ICHG;
		iupdat(ip, &time, &time, 1);
		iunlock(ip);
		u.u_dirp = (caddr_t)uap->linkname;
		u.u_Rok = 2;
		if (setjmp(&u.u_Rsave) == 0) {
			xp = namei(uchar, CREATE, 0);
			u.u_Rok = 0;
			if (xp != NULL) {
				u.u_error = EEXIST;
				iput(xp);
				goto out;
			}
			if (u.u_error)
				goto out;
			if (u.u_pdir->i_dev != ip->i_dev) {
				iput(u.u_pdir);
				u.u_error = EXDEV;
				goto out;
			}
			u.u_error = direnter(ip);
  out:
			if (u.u_error) {
				ip->i_nlink--;
				ip->i_flag |= ICHG;
			}
			irele(ip);
			return;
		}
		u.u_Rok = 0;
/*RRR*/		brelse(RemotePathBP);
		u.u_error = EXDEV;
		goto out;
	} else {
		register struct buf *bp0;
		register unsigned long rpid;

		u.u_Rok = 0;
		bp0 = RemotePathBP;
		rpid = RemoteRpid;
		if (u.u_error == 0) {
			char *p, *PathConcat();
			struct buf *bp1;

			u.u_dirp = (caddr_t)uap->linkname;
			u.u_Rok = 2;
			if (setjmp(&u.u_Rsave) == 0) {
				register struct inode *ip;

				ip = namei(uchar, LOOKUP, 1);
				u.u_Rok = 0;
				brelse(bp0);
				if (ip)
					iput(ip);
				u.u_error = EXDEV;
				return;
			}
			u.u_Rok = 0;
			bp1 = RemotePathBP;
			if (rpid == RemoteRpid) {
				if (p = PathConcat(bp0, bp1->b_un.b_addr))
					REMlink(rpid, bp0->b_un.b_addr, p);
			} else
				u.u_error = EXDEV;
			brelse(bp1);
		}
		if (bp0  &&  (bp0->b_flags & B_BUSY))
			brelse(bp0);
	}
}

Rsymlink()
  {
	register struct a {
		char	*target;
		char	*linkname;
	} *uap = (struct a *)u.u_ap;
	register struct buf *bp;
	register unsigned long rpid;

	u.u_Rok = 2;
	if (setjmp(&u.u_Rsave) == 0) {
		symlink();
		u.u_Rok = 0;
		return;
	}
	u.u_Rok = 0;
	bp = RemotePathBP;
	rpid = RemoteRpid;
	if (u.u_error == 0) {
		char *p, *PathConcat();

		u.u_dirp = (caddr_t)uap->target;
		if (p = PathConcat(bp, (char *)0))
			REMsymlink(rpid, bp->b_un.b_addr, p);
	}
	if (bp  &&  (bp->b_flags & B_BUSY))
		brelse(bp);
}

Rreadlink()
  {
	register struct a {
		char	*name;
		char	*buf;
		int	count;
	} *uap = (struct a *)u.u_ap;
	struct buf *bp;
	int len;

	u.u_Rok = 2;
	if (setjmp(&u.u_Rsave) == 0) {
		readlink();
		u.u_Rok = 0;
		return;
	}
	u.u_Rok = 0;
	bp = RemotePathBP;
	if (u.u_error == 0) {
		len = bp->b_bcount;
		REMreadlink(RemoteRpid, bp->b_un.b_addr, &len);
		if (u.u_error == 0) {
			if (uap->count < len)
				len = uap->count;
			u.u_r.r_val1 = len;
			u.u_error = copyout(bp->b_un.b_addr, uap->buf, len);
		}
	}
	brelse(bp);
}

Rmknod()
  {
	struct a {
		char	*fname;
		int	fmode;
		int	dev;
	} *uap = (struct a *)u.u_ap;
	register struct buf *bp;

	u.u_Rok = 2;
	if (setjmp(&u.u_Rsave) == 0) {
		mknod();
		u.u_Rok = 0;
		return;
	}
	u.u_Rok = 0;
	bp = RemotePathBP;
	if (u.u_error == 0)
		REMmknod(RemoteRpid, bp->b_un.b_addr, uap->fmode, uap->dev);
	brelse(bp);
}

Rmkdir()
  {
	struct a {
		char	*fname;
		int	dmode;
	};
	struct buf *bp;

	u.u_Rok = 2;
	if (setjmp(&u.u_Rsave) == 0) {
		mkdir();
		u.u_Rok = 0;
		return;
	}
	u.u_Rok = 0;
	bp = RemotePathBP;
	if (u.u_error == 0)
		REMmkdir(RemoteRpid, bp->b_un.b_addr,
						((struct a *)u.u_ap)->dmode);
	brelse(bp);
}

Rrmdir()
  {
	struct buf *bp;

	u.u_Rok = 2;
	if (setjmp(&u.u_Rsave) == 0) {
		rmdir();
		u.u_Rok = 0;
		return;
	}
	u.u_Rok = 0;
	bp = RemotePathBP;
	if (u.u_error == 0)
		REMrmdir(RemoteRpid, bp->b_un.b_addr);
	brelse(bp);
}

Rchmod()
  {
	struct a {
		char	*fname;
		int	fmode;
	};
	struct buf *bp;

	u.u_Rok = 2;
	if (setjmp(&u.u_Rsave) == 0) {
		chmod();
		u.u_Rok = 0;
		return;
	}
	u.u_Rok = 0;
	bp = RemotePathBP;
	if (u.u_error == 0)
		REMchmod(RemoteRpid, bp->b_un.b_addr,
						((struct a *)u.u_ap)->fmode);
	brelse(bp);
}

Rfchmod()
  {
	register struct file *fp;
	register struct a {
		int	fd;
		int	fmode;
	} *uap = (struct a *)u.u_ap;
	unsigned long rpid;

	if (fp = getinode(uap->fd)) {
		if (fp->f_type == DTYPE_REMOTE) {
			if (rpid = MidToRpid(fp->f_mid))
				REMfchmod(rpid, fp->f_rfdes, uap->fmode);
		} else {
			fchmod();
		}
	}
}

Rchown()
  {
	register struct a {
		char	*fname;
		int	uid;
		int	gid;
	} *uap = (struct a *)u.u_ap;
	struct buf *bp;

	u.u_Rok = 2;
	if (setjmp(&u.u_Rsave) == 0) {
		chown();
		u.u_Rok = 0;
		return;
	}
	u.u_Rok = 0;
	bp = RemotePathBP;
	if (u.u_error == 0)
		REMchown(RemoteRpid, bp->b_un.b_addr, uap->uid, uap->gid);
	brelse(bp);
}

Rfchown()
  {
	register struct file *fp;
	register struct a {
		int	fd;
		int	uid;
		int	gid;
	} *uap = (struct a *)u.u_ap;
	unsigned long rpid;

	if (fp = getinode(uap->fd)) {
		if (fp->f_type == DTYPE_REMOTE) {
			if (rpid = MidToRpid(fp->f_mid))
				REMfchown(rpid, fp->f_rfdes,
						uap->uid, uap->gid);
		} else {
			fchown();
		}
	}
}

Rtruncate()
  {
	struct a {
		char		*fname;
		unsigned long	length;
	};
	struct buf *bp;

	u.u_Rok = 2;
	if (setjmp(&u.u_Rsave) == 0) {
		truncate();
		u.u_Rok = 0;
		return;
	}
	u.u_Rok = 0;
	bp = RemotePathBP;
	if (u.u_error == 0)
		REMtruncate(RemoteRpid, bp->b_un.b_addr,
						((struct a *)u.u_ap)->length);
	brelse(bp);
}

Rftruncate()
  {
	register struct file *fp;
	register struct a {
		int		fd;
		unsigned long	length;
	} *uap = (struct a *)u.u_ap;
	unsigned long rpid;

	if (fp = getinode(uap->fd)) {
		if (fp->f_type == DTYPE_REMOTE) {
			if (rpid = MidToRpid(fp->f_mid))
				REMftruncate(rpid, fp->f_rfdes, uap->length);
		} else {
			ftruncate();
		}
	}
}

Rutimes()
  {
	struct a {
		char		*fname;
		struct timeval	*tptr;
	} *uap = (struct a *)u.u_ap;
	struct timeval tv[2];
	struct buf *bp;

	u.u_Rok = 2;
	if (setjmp(&u.u_Rsave) == 0) {
		utimes();
		u.u_Rok = 0;
		return;
	}
	u.u_Rok = 0;
	bp = RemotePathBP;
	if (u.u_error == 0)
		if ((u.u_error = copyin(uap->tptr, tv, sizeof tv)) == 0)
			REMutimes(RemoteRpid, bp->b_un.b_addr,
						tv[0].tv_sec, tv[1].tv_sec);
	brelse(bp);
}

Rfsync()
  {
	register struct file *fp;
	struct a {
		int	fd;
	};
	unsigned long rpid;

	if (fp = getinode(((struct a *)u.u_ap)->fd)) {
		if (fp->f_type == DTYPE_REMOTE) {
			if (rpid = MidToRpid(fp->f_mid))
				REMfsync(rpid, fp->f_rfdes);
		} else {
			fsync();
		}
	}
}

/*
 * Apply an advisory lock on a file descriptor.
 */
Rflock()
  {
	register struct a {
		int	fd;
		int	how;
	} *uap = (struct a *)u.u_ap;
	register struct file *fp;
	unsigned long rpid;

	if (fp = getf(uap->fd)) {
		if (fp->f_type == DTYPE_REMOTE) {
			if (rpid = MidToRpid(fp->f_mid))
				REMflock(rpid, fp->f_rfdes, uap->how);
		} else {
			flock();
		}
	}
}

#ifdef	LOCKF
Rlockf()
  {
	register struct a {
		int	fd;
		int	flag;
		off_t	size;
	} *uap = (struct a *)u.u_ap;
	register struct file *fp;
	unsigned long rpid;

	if (fp = getf(uap->fd)) {
		if (fp->f_type == DTYPE_REMOTE) {
			if (rpid = MidToRpid(fp->f_mid))
				REMlockf(rpid, fp->f_rfdes, uap->flag,
								uap->size);
		} else {
			lockf();
		}
	}
}
#endif	LOCKF

Rrename()
  {
	register struct a {
		char	*from;
		char	*to;
	} *uap = (struct a *)u.u_ap;
	register struct inode *ip, *xp, *dp;
	int oldparent, parentdifferent, doingdirectory;
	int error = 0;

	u.u_Rok = 2;
	if (setjmp(&u.u_Rsave)) {
		register struct buf *bp0;
		register unsigned long rpid;

		u.u_Rok = 0;
		bp0 = RemotePathBP;
		rpid = RemoteRpid;
		if (u.u_error == 0) {
			char *p, *PathConcat();
			struct buf *bp1;

			u.u_dirp = (caddr_t)uap->to;
			u.u_Rok = 2;
			if (setjmp(&u.u_Rsave) == 0) {
				register struct inode *ip;

				ip = namei(uchar, LOOKUP, 1);
				u.u_Rok = 0;
				brelse(bp0);
				if (ip)
					iput(ip);
				u.u_error = EXDEV;
				return;
			}
			u.u_Rok = 0;
			bp1 = RemotePathBP;
			if (rpid == RemoteRpid) {
				if (p = PathConcat(bp0, bp1->b_un.b_addr))
					REMrename(rpid, bp0->b_un.b_addr, p);
			} else
				u.u_error = EXDEV;
			brelse(bp1);
		}
		if (bp0  &&  (bp0->b_flags & B_BUSY))
			brelse(bp0);
		return;
	}
	ip = namei(uchar, DELETE | LOCKPARENT, 0);
	u.u_Rok = 0;
	if (ip == NULL)
		return;
	dp = u.u_pdir;
	oldparent = 0, doingdirectory = 0;
	if ((ip->i_mode&IFMT) == IFDIR) {
		register struct direct *d;

		d = &u.u_dent;
		/*
		 * Avoid ".", "..", and aliases of "." for obvious reasons.
		 */
		if ((d->d_namlen == 1 && d->d_name[0] == '.') ||
		    (d->d_namlen == 2 && bcmp(d->d_name, "..", 2) == 0) ||
		    (dp == ip)) {
			iput(dp);
			if (dp == ip)
				irele(ip);
			else
				iput(ip);
			u.u_error = EINVAL;
			return;
		}
		oldparent = dp->i_number;
		doingdirectory++;
	}
	iput(dp);

	/*
	 * 1) Bump link count while we're moving stuff
	 *    around.  If we crash somewhere before
	 *    completing our work, the link count
	 *    may be wrong, but correctable.
	 */
	ip->i_nlink++;
	ip->i_flag |= ICHG;
	iupdat(ip, &time, &time, 1);
	iunlock(ip);

	/*
	 * When the target exists, both the directory
	 * and target inodes are returned locked.
	 */
	u.u_Rok = 2;
	if (setjmp(&u.u_Rsave)) {
		u.u_Rok = 0;
/*RRR*/		brelse(RemotePathBP);
		error = EXDEV;
		goto out;
	}
	u.u_dirp = (caddr_t)uap->to;
	xp = namei(uchar, CREATE | LOCKPARENT | NOCACHE, 0);
	u.u_Rok = 0;
	if (u.u_error) {
		error = u.u_error;
		goto out;
	}
	dp = u.u_pdir;
	/*
	 * If ".." must be changed (ie the directory gets a new
	 * parent) then the source directory must not be in the
	 * directory heirarchy above the target, as this would
	 * orphan everything below the source directory. Also
	 * the user must have write permission in the source so
	 * as to be able to change "..". We must repeat the call 
	 * to namei, as the parent directory is unlocked by the
	 * call to checkpath().
	 */
	parentdifferent = oldparent != dp->i_number;
	if (doingdirectory && parentdifferent) {
		if (access(ip, IWRITE))
			goto bad;
		do {
			dp = u.u_pdir;
			if (xp != NULL)
				iput(xp);
			u.u_error = checkpath(ip, dp);
			if (u.u_error)
				goto out;
			u.u_Rok = 2;
			if (setjmp(&u.u_Rsave))
				panic("rename: name changed 0");
			u.u_dirp = (caddr_t)uap->to;
			xp = namei(uchar, CREATE | LOCKPARENT | NOCACHE, 0);
			u.u_Rok = 0;
			if (u.u_error) {
				error = u.u_error;
				goto out;
			}
		} while (dp != u.u_pdir);
	}
	/*
	 * 2) If target doesn't exist, link the target
	 *    to the source and unlink the source. 
	 *    Otherwise, rewrite the target directory
	 *    entry to reference the source inode and
	 *    expunge the original entry's existence.
	 */
	if (xp == NULL) {
		if (dp->i_dev != ip->i_dev) {
			error = EXDEV;
			goto bad;
		}
		/*
		 * Account for ".." in directory.
		 * When source and destination have the
		 * same parent we don't fool with the
		 * link count -- this isn't required
		 * because we do a similar check below.
		 */
		if (doingdirectory && parentdifferent) {
			dp->i_nlink++;
			dp->i_flag |= ICHG;
			iupdat(dp, &time, &time, 1);
		}
		error = direnter(ip);
		if (error)
			goto out;
	} else {
		if (xp->i_dev != dp->i_dev || xp->i_dev != ip->i_dev) {
			error = EXDEV;
			goto bad;
		}
		/*
		 * Short circuit rename(foo, foo).
		 */
		if (xp->i_number == ip->i_number)
			goto bad;
		/*
		 * Target must be empty if a directory
		 * and have no links to it.
		 * Also, insure source and target are
		 * compatible (both directories, or both
		 * not directories).
		 */
		if ((xp->i_mode&IFMT) == IFDIR) {
			if (!dirempty(xp) || xp->i_nlink > 2) {
				error = ENOTEMPTY;
				goto bad;
			}
			if (!doingdirectory) {
				error = ENOTDIR;
				goto bad;
			}
		} else if (doingdirectory) {
			error = EISDIR;
			goto bad;
		}
		dirrewrite(dp, ip);
		if (u.u_error) {
			error = u.u_error;
			goto bad1;
		}
		/*
		 * Adjust the link count of the target to
		 * reflect the dirrewrite above.  If this is
		 * a directory it is empty and there are
		 * no links to it, so we can squash the inode and
		 * any space associated with it.  We disallowed
		 * renaming over top of a directory with links to
		 * it above, as we've no way to determine if
		 * we've got a link or the directory itself, and
		 * if we get a link, then ".." will be screwed up.
		 */
		xp->i_nlink--;
		if (doingdirectory) {
			if (--xp->i_nlink != 0)
				panic("rename: linked directory");
			itrunc(xp, (u_long)0);
		}
		xp->i_flag |= ICHG;
		iput(xp);
		xp = NULL;
	}

	/*
	 * 3) Unlink the source.
	 */
	u.u_Rok = 2;
	if (setjmp(&u.u_Rsave))
		panic("rename: name changed 1");
	u.u_dirp = uap->from;
	dp = namei(uchar, DELETE, 0);
	u.u_Rok = 0;
	/*
	 * Insure directory entry still exists and
	 * has not changed since the start of all
	 * this.  If either has occured, forget about
	 * about deleting the original entry and just
	 * adjust the link count in the inode.
	 */
	if (dp == NULL || u.u_dent.d_ino != ip->i_number) {
		ip->i_nlink--;
		ip->i_flag |= ICHG;
	} else {
		/*
		 * If source is a directory, must adjust
		 * link count of parent directory also.
		 * If target didn't exist and source and
		 * target have the same parent, then we
		 * needn't touch the link count, it all
		 * balances out in the end.  Otherwise, we
		 * must do so to reflect deletion of ".."
		 * done above.
		 */
		if (doingdirectory && (xp != NULL || parentdifferent)) {
			dp->i_nlink--;
			dp->i_flag |= ICHG;
		}
		if (dirremove()) {
			ip->i_nlink--;
			ip->i_flag |= ICHG;
		}
		if (error == 0)		/* conservative */
			error = u.u_error;
	}
	irele(ip);
	if (dp)
		iput(dp);

	/*
	 * 4) Renaming a directory with the parent
	 *    different requires ".." to be rewritten.
	 *    The window is still there for ".." to
	 *    be inconsistent, but this is unavoidable,
	 *    and a lot shorter than when it was done
	 *    in a user process.
	 */
	if (doingdirectory && parentdifferent && error == 0) {
		struct dirtemplate dirbuf;

		u.u_Rok = 2;
		if (setjmp(&u.u_Rsave))
			panic("rename: name changed 2");
		u.u_dirp = uap->to;
		ip = namei(uchar, LOOKUP | LOCKPARENT, 0);
		u.u_Rok = 0;
		if (ip == NULL) {
			printf("rename: .. went away\n");
			return;
		}
		dp = u.u_pdir;
		if ((ip->i_mode&IFMT) != IFDIR) {
			printf("rename: .. not a directory\n");
			goto stuck;
		}
		error = rdwri(UIO_READ, ip, (caddr_t)&dirbuf,
			sizeof (struct dirtemplate), (off_t)0, 1, (int *)0);
		if (error == 0) {
			dirbuf.dotdot_ino = dp->i_number;
			(void) rdwri(UIO_WRITE, ip, (caddr_t)&dirbuf,
			  sizeof (struct dirtemplate), (off_t)0, 1, (int *)0);
		}
stuck:
		irele(dp);
		iput(ip);
	}
	goto done;

bad:
	iput(dp);
bad1:
	if (xp)
		iput(xp);
out:
	ip->i_nlink--;
	ip->i_flag |= ICHG;
	irele(ip);
done:
	if (error)
		u.u_error = error;
}

static char *
PathConcat(bp, p2)
  register struct buf *bp;
  register char *p2;
  {
	register char *p = bp->b_un.b_addr, *q = p + bp->b_bcount;
	char *s;

	p += strlen(p) + 1;
	s = p;
	do {
		if (p >= q) {
			p = (char *)(p - bp->b_un.b_addr);
			q = (char *)(q - bp->b_un.b_addr);
			if (p > q  ||  bp->b_bcount >= MAXPATHLEN * 2  ||
			    brealloc(bp, MAXPATHLEN * 2) == 0) {
				u.u_error = ENOENT;
				return NULL;
			}
			p = bp->b_un.b_addr + (int)p;
			q = bp->b_un.b_addr + (int)q;
		}
	} while (*p++ = p2 ? *p2++ : uchar());
	return s;
}
