#include "../machine/reg.h"
#include "../machine/pte.h"
#include "../machine/psl.h"

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/map.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/kernel.h"
#include "../h/proc.h"
#include "../h/buf.h"
#include "../h/inode.h"
#include "../h/seg.h"
#include "../h/vm.h"
#include "../h/text.h"
#include "../h/file.h"
#include "../h/uio.h"
#include "../h/nami.h"
#include "../h/acct.h"

#ifdef vax
#include "../vax/mtpr.h"
#endif

struct buf *RemotePathBP;	/* gets set in namei */
unsigned long RemoteRpid;	/* gets set in namei */

/*
 * exec system call, with and without environments.
 */
struct execa {
	char	*fname;
	char	**argp;
	char	**envp;
};

Lchexec(uidp, gidp, newimagep)
  int *uidp, *gidp, *newimagep;
  {
	register struct inode *ip;
	int resid;

	u.u_Rexec = NULL;
	if ((ip = namei(uchar, LOOKUP, 1)) == NULL)
		return;
	if ((ip->i_mode & ISUID)  &&  uidp)
		*uidp = ip->i_uid;
	if ((ip->i_mode & ISGID)  &&  gidp)
		*gidp = ip->i_gid;

	if (access(ip, IEXEC))
		goto bad;
	if ((u.u_procp->p_flag&STRC) && access(ip, IREAD))
		goto bad;
	if ((ip->i_mode & IFMT) != IFREG ||
	   (ip->i_mode & (IEXEC|(IEXEC>>3)|(IEXEC>>6))) == 0) {
		u.u_error = EACCES;
		goto bad;
	}

	/*
	 * Read in first few bytes of file for segment sizes, ux_mag:
	 *	407 = plain executable
	 *	410 = RO text
	 *	413 = demand paged RO text
	 * Also an ASCII line beginning with #! is
	 * the file name of a ``shell'' and arguments may be prepended
	 * to the argument list if given here.
	 *
	 * SHELL NAMES ARE LIMITED IN LENGTH.
	 *
	 * ONLY ONE ARGUMENT MAY BE PASSED TO THE SHELL FROM
	 * THE ASCII LINE.
	 */
	u.u_exdata.ux_shell[0] = 0;	/* for zero length files */
	u.u_error = rdwri(UIO_READ, ip, (caddr_t)&u.u_exdata,
				sizeof (u.u_exdata), 0, 1, &resid);
	if (u.u_error)
		goto bad;
	u.u_count = resid;
#ifndef lint
	if (u.u_count > sizeof(u.u_exdata) - sizeof(u.u_exdata.Ux_A) &&
	    u.u_exdata.ux_shell[0] != '#') {
		u.u_error = ENOEXEC;
		goto bad;
	}
#endif
	/* 
	 * Read in the image type: old images have a page of null after header,
	 * new images have code.
	 */
	u.u_error = rdwri(UIO_READ, ip, (caddr_t)&u.u_newimage, 
		sizeof(u.u_newimage), sizeof (u.u_exdata) + 6, 1, &resid);
	if (u.u_error)
		goto bad;
#ifndef	QBUS
	if (u.u_newimage == 0) {
		u.u_error = ENOEXEC;
		goto bad;
	}
#endif	QBUS
	if (newimagep)
		*newimagep = u.u_newimage;
	iunlock(ip);
	if (u.u_Rexec)
		irele(u.u_Rexec);
	u.u_Rexec = ip;
	return;
  bad:
	iput(ip);
}

Rexecv()
  {
	((struct execa *)u.u_ap)->envp = NULL;
	Rexecve();
}

Rexecve(rp)
  register struct UnixExecve *rp;
  {
	register nc;
	register char *cp;
	register struct buf *bp = NULL;
	register struct execa *uap;
	int na, ne, ucp, ap, c;
	int indir = 0, uid = u.u_uid, gid = u.u_gid, newimage;
	char *sharg;
	struct inode *ip = NULL;
	swblk_t bno = 0;
	char cfname[MAXCOMLEN + 1];
	char cfarg[SHSIZE];
	int resid;
	unsigned long rpid = 0;

	u.u_Rok = 2;
	if (setjmp(&u.u_Rsave)) {
		u.u_Rok = 0;
		bp = RemotePathBP;
		rpid = RemoteRpid;
		if (u.u_error) {
			if (bp)
				brelse(bp);
			return;
		}
		if (indir)
			REMchexec(rpid, bp->b_un.b_addr, (int *)0, (int *)0,
								&newimage);
		else
			REMchexec(rpid, bp->b_un.b_addr, &uid, &gid, &newimage);
		if (u.u_error) {
			brelse(bp);
			return;
		}
		u.u_newimage = newimage;
		cp = bp->b_un.b_addr;
		bcopy(cp, &u.u_exdata, sizeof(u.u_exdata));
		cp += sizeof(u.u_exdata);
		u.u_dent.d_namlen = strlen(cp);
		if (u.u_dent.d_namlen > MAXCOMLEN)
			u.u_dent.d_namlen = MAXCOMLEN;
		bcopy(cp, (caddr_t)u.u_dent.d_name,
		    (unsigned)(u.u_dent.d_namlen + 1));
		brelse(bp);
		bp = NULL;
	} else {
		ip = namei(uchar, LOOKUP, 1);
		u.u_Rok = 0;
		if (ip == NULL)
			return;
		if (ip->i_mode & ISUID)
			uid = ip->i_uid;
		if (ip->i_mode & ISGID)
			gid = ip->i_gid;

  again:
		if (access(ip, IEXEC))
			goto bad;
		if ((u.u_procp->p_flag&STRC) && access(ip, IREAD))
			goto bad;
		if ((ip->i_mode & IFMT) != IFREG ||
		   (ip->i_mode & (IEXEC|(IEXEC>>3)|(IEXEC>>6))) == 0) {
			u.u_error = EACCES;
			goto bad;
		}

		/*
		 * Read in first few bytes of file for segment sizes, ux_mag:
		 *	407 = plain executable
		 *	410 = RO text
		 *	413 = demand paged RO text
		 * Also an ASCII line beginning with #! is
		 * the file name of a ``shell'' and arguments may be prepended
		 * to the argument list if given here.
		 *
		 * SHELL NAMES ARE LIMITED IN LENGTH.
		 *
		 * ONLY ONE ARGUMENT MAY BE PASSED TO THE SHELL FROM
		 * THE ASCII LINE.
		 */
		u.u_exdata.ux_shell[0] = 0;	/* for zero length files */
		u.u_error = rdwri(UIO_READ, ip, (caddr_t)&u.u_exdata,
					sizeof (u.u_exdata), 0, 1, &resid);
		if (u.u_error)
			goto bad;
		u.u_count = resid;
#ifndef lint
		if (u.u_count > sizeof(u.u_exdata) - sizeof(u.u_exdata.Ux_A) &&
		    u.u_exdata.ux_shell[0] != '#') {
			u.u_error = ENOEXEC;
			goto bad;
		}
#endif
		/* 
		 * Read in the image type: old images have a page of null
		 * after header, new images have code.
		 */
		u.u_error = rdwri(UIO_READ, ip, (caddr_t)&u.u_newimage, 
		    sizeof(u.u_newimage), sizeof (u.u_exdata) + 6, 1, &resid);
		if (u.u_error)
			goto bad;
#ifndef	QBUS
		if (u.u_newimage == 0) {
			u.u_error = ENOEXEC;
			goto bad;
		}
#endif	QBUS

	}

	switch (u.u_exdata.ux_mag) {

	case 0407:
		u.u_exdata.ux_dsize += u.u_exdata.ux_tsize;
		u.u_exdata.ux_tsize = 0;
		u.u_newimage = 0;
		break;

	case 0413:
	case 0410:
		if (u.u_exdata.ux_tsize == 0) {
			u.u_error = ENOEXEC;
			goto bad;
		}
		break;

	default:
		if (u.u_exdata.ux_shell[0] != '#' ||
		    u.u_exdata.ux_shell[1] != '!' ||
		    indir) {
			u.u_error = ENOEXEC;
			goto bad;
		}
		cp = &u.u_exdata.ux_shell[2];		/* skip "#!" */
		while (cp < &u.u_exdata.ux_shell[SHSIZE]) {
			if (*cp == '\t')
				*cp = ' ';
			else if (*cp == '\n') {
				*cp = '\0';
				break;
			}
			cp++;
		}
		if (*cp != '\0') {
			u.u_error = ENOEXEC;
			goto bad;
		}
		cp = &u.u_exdata.ux_shell[2];
		while (*cp == ' ')
			cp++;
		u.u_dirp = cp;
		while (*cp && *cp != ' ')
			cp++;
		sharg = NULL;
		if (*cp) {
			*cp++ = '\0';
			while (*cp == ' ')
				cp++;
			if (*cp) {
				bcopy((caddr_t)cp, (caddr_t)cfarg, SHSIZE);
				sharg = cfarg;
			}
		}
		if (u.u_dent.d_namlen > MAXCOMLEN)
			u.u_dent.d_namlen = MAXCOMLEN;
		bcopy((caddr_t)u.u_dent.d_name, (caddr_t)cfname,
		    (unsigned)(u.u_dent.d_namlen + 1));
		cfname[MAXCOMLEN] = 0;
		indir = 1;
		if (ip)
			iput(ip);
		ip = NULL;
		u.u_Rok = 2;
		ip = namei(schar, LOOKUP, 1);	/* may return from setjmp */
		u.u_Rok = 0;
		if (ip == NULL)
			return;
		rpid = 0;	/* cfname may be remote, but interp is local */
		goto again;
	}

	/*
	 * Collect arguments on "file" in swap space.
	 */
	na = 0;
	ne = 0;
	nc = 0;
	uap = (struct execa *)u.u_ap;
	if ((bno = rmalloc(argmap, (long)ctod(clrnd((int)btoc(NCARGS))))) == 0) {
		swkill(u.u_procp, "Rexecve");
		goto bad;
	}
	if (bno % CLSIZE)
		panic("execa rmalloc");
	if (uap->argp) for (;;) {
		ap = NULL;
		if (indir && (na == 1 || na == 2 && sharg))
			ap = (int)uap->fname;
		else if (uap->argp) {
			ap = fuword((caddr_t)uap->argp);
			uap->argp++;
		}
		if (ap==NULL && uap->envp) {
			uap->argp = NULL;
			if ((ap = fuword((caddr_t)uap->envp)) == NULL)
				break;
			uap->envp++;
			ne++;
		}
		if (ap == NULL)
			break;
		na++;
		if (ap == -1)
			u.u_error = EFAULT;
		do {
			if (nc >= NCARGS-1)
				u.u_error = E2BIG;
			if (indir && na == 2 && sharg != NULL)
				c = *sharg++ & 0377;
			else if ((c = fubyte((caddr_t)ap++)) < 0)
				u.u_error = EFAULT;
			if (u.u_error) {
				if (bp)
					brelse(bp);
				bp = 0;
				goto badarg;
			}
			if (nc % (CLSIZE*NBPG) == 0) {
				if (bp)
					bdwrite(bp);
				bp = getblk(argdev, bno + ctod(nc / NBPG),
				    CLSIZE*NBPG);
				cp = bp->b_un.b_addr;
			}
			nc++;
			*cp++ = c;
		} while (c > 0);
	}
	if (bp)
		bdwrite(bp);
	bp = 0;
	nc = (nc + NBPW-1) & ~(NBPW-1);
	if (indir) {
		u.u_dent.d_namlen = strlen(cfname);
		bcopy((caddr_t)cfname, (caddr_t)u.u_dent.d_name,
		    (unsigned)(u.u_dent.d_namlen + 1));
	}
	getxfile(ip, nc + (na+4)*NBPW, uid, gid, rpid);
	if (u.u_error) {
badarg:
		for (c = 0; c < nc; c += CLSIZE*NBPG) {
			bp = baddr(argdev, bno + ctod(c / NBPG), CLSIZE*NBPG);
			if (bp) {
				bp->b_flags |= B_AGE;		/* throw away */
				bp->b_flags &= ~B_DELWRI;	/* cancel io */
				brelse(bp);
				bp = 0;
			}
		}
		goto bad;
	}

	/*
	 * copy back arglist
	 */
	ucp = USRSTACK - nc - NBPW;
	ap = ucp - na*NBPW - 3*NBPW;
	u.u_ar0[SP] = ap;
	(void) suword((caddr_t)ap, na-ne);
	nc = 0;
	for (;;) {
		ap += NBPW;
		if (na==ne) {
			(void) suword((caddr_t)ap, 0);
			ap += NBPW;
		}
		if (--na < 0)
			break;
		(void) suword((caddr_t)ap, ucp);
		do {
			if (nc % (CLSIZE*NBPG) == 0) {
				if (bp)
					brelse(bp);
				bp = bread(argdev, bno + ctod(nc / NBPG),
				    CLSIZE*NBPG);
				bp->b_flags |= B_AGE;		/* throw away */
				bp->b_flags &= ~B_DELWRI;	/* cancel io */
				cp = bp->b_un.b_addr;
			}
			(void) subyte((caddr_t)ucp++, (c = *cp++));
			nc++;
		} while(c&0377);
	}
	(void) suword((caddr_t)ap, 0);
	setregs();
	if (u.u_procp->p_newimage ) {
		int *i,x;

		for (i=0;i < (int *)0x20;i++) {
			if (suiword((caddr_t)i, 0) < 0 ) {
				(void) chgprot((caddr_t)i, RW);
				suiword((caddr_t)i, 0);
				(void) chgprot((caddr_t)i, RO);
			}
		}
	}
bad:
	if (bp)
		brelse(bp);
	if (bno)
		rmfree(argmap, (long)ctod(clrnd((int) btoc(NCARGS))), bno);
	if (ip)
		iput(ip);
}

/*
 * Read in and set up memory for executed file.
 */
static
getxfile(ip, nargc, uid, gid, rpid)
	register struct inode *ip;
	int nargc, uid, gid;
	unsigned long rpid;
{
	register struct proc *p = u.u_procp;
	register size_t ts, ds, ss;
#ifdef	QBUS
	size_t tsup = u.u_newimage ? stoc(ctos(btoc(u.u_exdata.ux_tsize))) :
				stocold(ctos(btoc(u.u_exdata.ux_tsize)));
#else	not QBUS
	size_t tsup = stoc(ctos(btoc(u.u_exdata.ux_tsize)));
#endif	not QBUS
	int pagi;

	if (ip  &&  u.u_exdata.ux_mag == 0413)
		pagi = SPAGI;
	else
		pagi = 0;
	if (ip  &&  u.u_exdata.ux_tsize!=0 && (ip->i_flag&ITEXT)==0 &&
	    ip->i_count!=1) {
		register struct file *fp;

		for (fp = file; fp < fileNFILE; fp++) {
			if (fp->f_type == DTYPE_INODE &&
			    fp->f_count > 0 &&
			    (struct inode *)fp->f_data == ip &&
			    (fp->f_flag&FWRITE)) {
				u.u_error = ETXTBSY;
				goto bad;
			}
		}
	}

	/*
	 * Compute text and data sizes and make sure not too large.
	 */
	if (ip) {
		ts = clrnd(btoc(u.u_exdata.ux_tsize));
		ds = clrnd(btoc((u.u_exdata.ux_dsize+u.u_exdata.ux_bsize)));
	} else {
		ts = 0;
		ds = tsup +
			clrnd(btoc((u.u_exdata.ux_dsize+u.u_exdata.ux_bsize)));
	}
	ss = clrnd(SSIZE + btoc(nargc));
	if (chksize((unsigned)ts, (unsigned)ds, (unsigned)ss))
		goto bad;

	/*
	 * Make sure enough space to start process.
	 */
	u.u_cdmap = zdmap;
	u.u_csmap = zdmap;
	if (swpexpand(ds, ss, &u.u_cdmap, &u.u_csmap) == NULL)
		goto bad;

	/*
	 * At this point, committed to the new image!
	 * Release virtual memory resources of old process, and
	 * initialize the virtual memory of the new process.
	 * If we resulted from vfork(), instead wakeup our
	 * parent who will set SVFDONE when he has taken back
	 * our resources.
	 */
#ifdef	QBUS
	p->p_newimage = u.u_newimage ? 1 : 0;
#endif	QBUS
	if ((p->p_flag & SVFORK) == 0)
		vrelvm();
	else {
		p->p_flag &= ~SVFORK;
		p->p_flag |= SKEEP;
		wakeup((caddr_t)p);
		while ((p->p_flag & SVFDONE) == 0)
			sleep((caddr_t)p, PZERO - 1);
		p->p_flag &= ~(SVFDONE|SKEEP);
	}
	p->p_flag &= ~(SPAGI|SSEQL|SUANOM|SOUSIG);
	p->p_flag |= pagi;
	u.u_dmap = u.u_cdmap;
	u.u_smap = u.u_csmap;
	vgetvm(ts, ds, ss);

	if (u.u_error) {
		printf("u.u_error=%d: ", u.u_error);
		swkill(p, "getxfile0");
	}

	if (ip  &&  pagi == 0)
		u.u_error =
		    rdwri(UIO_READ, ip,
			(char *)ctob(dptov(p, 0)),
			(int)u.u_exdata.ux_dsize,
			(int)(sizeof(u.u_exdata)+u.u_exdata.ux_tsize),
			0, (int *)0);
	if (ip)
		xalloc(ip, pagi, ip->i_dev, getfsx(ip->i_dev), ip->i_number);
	else {
		if (u.u_exdata.ux_tsize) {
			REMload(rpid, ctob(dptov(p, tsup)), u.u_exdata.ux_dsize,
#ifdef	QBUS
				(p->p_newimage ? 0 : 4096) +
#endif	QBUS
				ctob(btoc(u.u_exdata.ux_tsize)));
			REMload(rpid, ctob(dptov(p, 0)), u.u_exdata.ux_tsize,
#ifdef	QBUS
				(p->p_newimage ? 0 : 4096) +
#endif	QBUS
				0);
		} else {
			REMload(rpid, ctob(dptov(p, 0)), u.u_exdata.ux_dsize,
				sizeof(u.u_exdata));
		}
/*		REMload(rpid, 0, 0, 0);	/* ZZZZZ */
	}
	if (ip  &&  pagi && p->p_textp)
		vinifod((struct fpte *)dptopte(p, 0),
		    PG_FTEXT, p->p_textp->x_iptr,
#ifdef	QBUS
		    p->p_newimage ? (long)(ts/CLSIZE) : (long)(1 + ts/CLSIZE), 
#else	QBUS
		    (long)(ts/CLSIZE),
#endif	QBUS
		    (int)btoc(u.u_exdata.ux_dsize));

#ifdef vax
	/* THIS SHOULD BE DONE AT A LOWER LEVEL, IF AT ALL */
	mtpr(TBIA, 0);
#endif

	if (u.u_error) {
		printf("u.u_error=%d: ", u.u_error);
		swkill(p, "getxfile1");
	}
	/*
	 * set SUID/SGID protections, if no tracing
	 */
	if ((p->p_flag&STRC)==0) {
		u.u_uid = uid;
		p->p_uid = uid;
		u.u_gid = gid;
	} else
		psignal(p, SIGTRAP);
/* The following three lines are redundant, superfluous and unneeded.
 *  They also cause diskless workstations to crash.	RPH 12/26/85
 *	u.u_tsize = ts;
 *	u.u_dsize = ds;
 *	u.u_ssize = ss;
 */
	u.u_prof.pr_scale = 0;
bad:
	return;
}

/*
 * Clear registers on exec
 */
static
setregs()
{
	register int i;
	register struct proc *p = u.u_procp;
#ifdef vax
#define	NIREG 12
	static int ireg[NIREG] =
	{R0,R1,R2,R3,R4,R5,R6,R7,R8,R9,R10,R11};
#else
#define	NIREG 15
	static int ireg[NIREG] =
	{R0,R1,R2,R3,R4,R5,R6,R7,R8,R9,R10,R11,R12,R13,R14};
#endif

	/*
	 * Reset caught signals.  Held signals
	 * remain held through p_sigmask.
	 */
	while (p->p_sigcatch) {
		(void) spl6();
		i = ffs(p->p_sigcatch);
		p->p_sigcatch &= ~(1 << (i - 1));
		u.u_signal[i] = SIG_DFL;
		(void) spl0();
	}
/*#ifdef notdef /**/
	/* should pass args to init on the stack */
	for (i = 0 ; i < NIREG ; i++)
		u.u_ar0[ireg[i]] = 0;
	u.u_r.r_val1 = 0;
	u.u_r.r_val2 = 0;
/*#endif /**/
	u.u_ar0[PC] = u.u_exdata.ux_entloc+2;
	for (i=0; i<NOFILE; i++) {
		if (u.u_pofile[i]&UF_EXCLOSE) {
			closef(u.u_ofile[i]);
			u.u_ofile[i] = NULL;
			u.u_pofile[i] = 0;
		}
		u.u_pofile[i] &= ~UF_MAPPED;
	}

	/*
	 * Remember file name for accounting.
	 */
	u.u_acflag &= ~AFORK;
	bcopy((caddr_t)u.u_dent.d_name, (caddr_t)u.u_comm,
	    (unsigned)(u.u_dent.d_namlen + 1));
}
