#include "../h/param.h"
#include "../h/systm.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/ioctl.h"
#include "../h/kernel.h"
#include "../h/file.h"
#include "../h/stat.h"
#include "../h/inode.h"
#include "../h/fs.h"
#include "../h/buf.h"
#include "../h/proc.h"
#include "../h/quota.h"
#include "../h/uio.h"
#include "../h/nami.h"
#include "../h/mount.h"

#include "../h/Remote.h"

unsigned long Mid;

#define	RPID(mid, pid)	(((mid) << 16) + ((pid) & 0xFFFF))

REMGetMid(name, rpidp)
  char *name;
  unsigned long *rpidp;
  {
	register struct GetMid *rp = (struct GetMid *)u.u_Rmsg;
	extern int BarfPid;

	if (Mid == 0  &&  (Mid = GetMid()) == 0)
		return u.u_error = ESRCH;
	rp->Un.Req.requestcode = GET_MID;
	strncpy(rp->Un.Req.name, name, sizeof(rp->Un.Req.name) - 1);
	rp->Un.Req.name[sizeof(rp->Un.Req.name) - 1] = '\0';
	strncpy(rp->Un.Req.myname, hostname, sizeof(rp->Un.Req.myname) - 1);
	rp->Un.Req.myname[sizeof(rp->Un.Req.myname) - 1] = '\0';
	rp->Un.Req.myrpid = Mid + BarfPid;
	if (Send((struct Request *)0, 0xFFFFFFFF))
		if ((u.u_error = rp->Un.Rep.replycode) == 0)
			if (rpidp)
				*rpidp = rp->Un.Rep.rpid;
	return u.u_error;
}

REMAmAlive()
  {
	register struct AmAlive *rp = (struct AmAlive *)u.u_Rmsg;
	extern int BarfPid;

	if (Mid == 0  &&  (Mid = GetMid()) == 0)
		return u.u_error = ESRCH;
	rp->Un.Req.requestcode = AM_ALIVE;
	strncpy(rp->Un.Req.machname, hostname, sizeof(rp->Un.Req.machname) - 1);
	rp->Un.Req.machname[sizeof(rp->Un.Req.machname) - 1] = '\0';
	rp->Un.Req.rpid = Mid + BarfPid;
	Send((struct Request *)0, 0xFFFF0000);
	return u.u_error;
}

REMCreateCousin(mid, rpidp)
  unsigned mid;
  unsigned long *rpidp;
  {
	register struct CreateCousin *rp = (struct CreateCousin *)u.u_Rmsg;
	register int *sgp = u.u_groups;
	register short *dgp = rp->Un.Req.groups;
	register short i = NGROUPS;

	rp->Un.Req.requestcode = CREATE_COUSIN;
	while (--i >= 0)
		*dgp++ = *sgp++;
	rp->Un.Req.uid = u.u_uid;
	rp->Un.Req.gid = u.u_gid;
	if (Send((struct Request *)0, RPID(mid, 0xFFFF)))
		if ((u.u_error = rp->Un.Rep.replycode) == 0)
			if (rpidp)
				*rpidp = rp->Un.Rep.rpid;
	return u.u_error;
}

REMfork(rpid, rpidp)
  unsigned long rpid;
  unsigned long *rpidp;
  {
	register struct UnixFork *rp = (struct UnixFork *)u.u_Rmsg;

	rp->Un.Req.requestcode = UNIX_FORK;
	rp->Un.Req.cdirmid = u.u_Rrcdirmid;
	rp->Un.Req.rdirmid = u.u_Rrrdirmid;
	if (Send((struct Request *)0, rpid))
		if ((u.u_error = rp->Un.Rep.replycode) == 0)
			if (rpidp)
				*rpidp = rp->Un.Rep.rpid;
	return u.u_error;
}

REMexit(rpid)
  unsigned long rpid;
  {
	struct UnixExit *rp = (struct UnixExit *)u.u_Rmsg;

	rp->Un.Req.requestcode = UNIX_EXIT;
	if (Send((struct Request *)0, rpid))
		u.u_error = rp->Un.Rep.replycode;
	return u.u_error;
}

REMchdirec(rpid, pathname, ischroot)
  unsigned long rpid;
  char *pathname;
  short ischroot;
  {
	register struct UnixChdirec *rp = (struct UnixChdirec *)u.u_Rmsg;

	rp->Un.Req.requestcode = ischroot ? UNIX_CHROOT : UNIX_CHDIR;
	if (pathname == (char *)-1) {
		rp->Un.Req.pathname = (char *)0;
		rp->Un.Req.pathlen = 0;
	} else if (pathname == (char *)0) {
		rp->Un.Req.pathname = "";
		rp->Un.Req.pathlen = 1;
	} else {
		rp->Un.Req.pathname = pathname;
		rp->Un.Req.pathlen = strlen(pathname) + 1;
	}
	rp->Un.Req.pid = u.u_procp->p_pid;
	rp->Un.Req.uid = u.u_uid;
	rp->Un.Req.gid = u.u_gid;
	if (Send((struct Request *)0, rpid))
		u.u_error = rp->Un.Rep.replycode;
	return u.u_error;
}

REMcopen(rpid, pathname, mode, arg, rfdesp, ftypep)
  unsigned long rpid;
  char *pathname;
  int mode, arg;
  int *rfdesp, *ftypep;
  {
	register struct UnixCopen *rp = (struct UnixCopen *)u.u_Rmsg;

	rp->Un.Req.requestcode = UNIX_COPEN;
	rp->Un.Req.pathname = pathname;
	if ((rp->Un.Req.pathlen = strlen(pathname) + 1) < sizeof(struct inode))
		rp->Un.Req.pathlen = sizeof(struct inode);
	rp->Un.Req.accessmode = mode;
	rp->Un.Req.createmode = arg;
	rp->Un.Req.pid = u.u_procp->p_pid;
	rp->Un.Req.uid = u.u_uid;
	rp->Un.Req.gid = u.u_gid;
	if (Send((struct Request *)0, rpid))
		if ((u.u_error = rp->Un.Rep.replycode) == 0) {
			if (rfdesp)
				*rfdesp = rp->Un.Rep.rfdes;
			if (ftypep)
				*ftypep = rp->Un.Rep.mode;
		}
	return u.u_error;
}

REMclose(rpid, rfdes)
  unsigned long rpid;
  int rfdes;
  {
	register struct UnixClose *rp = (struct UnixClose *)u.u_Rmsg;

	rp->Un.Req.requestcode = UNIX_CLOSE;
	rp->Un.Req.rfdes = rfdes;
	if (Send((struct Request *)0, rpid))
		u.u_error = rp->Un.Rep.replycode;
	return u.u_error;
}

REMrw(rwa, rpid, rfdes, base, offset, length, residp)
  int rwa;	/* 0: read;  1: write;  2: append */
  unsigned long rpid;
  char *base;
  int *residp;
  {
	register struct UnixReadWrite *rp = (struct UnixReadWrite *)u.u_Rmsg;
	static short unix_code[3] = { UNIX_READ, UNIX_WRITE, UNIX_APPEND };

	rp->Un.Req.requestcode = unix_code[rwa];
	rp->Un.Req.rfdes = rfdes;
	rp->Un.Req.base = base;
	rp->Un.Req.offset = offset;
	rp->Un.Req.length = length;
	if (Send((struct Request *)0, rpid))
		if ((u.u_error = rp->Un.Rep.replycode) == 0)
			if (residp)
				*residp = rp->Un.Rep.resid;
	return u.u_error;
}

REMioctl(rpid, rfdes, com, data)
  char *data;
  {
	register struct UnixIoctl *rp = (struct UnixIoctl *)u.u_Rmsg;

	rp->Un.Req.requestcode = UNIX_IOCTL;
	rp->Un.Req.rfdes = rfdes;
	rp->Un.Req.com = com;
	rp->Un.Req.data = data;
	rp->Un.Req.datalen = IOCPARM_MASK;	/* maximum */
	if (Send((struct Request *)0, rpid))
		u.u_error = rp->Un.Rep.replycode;
	return u.u_error;
}

REMselect(rpid, rfdes, which)
  {
	register struct UnixSelect *rp = (struct UnixSelect *)u.u_Rmsg;

	rp->Un.Req.requestcode = UNIX_SELECT;
	rp->Un.Req.rfdes = rfdes;
	rp->Un.Req.which = which;
	if (Send((struct Request *)0, rpid))
		u.u_error = rp->Un.Rep.replycode;
	return u.u_error;
}

REMstat(rpid, pathname, follow)
  unsigned long rpid;
  char *pathname;	/* pathname, to be overwritten by stat structure */
  {
	register struct UnixStat *rp = (struct UnixStat *)u.u_Rmsg;
	register len = strlen(pathname) + 1;

	if (len < sizeof(struct stat))
		len = sizeof(struct stat);
	rp->Un.Req.requestcode = UNIX_STAT;
	rp->Un.Req.pathname = pathname;
	rp->Un.Req.pathlen = len;
	rp->Un.Req.follow = follow;
	rp->Un.Req.pid = u.u_procp->p_pid;
	rp->Un.Req.uid = u.u_uid;
	rp->Un.Req.gid = u.u_gid;
	if (Send((struct Request *)0, rpid))
		u.u_error = rp->Un.Rep.replycode;
	return u.u_error;
}

REMfstat(rpid, rfdes, sb, blen, seg)
  unsigned long rpid;
  int rfdes;
  char *sb;		/* user virtual address of stat buffer */
  int blen;
  short seg;
  {
	register struct UnixFstat *rp = (struct UnixFstat *)u.u_Rmsg;

	rp->Un.Req.requestcode = seg == 1 ? UNIX_KFSTAT : UNIX_FSTAT;
	rp->Un.Req.rfdes = rfdes;
	rp->Un.Req.sb = sb;
	rp->Un.Req.buflen = blen;
	if (Send((struct Request *)0, rpid))
		u.u_error = rp->Un.Rep.replycode;
	return u.u_error;
}

REMaccess(rpid, pathname, fmode)
  unsigned long rpid;
  char *pathname;
  int fmode;
  {
	register struct UnixAccess *rp = (struct UnixAccess *)u.u_Rmsg;

	rp->Un.Req.requestcode = UNIX_ACCESS;
	rp->Un.Req.pathname = pathname;
	rp->Un.Req.pathlen = strlen(pathname) + 1;
	rp->Un.Req.fmode = fmode;
	rp->Un.Req.pid = u.u_procp->p_pid;
	rp->Un.Req.uid = u.u_ruid;		/* real uid */
	rp->Un.Req.gid = u.u_rgid;		/* real gid */
	if (Send((struct Request *)0, rpid))
		u.u_error = rp->Un.Rep.replycode;
	return u.u_error;
}

REMunlink(rpid, pathname)
  unsigned long rpid;
  char *pathname;
  {
	register struct UnixUnlink *rp = (struct UnixUnlink *)u.u_Rmsg;

	rp->Un.Req.requestcode = UNIX_UNLINK;
	rp->Un.Req.pathname = pathname;
	rp->Un.Req.pathlen = strlen(pathname) + 1;
	rp->Un.Req.pid = u.u_procp->p_pid;
	rp->Un.Req.uid = u.u_uid;
	rp->Un.Req.gid = u.u_gid;
	if (Send((struct Request *)0, rpid))
		u.u_error = rp->Un.Rep.replycode;
	return u.u_error;
}

REMlink(rpid, path1, path2)
  unsigned long rpid;
  char *path1, *path2;
  {
	register struct UnixLink *rp = (struct UnixLink *)u.u_Rmsg;

	rp->Un.Req.requestcode = UNIX_LINK;
	rp->Un.Req.path1 = path1;
	rp->Un.Req.path2 = path2;
	if (path1 <= path2) {
		rp->Un.Req.pathbuf = path1;
		rp->Un.Req.pathbuflen = (path2 - path1) + strlen(path2) + 1;
	} else {
		rp->Un.Req.pathbuf = path2;
		rp->Un.Req.pathbuflen = (path1 - path2) + strlen(path1) + 1;
	}
	rp->Un.Req.pid = u.u_procp->p_pid;
	rp->Un.Req.uid = u.u_uid;
	rp->Un.Req.gid = u.u_gid;
	if (Send((struct Request *)0, rpid))
		u.u_error = rp->Un.Rep.replycode;
	return u.u_error;
}

REMsymlink(rpid, path1, path2)
  unsigned long rpid;
  char *path1, *path2;
  {
	register struct UnixSymlink *rp = (struct UnixSymlink *)u.u_Rmsg;

	rp->Un.Req.requestcode = UNIX_SYMLINK;
	rp->Un.Req.path1 = path1;
	rp->Un.Req.path2 = path2;
	if (path1 <= path2) {
		rp->Un.Req.pathbuf = path1;
		rp->Un.Req.pathbuflen = (path2 - path1) + strlen(path2) + 1;
	} else {
		rp->Un.Req.pathbuf = path2;
		rp->Un.Req.pathbuflen = (path1 - path2) + strlen(path1) + 1;
	}
	rp->Un.Req.pid = u.u_procp->p_pid;
	rp->Un.Req.uid = u.u_uid;
	rp->Un.Req.gid = u.u_gid;
	if (Send((struct Request *)0, rpid))
		u.u_error = rp->Un.Rep.replycode;
	return u.u_error;
}

REMreadlink(rpid, p, lenp)
  unsigned long rpid;
  char *p;
  int *lenp;
  {
	register struct UnixReadlink *rp = (struct UnixReadlink *)u.u_Rmsg;

	rp->Un.Req.requestcode = UNIX_READLINK;
	rp->Un.Req.buf = p;
	rp->Un.Req.buflen = *lenp;
	rp->Un.Req.pid = u.u_procp->p_pid;
	rp->Un.Req.uid = u.u_uid;
	rp->Un.Req.gid = u.u_gid;
	if (Send((struct Request *)0, rpid))
		if ((u.u_error = rp->Un.Rep.replycode) == 0)
			*lenp = rp->Un.Rep.linklen;
	return u.u_error;
}

REMmknod(rpid, pathname, fmode, dev)
  unsigned long rpid;
  char *pathname;
  int fmode, dev;
  {
	register struct UnixMknod *rp = (struct UnixMknod *)u.u_Rmsg;

	rp->Un.Req.requestcode = UNIX_MKNOD;
	rp->Un.Req.pathname = pathname;
	rp->Un.Req.pathlen = strlen(pathname) + 1;
	rp->Un.Req.fmode = fmode;
	rp->Un.Req.dev = dev;
	rp->Un.Req.pid = u.u_procp->p_pid;
	rp->Un.Req.uid = u.u_uid;
	rp->Un.Req.gid = u.u_gid;
	if (Send((struct Request *)0, rpid))
		u.u_error = rp->Un.Rep.replycode;
	return u.u_error;
}

REMmkdir(rpid, pathname, dmode)
  unsigned long rpid;
  char *pathname;
  int dmode;
  {
	register struct UnixMkdir *rp = (struct UnixMkdir *)u.u_Rmsg;

	rp->Un.Req.requestcode = UNIX_MKDIR;
	rp->Un.Req.pathname = pathname;
	rp->Un.Req.pathlen = strlen(pathname) + 1;
	rp->Un.Req.dmode = dmode;
	rp->Un.Req.pid = u.u_procp->p_pid;
	rp->Un.Req.uid = u.u_uid;
	rp->Un.Req.gid = u.u_gid;
	if (Send((struct Request *)0, rpid))
		u.u_error = rp->Un.Rep.replycode;
	return u.u_error;
}

REMrmdir(rpid, pathname)
  unsigned long rpid;
  char *pathname;
  {
	register struct UnixRmdir *rp = (struct UnixRmdir *)u.u_Rmsg;

	rp->Un.Req.requestcode = UNIX_RMDIR;
	rp->Un.Req.pathname = pathname;
	rp->Un.Req.pathlen = strlen(pathname) + 1;
	rp->Un.Req.pid = u.u_procp->p_pid;
	rp->Un.Req.uid = u.u_uid;
	rp->Un.Req.gid = u.u_gid;
	if (Send((struct Request *)0, rpid))
		u.u_error = rp->Un.Rep.replycode;
	return u.u_error;
}

REMchmod(rpid, pathname, fmode)
  unsigned long rpid;
  char *pathname;
  int fmode;
  {
	register struct UnixChmod *rp = (struct UnixChmod *)u.u_Rmsg;

	rp->Un.Req.requestcode = UNIX_CHMOD;
	rp->Un.Req.pathname = pathname;
	rp->Un.Req.pathlen = strlen(pathname) + 1;
	rp->Un.Req.fmode = fmode;
	rp->Un.Req.pid = u.u_procp->p_pid;
	rp->Un.Req.uid = u.u_uid;
	rp->Un.Req.gid = u.u_gid;
	if (Send((struct Request *)0, rpid))
		u.u_error = rp->Un.Rep.replycode;
	return u.u_error;
}

REMfchmod(rpid, rfdes, fmode)
  unsigned long rpid;
  int rfdes;
  int fmode;
  {
	register struct UnixFchmod *rp = (struct UnixFchmod *)u.u_Rmsg;

	rp->Un.Req.requestcode = UNIX_FCHMOD;
	rp->Un.Req.rfdes = rfdes;
	rp->Un.Req.fmode = fmode;
	if (Send((struct Request *)0, rpid))
		u.u_error = rp->Un.Rep.replycode;
	return u.u_error;
}

REMchown(rpid, pathname, uid, gid)
  unsigned long rpid;
  char *pathname;
  int uid, gid;
  {
	register struct UnixChown *rp = (struct UnixChown *)u.u_Rmsg;

	rp->Un.Req.requestcode = UNIX_CHOWN;
	rp->Un.Req.pathname = pathname;
	rp->Un.Req.pathlen = strlen(pathname) + 1;
	rp->Un.Req.newuid = uid;
	rp->Un.Req.newgid = gid;
	rp->Un.Req.pid = u.u_procp->p_pid;
	rp->Un.Req.uid = u.u_uid;
	rp->Un.Req.gid = u.u_gid;
	if (Send((struct Request *)0, rpid))
		u.u_error = rp->Un.Rep.replycode;
	return u.u_error;
}

REMfchown(rpid, rfdes, uid, gid)
  unsigned long rpid;
  int rfdes;
  int uid, gid;
  {
	register struct UnixFchown *rp = (struct UnixFchown *)u.u_Rmsg;

	rp->Un.Req.requestcode = UNIX_FCHOWN;
	rp->Un.Req.rfdes = rfdes;
	rp->Un.Req.newuid = uid;
	rp->Un.Req.newgid = gid;
	if (Send((struct Request *)0, rpid))
		u.u_error = rp->Un.Rep.replycode;
	return u.u_error;
}

REMtruncate(rpid, pathname, length)
  unsigned long rpid;
  char *pathname;
  unsigned long length;
  {
	register struct UnixTruncate *rp = (struct UnixTruncate *)u.u_Rmsg;

	rp->Un.Req.requestcode = UNIX_TRUNCATE;
	rp->Un.Req.pathname = pathname;
	rp->Un.Req.pathlen = strlen(pathname) + 1;
	rp->Un.Req.length = length;
	rp->Un.Req.pid = u.u_procp->p_pid;
	rp->Un.Req.uid = u.u_uid;
	rp->Un.Req.gid = u.u_gid;
	if (Send((struct Request *)0, rpid))
		u.u_error = rp->Un.Rep.replycode;
	return u.u_error;
}

REMftruncate(rpid, rfdes, length)
  unsigned long rpid;
  int rfdes;
  unsigned long length;
  {
	register struct UnixFtruncate *rp = (struct UnixFtruncate *)u.u_Rmsg;

	rp->Un.Req.requestcode = UNIX_FTRUNCATE;
	rp->Un.Req.rfdes = rfdes;
	rp->Un.Req.length = length;
	if (Send((struct Request *)0, rpid))
		u.u_error = rp->Un.Rep.replycode;
	return u.u_error;
}

REMutimes(rpid, pathname, asec, msec)
  unsigned long rpid;
  char *pathname;
  long asec, msec;
  {
	register struct UnixUtimes *rp = (struct UnixUtimes *)u.u_Rmsg;

	rp->Un.Req.requestcode = UNIX_UTIMES;
	rp->Un.Req.pathname = pathname;
	rp->Un.Req.pathlen = strlen(pathname) + 1;
	rp->Un.Req.asec = asec;
	rp->Un.Req.msec = msec;
	rp->Un.Req.pid = u.u_procp->p_pid;
	rp->Un.Req.uid = u.u_uid;
	rp->Un.Req.gid = u.u_gid;
	if (Send((struct Request *)0, rpid))
		u.u_error = rp->Un.Rep.replycode;
	return u.u_error;
}

REMfsync(rpid, rfdes)
  unsigned long rpid;
  int rfdes;
  {
	register struct UnixFsync *rp = (struct UnixFsync *)u.u_Rmsg;

	rp->Un.Req.requestcode = UNIX_FSYNC;
	rp->Un.Req.rfdes = rfdes;
	if (Send((struct Request *)0, rpid))
		u.u_error = rp->Un.Rep.replycode;
	return u.u_error;
}

REMflock(rpid, rfdes, how)
  unsigned long rpid;
  int rfdes;
  int how;
  {
	register struct UnixFlock *rp = (struct UnixFlock *)u.u_Rmsg;

	rp->Un.Req.requestcode = UNIX_FLOCK;
	rp->Un.Req.rfdes = rfdes;
	rp->Un.Req.how = how;
	if (Send((struct Request *)0, rpid))
		u.u_error = rp->Un.Rep.replycode;
	return u.u_error;
}

#ifdef	LOCKF
REMlockf(rpid, rfdes, flag, size)
  unsigned long rpid;
  int rfdes;
  int flag;
  off_t size;
  {
	register struct UnixLockf *rp = (struct UnixLockf *)u.u_Rmsg;

	rp->Un.Req.requestcode = UNIX_LOCKF;
	rp->Un.Req.rfdes = rfdes;
	rp->Un.Req.flag = flag;
	rp->Un.Req.size = (long)size;
	if (Send((struct Request *)0, rpid))
		u.u_error = rp->Un.Rep.replycode;
	return u.u_error;
}
#endif	LOCKF

REMrename(rpid, path1, path2)
  unsigned long rpid;
  char *path1, *path2;
  {
	register struct UnixRename *rp = (struct UnixRename *)u.u_Rmsg;

	rp->Un.Req.requestcode = UNIX_RENAME;
	rp->Un.Req.path1 = path1;
	rp->Un.Req.path2 = path2;
	if (path1 <= path2) {
		rp->Un.Req.pathbuf = path1;
		rp->Un.Req.pathbuflen = (path2 - path1) + strlen(path2) + 1;
	} else {
		rp->Un.Req.pathbuf = path2;
		rp->Un.Req.pathbuflen = (path1 - path2) + strlen(path1) + 1;
	}
	rp->Un.Req.pid = u.u_procp->p_pid;
	rp->Un.Req.uid = u.u_uid;
	rp->Un.Req.gid = u.u_gid;
	if (Send((struct Request *)0, rpid))
		u.u_error = rp->Un.Rep.replycode;
	return u.u_error;
}

REMchexec(rpid, pathname, uidp, gidp, newimagep)
  unsigned long rpid;
  char *pathname;
  int *uidp, *gidp, *newimagep;
  {
	register struct UnixChExec *rp = (struct UnixChExec *)u.u_Rmsg;
	register int len = strlen(pathname) + 1;

	if (len < sizeof(u.u_exdata) + MAXCOMLEN + 1)
		len = sizeof(u.u_exdata) + MAXCOMLEN + 1;
	rp->Un.Req.requestcode = UNIX_CHEXEC;
	rp->Un.Req.pathname = pathname;
	rp->Un.Req.pathlen = len;
	rp->Un.Req.pid = u.u_procp->p_pid;
	rp->Un.Req.uid = u.u_uid;
	rp->Un.Req.gid = u.u_gid;
	if (Send((struct Request *)0, rpid))
		if ((u.u_error = rp->Un.Rep.replycode) == 0) {
			if (uidp)
				*uidp = rp->Un.Rep.newuid;
			if (gidp)
				*gidp = rp->Un.Rep.newgid;
			if (newimagep)
				*newimagep = rp->Un.Rep.newimage;
		}
	return u.u_error;
}

#define	LOAD_SIZE	(24 * 1024)

REMload(rpid, base, length, offset)
  unsigned long rpid;
  char *base;
  int length;
  int offset;
  {
	register struct UnixLoad *rp = (struct UnixLoad *)u.u_Rmsg;
	register unsigned long n;

	do {
		int try = 2;

		if (u.u_error)
			break;
		n = length;
		if (n > LOAD_SIZE)
			n = LOAD_SIZE;
		for (;;) {
			rp->Un.Req.requestcode = UNIX_LOAD;
			rp->Un.Req.base = base;
			rp->Un.Req.offset = offset;
			rp->Un.Req.length = n;
			if (Send((struct Request *)0, rpid))
				if ((u.u_error = rp->Un.Rep.replycode) == 0)
					if (rp->Un.Rep.resid != 0)
						u.u_error = EIO;
			if (u.u_error == 0)
				break;
#ifdef	ROLANE
printf("REMload: load failure (%d %s)  repcode=%d resid=%d\n", u.u_procp->p_pid, u.u_comm, rp->Un.Rep.replycode, rp->Un.Rep.resid);
#endif	ROLANE
			if (--try <= 0)
				break;
#ifdef	ROLANE
printf("REMload: retrying\n");
#endif	ROLANE
		}
		base += n;
		offset += n;
		length -= n;
	} while (length);
	return u.u_error;
}

#undef	LOAD_SIZE

/*REMload(rpid, base, length, offset)
/*  unsigned long rpid;
/*  char *base;
/*  int length;
/*  int offset;
/*  {
/*	register struct UnixLoad *rp = (struct UnixLoad *)u.u_Rmsg;
/*
/*	rp->Un.Req.requestcode = UNIX_LOAD;
/*	rp->Un.Req.base = base;
/*	rp->Un.Req.offset = offset;
/*	rp->Un.Req.length = length;
/*	if (Send((struct Request *)0, rpid))
/*		if ((u.u_error = rp->Un.Rep.replycode) == 0)
/*			if (rp->Un.Rep.resid != 0)
/*				u.u_error = EIO;
/*	return u.u_error;
/*}
/* */

REMswapinit(rpid, mode, nblocks)
  unsigned long rpid;
  int mode;
  unsigned long nblocks;
  {
	register struct SwapInit *rp = (struct SwapInit *)u.u_Rmsg;

	rp->Un.Req.requestcode = SWAP_INIT;
	rp->Un.Req.mode = mode;
	rp->Un.Req.nblocks = nblocks;
	if (Send((struct Request *)0, rpid))
		u.u_error = rp->Un.Rep.replycode;
	return u.u_error;
}

REMswap(rpid, rw, devx, blkno, bcount, addr)
  unsigned long rpid;
  int rw, devx;
  unsigned long blkno;
  int bcount;
  caddr_t addr;
  {
	register struct Swap *rp = (struct Swap *)u.u_Rmsg;

	rp->Un.Req.requestcode = rw ? SWAP_IN : SWAP_OUT;
	rp->Un.Req.devx = devx;
	rp->Un.Req.blkno = blkno;
	rp->Un.Req.addr = addr;
	rp->Un.Req.bcount = bcount;
	if (Send((struct Request *)0, rpid))
		u.u_error = rp->Un.Rep.replycode;
	return u.u_error;
}

REMGetInode(rpid, rfdes, ip, ilen)
  unsigned long rpid;
  int rfdes;
  char *ip;
  int ilen;
  {
	register struct GetInode *rp = (struct GetInode *)u.u_Rmsg;

	rp->Un.Req.requestcode = GET_INODE;
	rp->Un.Req.rfdes = rfdes;
	rp->Un.Req.base = ip;
	rp->Un.Req.length = ilen;
	if (Send((struct Request *)0, rpid))
		u.u_error = rp->Un.Rep.replycode;
	return u.u_error;
}

#define	COPY_SIZE	(8 * 1024)

Wcopyin(src, dest, count)
  char *src, *dest;
  int count;
  {
	int result = 0;

	while (count) {
		register int n = count;

		if (n > COPY_SIZE)
			n = COPY_SIZE;
		if (result = CopyFrom(u.u_Rclient, dest, src, n, 1))
			break;
		src += n;
		dest += n;
		count -= n;
	}
	return result;
}

Wcopyout(src, dest, count)
  char *src, *dest;
  int count;
  {
	int result = 0;

	while (count) {
		register int n = count;

		if (n > COPY_SIZE)
			n = COPY_SIZE;
		if (result = CopyTo(u.u_Rclient, dest, src, n, 1))
			break;
		src += n;
		dest += n;
		count -= n;
	}
	return result;
}

#undef	COPY_SIZE

Wfubyte(addr)
  char *addr;
  {
	unsigned char c;

	if (CopyFrom(u.u_Rclient, &c, addr, 1, 1))
		return -1;
	return c;
}

Wfuword(addr)
  char *addr;
  {
	long w;

	if (CopyFrom(u.u_Rclient, &w, addr, 4, 1))
		return -1;
	return w;
}

Wsubyte(addr, c)
  char *addr;
  char c;
  {
	if (CopyTo(u.u_Rclient, addr, &c, 1, 1))
		return -1;
	return 0;
}

Wsuword(addr, w)
  char *addr;
  long w;
  {
	if (CopyTo(u.u_Rclient, addr, &w, 4, 1))
		return -1;
	return 0;
}

Wuseracc(addr, count, mode)
  char *addr;
  int count, mode;
  {
	return 1;
}
