#include "../h/param.h"
#include "../h/systm.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/kernel.h"
#include "../h/file.h"
#include "../h/stat.h"
#include "../h/inode.h"
#include "../h/fs.h"
#include "../h/buf.h"
#include "../h/proc.h"
#include "../h/quota.h"
#include "../h/uio.h"
#include "../h/nami.h"

#include "../h/Remote.h"
#include "../machine/board.h"

int BarfPid = 0;
unsigned long Mid;	/* machine id for this machine */
unsigned long GetMid();
char *dtoa();

struct fname {
	char	*fname;
};

struct fd {
	int	fd;
};

CousinTimeout(p)
  struct proc *p;
  {
	psignal(p, SIGALRM);
}

BarfTimeout(p)
  struct proc *p;
  {

	if (BarfPid)
		psignal(p, SIGALRM);
	timeout(BarfTimeout, p, 61*hz);
}

BarfAlarm()
  {
	if (Mid  ||  (Mid = GetMid()))
		REMAmAlive();
	CheckOtherMachs();
}

/*
 * Called from kernel initialization code.
 *  Starts up a new system process (pid #3) which loops forever,
 *  creating cousins as needed.
 */
BarfServer()
  {
	register unsigned long rpid;
	register struct Request *rp = (struct Request *)u.u_Rmsg;
	register struct proc *p;

	if (newproc(0) == 0)	/* Create a new process.  Parent returns. */
		return;
	p = u.u_procp;
	p->p_flag |= SLOAD|SSYS;
#ifdef	M68020
	setctx(p->p_context = CTX_SYS);
#endif	M68020
	strcpy(u.u_comm, "trfs server");
	u.u_signal[SIGALRM] = SIG_CATCH;
	BarfPid = 0;
	BarfTimeout(u.u_procp);
	BarfPid = p->p_pid;
	BarfAlarm();
	while (1) {
		if (setjmp(&u.u_qsave)) {
			p = u.u_procp;
			if (p->p_cursig || ISSIG(p)) {
				switch (p->p_cursig) {
				  case SIGALRM:
					BarfAlarm();
					break;
				  default:
					printf("Barf Server: got a %d signal\n",
								p->p_cursig);
					break;
				}
			}
			p->p_cursig = 0;
			p->p_pri = p->p_usrpri;
			continue;
		}
		u.u_error = 0;
		if ((rpid = Receive((struct Request *)0)) == 0)
			continue;
		if (Mid == 0  &&  (Mid = GetMid()) == 0)
			continue;
		switch(rp->Un.Req.requestcode) {
		  case CREATE_COUSIN:
			CrCousin(rpid, rp);
			break;
		  case GET_MID:
			if (GMid(rp) == 0) {
				FlushReply(rpid);
				continue;
			}
			break;
		  case AM_ALIVE:
			AmAlive(rpid, rp);
			FlushReply(rpid);
			continue;
		  case SWAP_INIT:
			SwpInit(rpid, rp);
			break;
		  case SWAP_IN:
		  case SWAP_OUT:
			Swp(rpid, rp);
			break;
		  default:
			FlushReply(rpid);
			continue;
		}
		Reply((struct Request *)0, rpid);
	}
}

struct inode *SwpIp;

SwpInit(rpid, rp)
  unsigned long rpid;
  struct SwapInit *rp;
  {
	u.u_Rclient = rpid;
	rp->Un.Rep.replycode = SetupSwap(rpid);
}

Swp(rpid, rp)
  unsigned long rpid;
  struct Swap *rp;
  {
	int err, resid;
	struct inode *ip, *GetSwapInode();

	u.u_Rclient = rpid;
	if ((ip = GetSwapInode(rpid)) == NULL) {
		rp->Un.Rep.replycode = EIO;
		return;
	}
	err = rdwri((rp->Un.Req.requestcode == SWAP_IN ? UIO_READ : UIO_WRITE),
			ip, rp->Un.Req.addr, rp->Un.Req.bcount,
			dbtob(rp->Un.Req.blkno), 0, &resid);
	if (err)
		rp->Un.Rep.replycode = err;
	else if (resid)
		rp->Un.Rep.replycode = EIO;
	else
		rp->Un.Rep.replycode = 0;
}

GMid(rp)
  register struct GetMid *rp;
  {
	rp->Un.Rep.replycode = 0;
	if (UpdateMachInfo(rp->Un.Req.myname, rp->Un.Req.myrpid) < 0)
		return rp->Un.Rep.rpid = 0;
	return rp->Un.Rep.rpid = IsMyName(rp->Un.Req.name);
}

AmAlive(rpid, rp)
  register struct AmAlive *rp;
  {
	UpdateMachInfo(rp->Un.Req.machname, rp->Un.Req.rpid);
}

/*
 * Create a new cousin process.
 *  Initialize by setting up group list, uid & gid.
 *  Call Cousin() to service requests from client.
 *  Upon return, terminate.
 */
CrCousin(rpid, rp)
  unsigned long rpid;
  register struct CreateCousin *rp;
  {
	fork1(0);
	if (u.u_r.r_val2) {	/* child */
		register short *sgp = rp->Un.Req.groups;
		register int *dgp = u.u_groups;
		register short i = NGROUPS;
		char *RpidToMname();

		RunAway();
		u.u_Rclient = rpid;
		SetMachPgrp(rpid);
		strcpy(u.u_comm, "cousin ");
		strcat(u.u_comm, RpidToMname(rpid));
		strcat(u.u_comm, " ");
		strcat(u.u_comm, dtoa(rpid & 0xFFFF));
		while (--i >= 0)
			*dgp++ = *sgp++;
		u.u_procp->p_uid = u.u_ruid = u.u_uid = rp->Un.Req.uid;
		u.u_rgid = u.u_gid = rp->Un.Req.gid;
		if (u.u_rdir) {
			irele(u.u_rdir);
			u.u_rdir = NULL;
		}
		if (u.u_cdir) {
			irele(u.u_cdir);
			u.u_cdir = NULL;
		}
		Cousin();
		exit(0);	/* no return */
	}
	if ((rp->Un.Rep.replycode = u.u_error) == 0)
		rp->Un.Rep.rpid = Mid + u.u_r.r_val1;
}

/*
 * Cousin server.
 *  Loop, receiving and servicing requests
 *  from the particular client with which we are associated.
 *  Return when we receive an exit request.
 */
Cousin()
  {
	register unsigned long rpid;
	register struct Request *rp = (struct Request *)u.u_Rmsg;
	register short alive = 1;

	u.u_ap = u.u_arg;
	while (alive) {
		if (setjmp(&u.u_qsave)) {
			register struct proc *p = u.u_procp;

			if (p->p_cursig || ISSIG(p)) {
				switch (p->p_cursig) {
				  case SIGALRM:
				  case SIGTERM:
					if (u.u_cdir  ||  u.u_rdir  ||
					    u.u_Rexec  ||  are_any_files_open())
						break;
					/* fall thru */
				  case SIGKILL:
					Rexit(p->p_cursig);
					/* no return */
				}
			}
			p->p_cursig = 0;
			p->p_pri = p->p_usrpri;
			continue;
		}
		u.u_error = 0;
		if (u.u_cdir == NULL  &&  u.u_rdir == NULL  &&
		    u.u_Rexec == NULL  &&  !are_any_files_open()) {
			timeout(CousinTimeout, u.u_procp, 15*hz);
			rpid = Receive((struct Request *)0);
			untimeout(CousinTimeout, u.u_procp);
		} else
			rpid = Receive((struct Request *)0);
		if (rpid == 0)
			continue;
		if (u.u_Rclient != rpid) {
			/* check for imposter? */
			u.u_Rclient = rpid;
			zappid(u.u_comm);
			strcat(u.u_comm, dtoa(rpid & 0xFFFF));
		}
		if (u.u_Rexec  &&  rp->Un.Req.requestcode != UNIX_LOAD  &&
		    rp->Un.Req.requestcode != CREATE_COUSIN  &&
		    rp->Un.Req.requestcode != GET_MID  &&
		    rp->Un.Req.requestcode != SWAP_IN) {
			irele(u.u_Rexec);
			u.u_Rexec = NULL;
		}
		switch(rp->Un.Req.requestcode) {
		  case UNIX_EXIT:
			alive = 0;
			rp->Un.Rep.replycode = 0;
			break;
		  case UNIX_FORK:
			if (LOCfork(rp))
				continue;	/* child */
			break;
		  case UNIX_COPEN:
			LOCcopen(rp);
			break;
		  case UNIX_CLOSE:
			LOCclose(rp);
			break;
		  case UNIX_READ:
		  case UNIX_WRITE:
		  case UNIX_APPEND:
			LOCrw(rp);
			break;
		  case UNIX_IOCTL:
			LOCioctl(rp);
			break;
		  case UNIX_SELECT:
			LOCselect(rp);
			break;
		  case UNIX_STAT:
			if (LOCstat(rpid, rp))
				continue;
			break;
		  case UNIX_FSTAT:
		  case UNIX_KFSTAT:
			if (LOCfstat(rpid, rp))
				continue;
			break;
		  case UNIX_ACCESS:
			LOCaccess(rp);
			break;
		  case UNIX_CHDIR:
		  case UNIX_CHROOT:
			LOCchdirec(rp);
			break;
		  case UNIX_UNLINK:
			LOCunlink(rp);
			break;
		  case UNIX_LINK:
			LOClink(rp);
			break;
		  case UNIX_SYMLINK:
			LOCsymlink(rp);
			break;
		  case UNIX_READLINK:
			LOCreadlink(rp);
			break;
		  case UNIX_MKNOD:
			LOCmknod(rp);
			break;
		  case UNIX_MKDIR:
			LOCmkdir(rp);
			break;
		  case UNIX_RMDIR:
			LOCrmdir(rp);
			break;
		  case UNIX_CHMOD:
			LOCchmod(rp);
			break;
		  case UNIX_FCHMOD:
			LOCfchmod(rp);
			break;
		  case UNIX_CHOWN:
			LOCchown(rp);
			break;
		  case UNIX_FCHOWN:
			LOCfchown(rp);
			break;
		  case UNIX_TRUNCATE:
			LOCtruncate(rp);
			break;
		  case UNIX_FTRUNCATE:
			LOCftruncate(rp);
			break;
		  case UNIX_UTIMES:
			LOCutimes(rp);
			break;
		  case UNIX_FSYNC:
			LOCfsync(rp);
			break;
		  case UNIX_RENAME:
			LOCrename(rp);
			break;
		  case UNIX_CHEXEC:
			LOCchexec(rp);
			break;
		  case UNIX_LOAD:
			LOCload(rp);
			break;
		  case GET_INODE:
			LOCGetInode(rp);
			break;
		  case UNIX_FLOCK:
			LOCflock(rp);
			break;
#ifdef	LOCKF
		  case UNIX_LOCKF:
			LOClockf(rp);
			break;
#endif	LOCKF
		  default:
printf("Cousin: unknown request code 0x%x\n", rp->Un.Req.requestcode);
			FlushReply(rpid);
			continue;
		}
		Reply((struct Request *)0, rpid);
	}
}

LOCfork(rp)
  register struct UnixFork *rp;
  {
	register struct file **fpp;
	register short i;
	register unsigned short mid = Mid >> 16;

	if (rp->Un.Req.cdirmid == mid  ||  rp->Un.Req.rdirmid == mid)
		goto doit;
	fpp = u.u_ofile;
	i = NOFILE;
	while (--i >= 0) {
		if (*fpp++) {
  doit:
			fork1(0);
			if (u.u_r.r_val2) {
				RunAway();
				zappid(u.u_comm);
			} else if ((rp->Un.Rep.replycode = u.u_error) == 0)
				rp->Un.Rep.rpid = Mid + u.u_r.r_val1;
			return u.u_r.r_val2;
		}
	}
	/*
	 * Since this cousin does not have any files open, don't bother
	 *  to replicate another cousin.  We return successfully,
	 *  specifying zero for the new cousin rpid.
	 */
	rp->Un.Rep.replycode = 0;
	rp->Un.Rep.rpid = 0;
	return 0;
}

LOCchdirec(rp)
  register struct UnixChdirec *rp;
  {
	register struct inode **ipp;

	if (rp->Un.Req.requestcode == UNIX_CHROOT)
		ipp = &u.u_rdir;
	else
		ipp = &u.u_cdir;
	u.u_dirp = ((struct fname *)u.u_ap)->fname = rp->Un.Req.pathname;
	u.u_uid = rp->Un.Req.uid;
	u.u_gid = rp->Un.Req.gid;
	if (rp->Un.Req.pathlen == 0) {
		if (*ipp) {
			irele(*ipp);
			*ipp = NULL;
		}
	} else
		chdirec(ipp);
	rp->Un.Rep.replycode = u.u_error;
}

LOCcopen(rp)
  register struct UnixCopen *rp;
  {
	u.u_dirp = ((struct fname *)u.u_ap)->fname = rp->Un.Req.pathname;
	u.u_uid = rp->Un.Req.uid;
	u.u_gid = rp->Un.Req.gid;
	copen(rp->Un.Req.accessmode, rp->Un.Req.createmode);
	if ((rp->Un.Rep.replycode = u.u_error) == 0) {
		rp->Un.Rep.mode =
		    ((struct inode *)(u.u_ofile[rp->Un.Rep.rfdes =
		      u.u_r.r_val1]->f_data))->i_mode;
		rp->Un.Rep.rpid = Mid + u.u_procp->p_pid;
	}
}

LOCclose(rp)
  register struct UnixClose *rp;
  {
	((struct fd *)u.u_ap)->fd = rp->Un.Req.rfdes;
	close();
	rp->Un.Rep.replycode = u.u_error;
}

LOCrw(rp)
  register struct UnixReadWrite *rp;
  {
	register struct file *fp;
	struct uio auio;
	struct iovec aiov;

	if (fp = getf(((struct fd *)u.u_ap)->fd = rp->Un.Req.rfdes)) {
		fp->f_offset = rp->Un.Req.offset;
		auio.uio_iovcnt = 1;
		auio.uio_iov = &aiov;
		aiov.iov_base = (caddr_t)rp->Un.Req.base;
		aiov.iov_len = rp->Un.Req.length;
		rwuio(&auio, rp->Un.Req.requestcode == UNIX_READ ?
							UIO_READ : UIO_WRITE);
	}
	rp->Un.Rep.replycode = u.u_error;
	rp->Un.Rep.resid = auio.uio_resid;
}

LOCioctl(rp)
  register struct UnixIoctl *rp;
  {
	register struct a {
		int	fdes;
		int	cmd;
		char	*cmarg;
	} *uap = (struct a *)u.u_ap;

	uap->fdes = rp->Un.Req.rfdes;
	uap->cmd = rp->Un.Req.com;
	uap->cmarg = rp->Un.Req.data;
	ioctl();
	rp->Un.Rep.replycode = u.u_error;
}

LOCselect(rp)
  register struct UnixSelect *rp;
  {
	struct file *fp;

	if ((fp = getf(rp->Un.Req.rfdes)) != NULL)
		ino_select(fp, rp->Un.Req.which);
	rp->Un.Rep.replycode = u.u_error;
}

LOCstat(rpid, rp)
  unsigned long rpid;
  register struct UnixStat *rp;
  {
	register struct inode *ip;
	char dummypad[300];		/* this is absurd */
	struct stat sb;

	u.u_dirp = ((struct fname *)u.u_ap)->fname = rp->Un.Req.pathname;
	u.u_uid = rp->Un.Req.uid;
	u.u_gid = rp->Un.Req.gid;

	ip = namei(uchar, LOOKUP, rp->Un.Req.follow);
	rp->Un.Rep.replycode = u.u_error;
	if (ip != NULL) {
		(void) ino_stat(ip, &sb);
		iput(ip);
		ReplyWithSegment(NULL, rpid,
					&sb, rp->Un.Req.pathname, sizeof sb);
		return 1;
	}
	return 0;
}

LOCfstat(rpid, rp)
  unsigned long rpid;
  register struct UnixFstat *rp;
  {
	register struct file *fp;
	char dummypad[300];		/* this is absurd */
	struct stat sb;

	if (fp = getf(rp->Un.Req.rfdes)) {
		if (fp->f_type != DTYPE_INODE)
			panic("LOCfstat: bad ftype");
		(void)ino_stat((struct inode *)fp->f_data, &sb);
		rp->Un.Rep.replycode = 0;
		ReplyWithSegment(NULL, rpid, &sb, rp->Un.Req.sb, sizeof sb);
		return 1;
	}
	rp->Un.Rep.replycode = u.u_error;
	return 0;
}

LOCaccess(rp)
  register struct UnixAccess *rp;
  {
	register struct a {
		char	*fname;
		int	fmode;
	} *uap = (struct a *)u.u_ap;

	u.u_uid = rp->Un.Req.uid;
	u.u_gid = rp->Un.Req.gid;
	uap->fname = rp->Un.Req.pathname;
	u.u_dirp = (caddr_t)uap->fname;
	uap->fmode = rp->Un.Req.fmode;
	saccess();
	rp->Un.Rep.replycode = u.u_error;
}

LOCunlink(rp)
  register struct UnixUnlink *rp;
  {
	u.u_dirp = ((struct fname *)u.u_ap)->fname = rp->Un.Req.pathname;
	u.u_uid = rp->Un.Req.uid;
	u.u_gid = rp->Un.Req.gid;
	unlink();
	rp->Un.Rep.replycode = u.u_error;
}

LOClink(rp)
  register struct UnixLink *rp;
  {
	register struct a {
		char	*target;
		char	*linkname;
	} *uap = (struct a *)u.u_ap;

	u.u_uid = rp->Un.Req.uid;
	u.u_gid = rp->Un.Req.gid;
	uap->target = rp->Un.Req.path1;
	uap->linkname = rp->Un.Req.path2;
	u.u_dirp = (caddr_t)uap->target;
	Rlink();
	rp->Un.Rep.replycode = u.u_error;
}

LOCsymlink(rp)
  register struct UnixLink *rp;
  {
	register struct a {
		char	*target;
		char	*linkname;
	} *uap = (struct a *)u.u_ap;

	u.u_uid = rp->Un.Req.uid;
	u.u_gid = rp->Un.Req.gid;
	uap->linkname = rp->Un.Req.path1;
	uap->target = rp->Un.Req.path2;
	u.u_dirp = (caddr_t)uap->target;
	symlink();
	rp->Un.Rep.replycode = u.u_error;
}

LOCreadlink(rp)
  register struct UnixReadlink *rp;
  {
	register struct a {
		char	*name;
		char	*buf;
		int	count;
	} *uap = (struct a *)u.u_ap;

	u.u_uid = rp->Un.Req.uid;
	u.u_gid = rp->Un.Req.gid;
	uap->name = rp->Un.Req.buf;
	u.u_dirp = (caddr_t)uap->name;
	uap->buf = rp->Un.Req.buf;
	uap->count = rp->Un.Req.buflen;
	readlink();
	if ((rp->Un.Rep.replycode = u.u_error) == 0)
		rp->Un.Rep.linklen = u.u_r.r_val1;
}

LOCmknod(rp)
  register struct UnixMknod *rp;
  {
	register struct a {
		char	*fname;
		int	fmode;
		int	dev;
	} *uap = (struct a *)u.u_ap;

	u.u_uid = rp->Un.Req.uid;
	u.u_gid = rp->Un.Req.gid;
	uap->fname = rp->Un.Req.pathname;
	u.u_dirp = (caddr_t)uap->fname;
	uap->fmode = rp->Un.Req.fmode;
	uap->dev = rp->Un.Req.dev;
	mknod();
	rp->Un.Rep.replycode = u.u_error;
}

LOCmkdir(rp)
  register struct UnixMkdir *rp;
  {
	register struct a {
		char	*fname;
		int	dmode;
	} *uap = (struct a *)u.u_ap;

	u.u_uid = rp->Un.Req.uid;
	u.u_gid = rp->Un.Req.gid;
	uap->fname = rp->Un.Req.pathname;
	u.u_dirp = (caddr_t)uap->fname;
	uap->dmode = rp->Un.Req.dmode;
	mkdir();
	rp->Un.Rep.replycode = u.u_error;
}

LOCrmdir(rp)
  register struct UnixRmdir *rp;
  {
	u.u_dirp = ((struct fname *)u.u_ap)->fname = rp->Un.Req.pathname;
	u.u_uid = rp->Un.Req.uid;
	u.u_gid = rp->Un.Req.gid;
	rmdir();
	rp->Un.Rep.replycode = u.u_error;
}

LOCchmod(rp)
  register struct UnixChmod *rp;
  {
	register struct a {
		char	*fname;
		int	fmode;
	} *uap = (struct a *)u.u_ap;

	u.u_uid = rp->Un.Req.uid;
	u.u_gid = rp->Un.Req.gid;
	uap->fname = rp->Un.Req.pathname;
	u.u_dirp = (caddr_t)uap->fname;
	uap->fmode = rp->Un.Req.fmode;
	chmod();
	rp->Un.Rep.replycode = u.u_error;
}

LOCfchmod(rp)
  register struct UnixFchmod *rp;
  {
	register struct a {
		int	fd;
		int	fmode;
	} *uap = (struct a *)u.u_ap;

	uap->fd = rp->Un.Req.rfdes;
	uap->fmode = rp->Un.Req.fmode;
	fchmod();
	rp->Un.Rep.replycode = u.u_error;
}

LOCchown(rp)
  register struct UnixChown *rp;
  {
	register struct a {
		char	*fname;
		int	uid;
		int	gid;
	} *uap = (struct a *)u.u_ap;

	u.u_uid = rp->Un.Req.uid;
	u.u_gid = rp->Un.Req.gid;
	uap->fname = rp->Un.Req.pathname;
	u.u_dirp = (caddr_t)uap->fname;
	uap->uid = rp->Un.Req.newuid;
	uap->gid = rp->Un.Req.newgid;
	chown();
	rp->Un.Rep.replycode = u.u_error;
}

LOCfchown(rp)
  register struct UnixFchown *rp;
  {
	register struct a {
		int	fd;
		int	uid;
		int	gid;
	} *uap = (struct a *)u.u_ap;

	uap->fd = rp->Un.Req.rfdes;
	uap->uid = rp->Un.Req.newuid;
	uap->gid = rp->Un.Req.newgid;
	fchown();
	rp->Un.Rep.replycode = u.u_error;
}

LOCtruncate(rp)
  register struct UnixTruncate *rp;
  {
	register struct a {
		char		*fname;
		unsigned long	length;
	} *uap = (struct a *)u.u_ap;

	u.u_uid = rp->Un.Req.uid;
	u.u_gid = rp->Un.Req.gid;
	uap->fname = rp->Un.Req.pathname;
	u.u_dirp = (caddr_t)uap->fname;
	uap->length = rp->Un.Req.length;
	truncate();
	rp->Un.Rep.replycode = u.u_error;
}

LOCftruncate(rp)
  register struct UnixFtruncate *rp;
  {
	register struct a {
		int		fd;
		unsigned long	length;
	} *uap = (struct a *)u.u_ap;

	uap->fd = rp->Un.Req.rfdes;
	uap->length = rp->Un.Req.length;
	ftruncate();
	rp->Un.Rep.replycode = u.u_error;
}

LOCutimes(rp)
  register struct UnixUtimes *rp;
  {
	register struct inode *ip;
	struct timeval atime, mtime;

	u.u_dirp = ((struct fname *)u.u_ap)->fname = rp->Un.Req.pathname;
	u.u_uid = rp->Un.Req.uid;
	u.u_gid = rp->Un.Req.gid;
	if (ip = owner(1)) {
		atime.tv_sec = rp->Un.Req.asec;
		atime.tv_usec = 0;
		mtime.tv_sec = rp->Un.Req.msec;
		mtime.tv_usec = 0;
		ip->i_flag |= IACC|IUPD|ICHG;
		iupdat(ip, &atime, &mtime, 0);
		iput(ip);
	}
	rp->Un.Rep.replycode = u.u_error;
}

LOCfsync(rp)
  struct UnixFsync *rp;
  {
	((struct fd *)u.u_ap)->fd = rp->Un.Req.rfdes;
	fsync();
	rp->Un.Rep.replycode = u.u_error;
}

LOCflock(rp)
  register struct UnixFlock *rp;
  {
	register struct a {
		int		fd;
		long		how;
	} *uap = (struct a *)u.u_ap;

	uap->fd = rp->Un.Req.rfdes;
	uap->how = rp->Un.Req.how;
	flock();
	rp->Un.Rep.replycode = u.u_error;
}

#ifdef	LOCKF
LOClockf(rp)
  register struct UnixLockf *rp;
  {
	register struct a {
		int		fd;
		int		flag;
		off_t		size;
	} *uap = (struct a *)u.u_ap;

	uap->fd = rp->Un.Req.rfdes;
	uap->flag = rp->Un.Req.flag;
	uap->size = (off_t)rp->Un.Req.size;
	lockf();
	rp->Un.Rep.replycode = u.u_error;
}
#endif	LOCKF

LOCrename(rp)
  register struct UnixRename *rp;
  {
	register struct a {
		char	*from;
		char	*to;
	} *uap = (struct a *)u.u_ap;

	u.u_uid = rp->Un.Req.uid;
	u.u_gid = rp->Un.Req.gid;
	u.u_dirp = uap->from = rp->Un.Req.path1;
	uap->to = rp->Un.Req.path2;
	Rrename();
	rp->Un.Rep.replycode = u.u_error;
}

LOCchexec(rp)
  register struct UnixChExec *rp;
  {
	register char *p;
	int uid, gid, newimage;

	u.u_dirp = ((struct fname *)u.u_ap)->fname = p = rp->Un.Req.pathname;
	u.u_uid = uid = rp->Un.Req.uid & 0xFFFF;
	u.u_gid = gid = rp->Un.Req.gid & 0xFFFF;
	Lchexec(&uid, &gid, &newimage);
	if ((rp->Un.Rep.replycode = u.u_error) == 0) {
		CopyTo(u.u_Rclient, p, &u.u_exdata, sizeof(u.u_exdata), 1);
		p += sizeof(u.u_exdata);
	}
	if ((rp->Un.Rep.replycode = u.u_error) == 0) {
		if (u.u_dent.d_namlen >= MAXCOMLEN)
			u.u_dent.d_namlen = MAXCOMLEN - 1;
		u.u_dent.d_name[u.u_dent.d_namlen] = '\0';
		CopyTo(u.u_Rclient, p, u.u_dent.d_name, u.u_dent.d_namlen+1, 1);
	}
	if ((rp->Un.Rep.replycode = u.u_error) == 0) {
		rp->Un.Rep.newuid = uid;
		rp->Un.Rep.newgid = gid;
		rp->Un.Rep.newimage = newimage;
	}
}

LOCload(rp)
  register struct UnixLoad *rp;
  {
	register struct inode *ip = u.u_Rexec;
	struct uio auio;
	struct iovec aiov;

	if (ip == NULL)
		u.u_error = ENOEXEC;
	else if (rp->Un.Req.length == 0  &&  rp->Un.Req.offset == 0) {
		irele(ip);
		u.u_Rexec = NULL;
		auio.uio_resid = 0;
	} else {
		auio.uio_iovcnt = 1;
		auio.uio_iov = &aiov;
		auio.uio_segflg = 0;
		auio.uio_offset = rp->Un.Req.offset;
		auio.uio_resid = aiov.iov_len = rp->Un.Req.length;
		aiov.iov_base = rp->Un.Req.base;
		u.u_error = rwip(ip, &auio, UIO_READ);
	}
	if ((rp->Un.Rep.replycode = u.u_error) == 0)
		rp->Un.Rep.resid = auio.uio_resid;
}

LOCGetInode(rp)
  register struct GetInode *rp;
  {
	struct file *fp;

	if ((fp = getf(rp->Un.Req.rfdes))  &&  fp->f_data)
		u.u_error = copyout(fp->f_data, rp->Un.Req.base,
						sizeof(struct inode));
	else
		u.u_error = EBADF;
	rp->Un.Rep.replycode = u.u_error;
}

unsigned long
GetMid()
  {
	return hostid & 0xFFFF0000;
}

IsMyName(machname)
  char *machname;
  {
# ifdef DONTCHANGETHISFRIGGINGLINE
	if (hostnamelen  &&  strncmp(hostname, machname, hostnamelen) == 0)
# else DONTCHANGETHISFRIGGINGLINE
	if (hostnamelen  &&  strcmp(hostname, machname) == 0)
# endif DONTCHANGETHISFRIGGINGLINE
		return Mid + BarfPid/*0xFFFF*/;
	return 0;
}

RunAway()
  {
	register struct proc *q = u.u_procp, *p = &proc[1];
	int s = spl5();

	if (q->p_osptr)
		q->p_osptr->p_ysptr = q->p_ysptr;
	if (q->p_ysptr)
		q->p_ysptr->p_osptr = q->p_osptr;
	if (p->p_cptr)
		p->p_cptr->p_ysptr = q;
	q->p_osptr = p->p_cptr;
	q->p_ysptr = NULL;
	p->p_cptr = q;

	q->p_pptr = p;
	q->p_ppid = 1;
	splx(s);
}

int
are_any_files_open()
  {
	register struct file **fpp = u.u_ofile;
	register short i = NOFILE;

	while (--i >= 0)
		if (*fpp++)
			return 1;
	return 0;
}

char *
dtoa(n)
  register unsigned long n;
  {
	register unsigned long i;
	static char buf[20];
	register char *p = &buf[sizeof buf / sizeof buf[0]];

	if (n == 0)
		return "0";
	*--p = '\0';
	while (i = n) {
		n /= 10;
		*--p = '0' + i - (n * 10);
	}
	return p;
}

zappid(p)
  register char *p;
  {
	while (*p++)
		;
	p -= 1;
	while (*--p >= '0'  &&  *p <= '9')
		;
	if (*p++ == ' ')
		*p = '\0';
}
