#include "../machine/pte.h"
#include "../h/param.h"
#include "../h/inode.h"
#include "../h/fs.h"
#include "../is68kif/if_ring.h"
#include "saio.h"
#include "sais68k.h"
#include "saboot.h"

int		vbnum;
extern char	*arguments;

#define	VBPHYS0	0xF00000	/* 1st choice physical address */
#define	VBPHYS1	0xE00000	/* 2nd choice physical address */
#define	VBADDR	0x600000	/* kernel virtual address */
#define	VBSIZE0	0x080000	/* length */
#define	VBSIZE1	0x100000	/* length */
int	vbsize;

#define	MAXCPU	32	/* known elsewhere -- don't change! */
struct	icpu {
	unsigned char		ic_active[MAXCPU];
	short			ic_ncpu;
	struct ether_addr	ic_ethaddr;	
	struct ring		*ic_freeringp;
	struct ring		*ic_inputringp[MAXCPU];
	unsigned long		ic_intrinfo[MAXCPU];
};
struct icpu *vbaddr = ((struct icpu *)VBADDR);
#define	ICPUX(p) (((struct ether_header *)(p))->ether_dhost.ether_addr_octet[5])
#define	ItoKval(p,type,base)	((type)((int)(p) + (int)(base)))
#define	KtoIval(p,type,base)	((type)((int)(p) - (int)(base)))
#define	ItoK(p,type,base)	((p) = ItoKval(p,type,base))
#define	KtoI(p,type,base)	((p) = KtoIval(p,type,base))
struct ring *freeringp, *inputringp, *outputringp;

#ifdef	M68020
#define	mapin(v,p,n)	v = p
#else	M68020
extern ushort *shortio;
#endif	M68020

static struct ether_addr	myaddr;
static struct ether_addr	hostaddr;
static struct ether_addr	broaddr = { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};
static struct boot_packet	boot_rcv;
static struct boot_packet	boot_xmt;
struct boot_packet		*vbsend();
static int			pkid;
static struct st		vbst = {512, -1, -1, -1, -1, NULL};

#define	VBDELAY	1000000
#define	VBWAIT(x, y, z)		{ register int i = VBDELAY; 		\
				    while (x) 				\
				    	if (getlocal())			\
						return((y)vbabort(z));	\
				    	else if (--i == 0)		\
						return((y)vbtimeout(z));\
				}
vbopen(io)
	register struct iob *io;
{
	register struct boot_packet *bp;
	register char *p0;
	struct gp_addr {
		unsigned int	gp_dm;
		unsigned int	gp_reg;
	};
	register struct gp_addr *gpp;
	short s;
	extern struct gp_addr gp_addrs[8];	/* this is defined in gip.c */

	if ((p0 = arguments) == (char *)0)
		goto badf;
	while (*p0 != ':')
		if (*p0++ == '\0')
			goto badf;
	pkid = 0;
	io->i_flgs |= F_REMOTE;
	io->i_st = vbst;

#ifdef	M68010
	if ((ushort *)VBPHYS0 <= (shortio+0x8000))
		goto emem;
#endif	M68010
	mapin(vbaddr, (struct icpu *)VBPHYS0, vbsize = VBSIZE0);
	if (!probe(vbaddr, &s)) {
		mapin(vbaddr, (struct icpu *)VBADDR, vbsize);
#ifdef	M68010
		if ((ushort *)VBPHYS1 <= (shortio+0x8000))
			goto emem;
#endif	M68010
		mapin(vbaddr, (struct icpu *)VBPHYS1, vbsize = VBSIZE1);
		if (!probe(vbaddr, &s))
			goto emem;
		/*
		 * Make sure it's not actually a graphics frame buffer.
		 */
		for (gpp = gp_addrs;  gpp < &gp_addrs[8];  gpp += 1) {
			if (VBPHYS1 >= gpp->gp_dm  &&
			    VBPHYS1 < gpp->gp_dm + 0x100000  &&
			    probe(gpp->gp_reg, &s)) {
				if (probeb(gpp->gp_reg + 1, (caddr_t)&s))
					continue;
				goto emem;
			}
		}
	}

	if (vbnum <= 0  ||  vbconnect(vbaddr, vbnum) <= 0)
		goto umap;
	freeringp = vbaddr->ic_freeringp;
	ItoK(freeringp, struct ring *, vbaddr);
	inputringp = vbaddr->ic_inputringp[vbnum];
	ItoK(inputringp, struct ring *, vbaddr);
	outputringp = vbaddr->ic_inputringp[0];
	ItoK(outputringp, struct ring *, vbaddr);

	/* flush any input */
	while(bp = (struct boot_packet *)ringget(inputringp))
		ringput(freeringp, bp);

	/* Get Ethernet address.  */
	hostaddr = vbaddr->ic_ethaddr;
	myaddr = hostaddr;
	ICPUX(&myaddr) = vbnum;

	/* send a broadcast host connect packet to processor #0 */
	bp = &boot_xmt;
	bzero(bp, sizeof(struct boot_packet));
	bp->bp_eh.ether_dhost = broaddr;
	bp->bp_eh.ether_shost = myaddr;
	bp->bp_eh.ether_type = ETHERPUP_BOOT;
	bp->bp_cmd = BOOT_CONNECT;
	bp->bp_pkid = pkid;
	p0 = &bp->bp_data[0];
	while((*arguments != ':') &&  (*p0++ = *arguments++)) 
		;
	if (*arguments == ':')
		arguments += 1;
	if (vbsend() == 0)
		goto cls;

	bzero(bp, sizeof(struct boot_packet));
	bp->bp_eh.ether_dhost = hostaddr;
	bp->bp_eh.ether_shost = myaddr;
	bp->bp_eh.ether_type = ETHERPUP_BOOT;
	bp->bp_cmd = BOOT_OPEN;
	bp->bp_pkid = pkid;
	p0 = &bp->bp_data[0];
	while(*arguments != '('  &&  (*p0++ = *arguments++)) 
		;
	if (*arguments != '(')
		arguments = NULL;
	if (vbsend() == 0)
		goto cls;
	return(0);

  badf:	printf("bad remote file name\n");
	return (-1);
  emem:	printf("vb: not present\n");
  umap:	mapin(vbaddr, (struct icpu *)VBADDR, vbsize);
	return (-1);
  cls:	vbclosering();
	return (-1);
}

vbclose()
{
	register struct boot_packet *bp = &boot_xmt;

	bzero(bp, sizeof(struct boot_packet));
	bp->bp_eh.ether_dhost = hostaddr;
	bp->bp_eh.ether_shost = myaddr;
	bp->bp_eh.ether_type = ETHERPUP_BOOT;
	bp->bp_cmd = BOOT_CLOSE;
	bp->bp_pkid = pkid;
	vbsend();
	vbclosering();
}

/* clear active, flush input, and unmap */
vbclosering()
{
	register struct bcb *bcbp;

	vbaddr->ic_active[vbnum] = 0;
	while( bcbp = (struct bcb *)ringget(inputringp))
		ringput(freeringp, bcbp);
	mapin(vbaddr, (struct icpu *)VBADDR, vbsize);
}

vbstrategy(io, func)
	register struct iob *io;
{
	register int count = io->i_cc;
	register int offset = io->i_offset;
	/* CAUTION this is now a physical addr, things better be 1:1 */
	register struct boot_packet *bp;
	register int len;

	while (count > 0) {
		len = count < BOOT_DATACNT ? count : BOOT_DATACNT;
		bp = &boot_xmt;
		bzero(bp, sizeof(struct boot_packet));
		bp->bp_eh.ether_shost = myaddr;
		bp->bp_eh.ether_dhost = hostaddr;
		bp->bp_eh.ether_type = ETHERPUP_BOOT;
		bp->bp_pkid = pkid;
		bp->bp_offset = offset;
		bp->bp_len = len;
		if (func == READ)
			bp->bp_cmd = BOOT_READ;
		else {
			bp->bp_cmd = BOOT_WRITE;
			bcopy(bp->bp_data, io->i_ma, len);
		}
		if ((bp = vbsend()) == 0)
			return(-1);
		if (func == READ)
			bcopy(bp->bp_data, io->i_ma, bp->bp_len);
		offset += bp->bp_len;
		io->i_ma += bp->bp_len;
		count -= bp->bp_len;
		if (bp->bp_len != len)
			break;
	}
	return(io->i_cc - count);
}

/*
 * output the packet in the tansmit buffer.  Wait for a non-broadcast packet 
 * with the same 'pkid' to come back in the recieve buffer as an acknoldge.  
 * If nothing comes back then wait and do retransmitions.  Return a pointer
 * to the recieved packet, return null if a timeout occured.  The ethernet
 * source field of a recieved CONNECT packet will have the address of the
 * host that responded to the broadcasted CONNECT packet.  The data portion
 * of a recieved READ packed will have the data read.  The data portion of
 * a transmited (and recieved) WRITE packet will have the data to be writen.
 * The host acknoldges packets by performing the specified action, swaping the
 * source and destination addresses in the packet, and sending the packet back 
 * out onto the network.  The host should never change the 'pkid' field of a 
 * boot packet.
 */
struct boot_packet *
vbsend()
{
	register struct boot_packet *bp = &boot_rcv;
	register struct bcb *bcbp;
	register char *buf;

	VBWAIT((bcbp = (struct bcb *)ringget(freeringp)) == 0,
		struct boot_packet *, 0);
	ItoK(bcbp, struct bcb *, vbaddr);
	buf = bcbp->b_addr;
	ItoK(buf, char *, vbaddr);
	bcopy(&boot_xmt, buf, sizeof boot_xmt);
	bcbp->b_len = sizeof boot_xmt;
	KtoI(bcbp, struct bcb *, vbaddr);
	VBWAIT(ringput(outputringp, bcbp) == 0, struct boot_packet *, 1);

	do {
		VBWAIT((bcbp = (struct bcb *)ringget(inputringp)) == 0,
			struct boot_packet *, 2);
		ItoK(bcbp, struct bcb *, vbaddr);
		buf = bcbp->b_addr;
		ItoK(buf, char *, vbaddr);
		bzero(bp, sizeof *bp);
		bcopy(buf, bp, bcbp->b_len);
		KtoI(bcbp, struct bcb *, vbaddr);
		VBWAIT(ringput(freeringp, bcbp) == 0, struct boot_packet *, 3);
	} while (bp->bp_eh.ether_dhost.ether_addr_octet[0] == 0xFF || 
		 bp->bp_eh.ether_type != ETHERPUP_BOOT ||
		 bp->bp_pkid != pkid );
	pkid++;
	return bp;
}

vbconnect(addr, x)
	register struct icpu *addr;
{
	register unsigned char *p = &addr->ic_active[0];

	*p = 0;
	VBWAIT(*p == 0, int, -1);
	return vbjoin(addr, x);
}

vbjoin(addr, x)
	register struct icpu *addr;
{
	register unsigned char *p = &addr->ic_active[0];

	VBWAIT(*p != 0xFF, int, -2);
	if (addr->ic_inputringp[x]  &&  tas(&p[x]))
		return x;
	printf("vb: busy\n");
	return -1;
}

vbtimeout(x)
{
	printf("vb: timeout %d\n", x);
	return(x >= 0 ? 0 : -1);
}

vbabort(x)
{
	printf("vb: abort %d\n", x);
	return(x >= 0 ? 0 : -1);
}
