/*	tm.c	6.1	83/07/29	*/

/*
 * TM11/TE??
 */
#include "../machine/pte.h"

#include "../h/param.h"
#include "../h/inode.h"
#include "../h/fs.h"

#include "../is68kdev/tmreg.h"

#include "saio.h"
#include "sais68k.h"

#define TM_MAXCNT	(1<<16) - 1
#define	TM_CN 		1
#define TM_DR 		4

#define TMADDR1		(struct tmdevice *)0x3FF550
static struct tmdevice 	*tmstd[TM_CN] = { TMADDR1 };
static short		tm_22bit[TM_CN] = { -1 };
static struct st	tmst = { 512, -1, -1, -1, -1, NULL};
static short 		tm_bn[TM_CN][TM_DR];
static char		tm_opened[TM_CN][TM_DR];

tmopen(io)
	register struct iob *io;
{
	register struct tmdevice 	*tmaddr;
	register short			cn = UTOCN(io->i_unit);
	register short			dr = UTODR(io->i_unit);

	tmaddr = tmstd[cn];
	if (!probe(&tmaddr->tmba,&tmaddr->tmba)) {
		printf("tm: controller not present\n");
		return (-1);
	}
	tm_22bit[cn] = probe(&tmaddr->tmbae, &tmaddr->tmbae);
	tmquiet(tmaddr);
	if (tmcommand(cn, dr, TM_REW, 0, 0, 1))
		return (-1);
	tmquiet(tmaddr);
	while (io->i_boff--) {
		do {
			if (tmcommand(cn, dr, TM_SFORW, 0, 1, 1))
				return (-1);
			if (tmaddr->tmer & (TMER_EOT|TMER_ILC|TMER_BTE)) {
				printf("tm: bad file seek\n");
				return (-1);
			}
		} while (!(tmaddr->tmer & TMER_EOF));
	}
	io->i_boff = 0;
	tm_bn[cn][dr] = 0;
	if (tmcommand(cn, dr, TM_RCOM, 0x400, TM_MAXCNT, 1))
		return (-1);
	tmst.nbsec = TM_MAXCNT + tmaddr->tmbc;
/*
	printf("tm: block size %x\n",tmst.nbsec);
 */
	if (tmcommand(cn, dr, TM_SREV, 0, 1, 1))
		return (-1);
	tm_bn[cn][dr] = 0;
	io->i_cc = 0;
	tm_opened[cn][dr] = 1;
	io->i_st = tmst;
	return (0);
}

tmclose(io)
	register struct iob *io;
{
	register short			cn = UTOCN(io->i_unit);
	register short			dr = UTODR(io->i_unit);

	if (tm_opened[cn][dr]) {
		tm_opened[cn][dr] = 0;
		return (tmcommand(cn, dr, TM_REW, 0, 0, 0));
	}
	return (-1);
}

tmcommand(cn, dr, func, addr, count, wait)
int func, addr, count, wait;
{
	register struct tmdevice *tmaddr = tmstd[cn];

	tmaddr->tmbc = -count;
#ifdef	notdef
	tmaddr->tmba = loword(addr);
	if (tm_22bit[cn] == 1)
		tmaddr->tmbae = hiword(addr) & 0x3F;
	else if (!addr18(addr)) {
		printf("tm: 22 bit address\n");
		return (-1);
	}
	tmaddr->tmcs = (dr<<8) | (((addr) >> 12) & 0x30) | func | TM_GO;
	if (wait)
		return(tmwait(tmaddr));
#else
	tmaddr->tmba = 0x400;	/* KLUDGE */
	tmaddr->tmcs = (dr<<8) | func | TM_GO;
	if (tmwait(tmaddr) == -1)
		return (-1);
	bcopy(0x400, addr, count);
#endif
	return (0);
}

tmstrategy(io, func)
	register struct iob *io;
{
	register short			cn = UTOCN(io->i_unit);
	register short			dr = UTODR(io->i_unit);
	register int 			errcnt;
	register unsigned int 		bleft;
	register unsigned short	 	bpart;
	register struct tmdevice	*tmaddr;

	cn = UTOCN(io->i_unit);
	dr = UTODR(io->i_unit);
	tmaddr = tmstd[cn];
	/*
	 * if not on correct block then do seek
	 */
	if (io->i_bn != tm_bn[cn][dr]) {
		if (io->i_bn > tm_bn[cn][dr])
			tmcommand (cn,dr,TM_SFORW,0,io->i_bn-tm_bn[cn][dr],1);
		else
			tmcommand (cn,dr,TM_SREV,0,tm_bn[cn][dr]-io->i_bn,1);
		if (tmaddr->tmbc != 0) {
			printf("tm: bad seek\n");
			return (-1);
		}
	}
	errcnt = 0;
	bleft = io->i_cc;
	if (func == READ)
		func =  TM_RCOM;
	else {
		func =  TM_WCOM;
		printf("tm: can`t write tapes\n");
		return (-1);
	}

	do {
		bpart = tmst.nbsec;
	retry:
		tmquiet(tmaddr);
		if (tmcommand(cn, dr, func, io->i_ma, bpart, 1))
			return (-1);
		if (tmaddr->tmer & TMER_EOT)
			return (0);
		if (tmaddr->tmer & TM_ERR) {
			if (tmaddr->tmer & TMER_EOF)
				return (0);
			if (errcnt == 0)
				printf("tm: error er=%b",tmaddr->tmer,TMER_BITS);
			if (errcnt == 10) {
				printf("\n");
				return (-1);
			}
			errcnt++;
			if (tmcommand(cn, dr, TM_SREV, 0, 1, 1))
				return (-1);
			goto retry;
		}
		if (errcnt)
			printf("tm: recovered by retry\n");
		if (tmaddr->tmer & TMER_EOF)
			return (0);
		bpart += tmaddr->tmbc;
		io->i_ma += bpart;
		bleft -= bpart;
	} while (bleft > 0);
	tm_bn[cn][dr] += io->i_cc / io->i_st.nbsec;
	return (io->i_cc);
}

static
tmquiet(tmaddr)
	register struct tmdevice *tmaddr;
{
	register err;

	tmwait(tmaddr);
	for (;;) {
		err = tmaddr->tmer;
		DELAY(100);
		if ((err&TMER_TUR) && (err&TMER_SDWN)==0)
			break;
	}
}

static
tmwait(tmaddr)
	register struct tmdevice *tmaddr;
{
	register int i;
	short cs;

#ifdef	M68020
	for ( i = 3200000; i ; i--)
#else	M68020
	for ( i = 800000; i ; i--)
#endif	M68020
		if (probe(&tmaddr->tmcs, &cs) && (cs & TM_CUR) != 0)
			break;
		else
			DELAY(100);
	if (i == 0) {
		printf("tm: timeout\n");
		return(-1);
	}
	return (0);
}
