/*	sys.c	6.2	83/09/23	*/

#include "../h/param.h"
#include "../h/inode.h"
#include "../h/fs.h"
#include "../h/dir.h"
#include "saio.h"

char	*arguments;
ino_t	dlook();
int	openfirst = 1;
int	lsflag;			/* set in boot.c if command is 'ls' */

struct dirstuff {
	int loc;
	struct iob *io;
};

static
openi(n, io)
	register struct iob *io;
{
	struct dinode *dp;
	int cc;

	io->i_offset = 0;
	io->i_bn = fsbtodb(&io->i_fs, itod(&io->i_fs, n)) + io->i_boff;
	io->i_cc = io->i_fs.fs_bsize;
	io->i_ma = paddr(io->i_buf);
	cc = devread(io);
	dp = (struct dinode *)io->i_buf;
	io->i_ino.i_ic = dp[itoo(&io->i_fs, n)].di_ic;
	if ((io->i_ino.i_mode&IFMT) == IFLNK) {
		printf("can't follow symbolic link\n");
		return (-1);
	}
	return (cc);
}

static
find(path, io)
	register char *path;
	register struct iob *io;
{
	register char *q;
	register char c;
	register int n;

	if (path==NULL || *path=='\0') {
		printf("null path\n");
		return (0);
	}

	if (openi((ino_t) ROOTINO, io) < 0) {
		printf("can't read root inode\n");
		return (0);
	}
	while (*path) {
		while (*path == '/')
			path++;
		q = path;
		while (*q != '/' && *q != '\0')
			q++;
		c = *q;
		*q = '\0';
		n = 0;
		if (c == 0)
			n = lsflag;
		if ((n = dlook(path, io, n)) != 0) {
			if (c == '\0')
				break;
			if (openi(n, io) < 0)
				return (0);
			*q = c;
			path = q;
			continue;
		} else {
			if (lsflag == 0)
				printf("file '%s' not found\n", path);
			return (0);
		}
	}
	return (n);
}

static daddr_t
sbmap(io, bn)
	register struct iob *io;
	register daddr_t bn;
{
	register struct inode *ip;
	register int i, j, sh;
	register daddr_t nb, *bap;

	ip = &io->i_ino;
	if (bn < 0) {
		printf("bn -\n");
		return ((daddr_t)0);
	}

	/*
	 * blocks 0..NDADDR are direct blocks
	 */
	if (bn < NDADDR) {
		nb = ip->i_db[bn];
		return (nb);
	}

	/*
	 * addresses NIADDR have single and double indirect blocks.
	 * the first step is to determine how many levels of indirection.
	 */
	sh = 1;
	bn -= NDADDR;
	for (j = NIADDR; j > 0; j--) {
		sh *= NINDIR(&io->i_fs);
		if (bn < sh)
			break;
		bn -= sh;
	}
	if (j == 0) {
		printf("bn ^%D\n", bn);
		return ((daddr_t)0);
	}

	/*
	 * fetch the first indirect block address from the inode
	 */
	nb = ip->i_ib[NIADDR - j];
	if (nb == 0) {
		printf("bn .%D\n",bn);
		return ((daddr_t)0);
	}

	/*
	 * fetch through the indirect blocks
	 */
	for (; j <= NIADDR; j++) {
		if (blknos[j] != nb) {
			io->i_bn = fsbtodb(&io->i_fs, nb) + io->i_boff;
			io->i_ma = paddr(&b[j-NIADDR][0]);
			io->i_cc = io->i_fs.fs_bsize;
			if (devread(io) != io->i_fs.fs_bsize) {
				if (io->i_error)
					errno = io->i_error;
				printf("bn %D: read error\n", io->i_bn);
				return ((daddr_t)0);
			}
			blknos[j] = nb;
		}
		bap = (daddr_t *)b[j-NIADDR];
		sh /= NINDIR(&io->i_fs);
		i = (bn / sh) % NINDIR(&io->i_fs);
		nb = bap[i];
		if (nb == 0) {
			printf("bn .%D\n",bn);
			return ((daddr_t)0);
		}
	}
	return (nb);
}

static ino_t
dlook(s, io, lsf)
	register char *s;
	register struct iob *io;
{
	register struct direct *dp;
	struct direct *readdir();
	register struct inode *ip;
	struct dirstuff dirp;
	register int len;

	if (s == NULL || *s == '\0')
		return (0);
	ip = &io->i_ino;
	if ((ip->i_mode&IFMT) != IFDIR) {
		printf("not a directory\n");
		return (0);
	}
	if (ip->i_size == 0) {
		printf("null directory\n");
		return (0);
	}
	len = strlen(s);
	dirp.loc = 0;
	dirp.io = io;
	for (dp = readdir(&dirp); dp != NULL; dp = readdir(&dirp)) {
		if (dp->d_ino == 0)
			continue;
		if (lsf)
			printf("	%s\n",dp->d_name);
		else if (dp->d_namlen == len && !strcmp(s, dp->d_name))
			return (dp->d_ino);
	}
	return (0);
}

/*
 * get next entry in a directory.
 */
struct direct *
readdir(dirp)
	register struct dirstuff *dirp;
{
	register struct direct *dp;
	register struct iob *io;
	register daddr_t lbn, d;
	register int off;

	io = dirp->io;
	for (;;) {
		if (dirp->loc >= io->i_ino.i_size)
			return (NULL);
		off = blkoff(&io->i_fs, dirp->loc);
		if (off == 0) {
			lbn = lblkno(&io->i_fs, dirp->loc);
			d = sbmap(io, lbn);
			if (d == 0)
				return NULL;
			io->i_bn = fsbtodb(&io->i_fs, d) + io->i_boff;
			io->i_ma = paddr(io->i_buf);
			io->i_cc = blksize(&io->i_fs, &io->i_ino, lbn);
			if (devread(io) < 0) {
				errno = io->i_error;
				printf("bn %D: read error\n", io->i_bn);
				return (NULL);
			}
		}
		dp = (struct direct *)(io->i_buf + off);
		dirp->loc += dp->d_reclen;
		if (dp->d_ino == 0)
			continue;
		return (dp);
	}
}

lseek(fdesc, addr, ptr)
	register int fdesc, ptr;
	register off_t addr;
{
	register struct iob *io;

	if (ptr != 0) {
		printf("seek not from 0\n");
		errno = EOFFSET;
		return (-1);
	}
	fdesc -= 3;
	if (fdesc < 0 || fdesc >= NFILES ||
	    ((io = &iob[fdesc])->i_flgs & F_ALLOC) == 0) {
		errno = EBADF;
		return (-1);
	}
	io->i_offset = addr;
	io->i_bn = addr / io->i_st.nbsec;
	io->i_cc = 0;
	return (0);
}

getc(fdesc)
	register int fdesc;
{
	register struct iob *io;
	register struct fs *fs;
	register char *p;
	register int cc, size, off, lbn, diff;
	int c;


	if (fdesc >= 0 && fdesc <= 2)
		return (getchar());
	fdesc -= 3;
	if (fdesc < 0 || fdesc >= NFILES ||
	    ((io = &iob[fdesc])->i_flgs&F_ALLOC) == 0) {
		errno = EBADF;
		return (-1);
	}
	if (io->i_cc <= 0) {
		if ((io->i_flgs & F_FILE) != 0) {
			diff = io->i_ino.i_size - io->i_offset;
			if (diff <= 0)
				return (-1);
			fs = &io->i_fs;
			lbn = lblkno(fs, io->i_offset);
			io->i_bn = fsbtodb(fs, sbmap(io, lbn)) + io->i_boff;
			off = blkoff(fs, io->i_offset);
			size = blksize(fs, &io->i_ino, lbn);
		} else {
			io->i_bn = io->i_boff + io->i_offset / io->i_st.nbsec;
			off = 0;
			size = io->i_st.nbsec;
		}
		io->i_ma = paddr(io->i_buf);
		io->i_cc = size;
		cc = devread(io);
		if (cc < 0) {
			errno = io->i_error;
			return (-1);
		}
		if ((io->i_flgs & F_FILE) != 0) {
			if (io->i_offset - off + size >= io->i_ino.i_size)
				io->i_cc = diff + off;
			io->i_cc -= off;
		}
		else if (cc == 0)
			return (-1);
		p = &io->i_buf[off];
	} else {
		p = &io->i_buf[io->i_ma-paddr(io->i_buf)];
	}
	io->i_cc--;
	io->i_offset++;
	c = (unsigned)*p++;
	io->i_ma = paddr(p);
	return (c&0xFF);
}

read(fdesc, buf, count)
	register int fdesc, count;
	register char *buf;
{
	register int i, c, size, lbn, bs;
	register struct iob *io;
	register struct fs *fs;

	errno = 0;
	if (fdesc >= 0 & fdesc <= 2) {
		i = count;
		do {
			*buf = getchar();
		} while (--i && *buf++ != '\n');
		return (count - i);
	}
	fdesc -= 3;
	if (fdesc < 0 || fdesc >= NFILES ||
	    ((io = &iob[fdesc])->i_flgs&F_ALLOC) == 0) {
		errno = EBADF;
		return (-1);
	}
	if ((io->i_flgs&F_READ) == 0) {
		errno = EBADF;
		return (-1);
	}
	if ((io->i_flgs & F_FILE) == 0) {
		if ((i = count) <= 0)
			return (0);
		while ((io->i_offset%io->i_st.nbsec) && i--) {
			c = getc(fdesc+3);
			if (c < 0)
				return(count - i - 1);
			*buf++ = c;
		}
		size = (i/io->i_st.nbsec) * io->i_st.nbsec;
		if (size > 0) {
			io->i_cc = size;
			io->i_ma = paddr(buf);
			io->i_bn = io->i_boff + (io->i_offset/io->i_st.nbsec);
			if ((size = devread(io)) < 0) {
				errno = io->i_error;
				return (-1);
			} else if (size == 0)
				return(count - i);
			buf += size;
			io->i_offset += size;
			io->i_cc = 0;
			i -= size;
		}
		while (i-- > 0) {
			c = getc(fdesc+3);
			if (c < 0)
				return(count - i - 1);
			*buf++ = c;
		}
	} else {
		if (io->i_offset+count > io->i_ino.i_size)
			count = io->i_ino.i_size - io->i_offset;
		if ((i = count) <= 0)
			return (0);
		while (io->i_offset%io->i_st.nbsec && i--) {
			c = getc(fdesc+3);
			if (c < 0)
				return(count - i - 1);
			*buf++ = c;
		}
		fs = &io->i_fs;
		while (i > 0) {
			lbn = lblkno(fs, io->i_offset); 
			bs = blkoff(fs, io->i_offset);
			io->i_bn = fsbtodb(fs, sbmap(io, lbn)) + 
				io->i_boff + bs/io->i_st.nbsec;
			bs = blksize(fs, &io->i_ino, lbn) - bs;
			size = (i < bs ) ? i : bs;
			io->i_cc = size;
			io->i_ma = paddr(buf);
			if ((c = devread(io)) < 0) {
				errno = io->i_error;
				return (-1);
			} else if (c != size)
				return(count - i - c);
			io->i_offset += size;
			io->i_cc = 0;
			buf += size;
			i -= size;
		}
	}
	return (count);
}

write(fdesc, buf, count)
	register int fdesc, count;
	register char *buf;
{
	register i;
	register struct iob *io;

	errno = 0;
	if (fdesc >= 0 && fdesc <= 2) {
		i = count;
		while (i--)
			putchar(*buf++);
		return (count);
	}
	fdesc -= 3;
	if (fdesc < 0 || fdesc >= NFILES ||
	    ((io = &iob[fdesc])->i_flgs&F_ALLOC) == 0) {
		errno = EBADF;
		return (-1);
	}
	if ((io->i_flgs&F_WRITE) == 0) {
		errno = EBADF;
		return (-1);
	}
	io->i_cc = count;
	io->i_ma = paddr(buf);
	io->i_bn = io->i_boff + (io->i_offset / io->i_st.nbsec);
	i = devwrite(io);
	io->i_offset += count;
	if (i < 0)
		errno = io->i_error;
	return (i);
}

open(str, how)
	char *str;
	register int how;
{
	register char *cp;
	register int i;
	register char *s;
	register struct iob *io;
	register struct devsw *dp;
	register int fdesc;
	long atol();

	arguments = NULL;
	if (openfirst) {
		for (i = 0; i < NFILES; i++)
			iob[i].i_flgs = 0;
		openfirst = 0;
	}
	for (fdesc = 0; fdesc < NFILES; fdesc++)
		if (iob[fdesc].i_flgs == 0)
			goto gotfile;
	exit("no more file slots");
gotfile:
	(io = &iob[fdesc])->i_flgs |= F_ALLOC;
	for (cp = str; *cp && *cp != '('; cp++)
			;
	if (*cp != '(')
		goto baddev;
	*cp++ = '\0';
	for (dp = devsw; dp->dv_name; dp++)
		if (!strcmp(str, dp->dv_name))
			goto gotdev;
baddev:	printf("unknown device, legal devices are:\n	");
	for (dp = devsw; dp->dv_name; dp++)
		printf("%s  ",dp->dv_name);
	printf("\n");
	io->i_flgs = 0;
	errno = ENXIO;
	return (-1);
gotdev:	*(cp-1) = '(';
	io->i_ino.i_dev = dp-devsw;
	io->i_unit = *cp++ - '0';
	if (*cp >= '0' && *cp <= '9')
		io->i_unit = io->i_unit * 10 + *cp++ - '0';
	if (io->i_unit < 0 || io->i_unit > 31) {
		printf("bad unit\n");
		io->i_flgs = 0;
		errno = EUNIT;
		return (-1);
	}
	if (*cp++ != ',') {
badoff:		printf("missing offset\n");
		io->i_flgs = 0;
		errno = EOFFSET;
		return (-1);
	}
	io->i_fpart = io->i_boff = atol(cp);
	for (;;) {
		if (*cp == ')')
			break;
		if (*cp == 'b' || *cp == 'B')
			io->i_flgs |= F_BLKOFF;
		if (*cp++)
			continue;
		goto badoff;
	}
	cp++;
	arguments = cp;
	if (devopen(io) < 0) {
		io->i_flgs = 0;
		return (-1);
	}
	if (io->i_flgs & F_REMOTE || *cp == '\0' || *cp == '(') {
		io->i_flgs |= how+1;
		goto done;
	} else
		arguments = NULL;
	io->i_ma = paddr(&io->i_fs);
	io->i_cc = SBSIZE;
	io->i_bn = SBLOCK + io->i_boff;
	io->i_offset = 0;
	if (devread(io) < 0) {
		errno = io->i_error;
		printf("super block read error\n");
		io->i_flgs = 0;
		return (-1);
	}
	if (io->i_fs.fs_magic != FS_MAGIC) {
		errno = ESRCH;
		printf("bad super block magic number\n");
		io->i_flgs = 0;
		return (-1);
	}
	for (s = cp ; *s ; s++)
		if (*s == '(') {
			arguments = s;
			*arguments = '\0';
			break;
		}
	if ((i = find(cp, io)) == 0) {
		io->i_flgs = 0;
		errno = ESRCH;
		return (-1);
	}
	if (arguments)
		*arguments = '(';
	if (how != 0) {
		printf("can't write files\n");
		io->i_flgs = 0;
		errno = EIO;
		return (-1);
	}
	if (openi(i, io) < 0) {
		errno = io->i_error;
		io->i_flgs = 0;
		return (-1);
	}
	io->i_flgs |= F_FILE | (how+1);
done:	if (arguments && *arguments == '\0')
		arguments = NULL;
	io->i_offset = 0;
	io->i_cc = 0;
	return (fdesc+3);
}

close(fdesc)
	register int fdesc;
{
	register struct iob *io;

	fdesc -= 3;
	if (fdesc < 0 || fdesc >= NFILES ||
	    ((io = &iob[fdesc])->i_flgs&F_ALLOC) == 0) {
		errno = EBADF;
		return (-1);
	}
	if ((io->i_flgs&F_FILE) == 0)
		devclose(io);
	io->i_flgs = 0;
	return (0);
}

ioctl(fdesc, cmd, arg)
	register int fdesc, cmd;
	char *arg;
{
	register struct iob *io;
	register int error = 0;

	fdesc -= 3;
	if (fdesc < 0 || fdesc >= NFILES ||
	    ((io = &iob[fdesc])->i_flgs&F_ALLOC) == 0) {
		errno = EBADF;
		return (-1);
	}
	switch (cmd) {
#ifdef notdef
	    case SAIOHDR:
		io->i_flgs |= F_HDR;
		break;

	    case SAIOCHECK:
		io->i_flgs |= F_CHECK;
		break;

	    case SAIOHCHECK:
		io->i_flgs |= F_HCHECK;
		break;

	    case SAIONOBAD:
		io->i_flgs |= F_NBSF;
		break;

	    case SAIODOBAD:
		io->i_flgs &= ~F_NBSF;
		break;

	    case SAIOECCLIM:
		io->i_flgs |= F_ECCLM;
		break;

	    case SAIOECCUNL:
		io->i_flgs &= ~F_ECCLM;
		break;

	    case SAIOSEVRE:
		io->i_flgs |= F_SEVRE;
		break;

	    case SAIONSEVRE:
		io->i_flgs &= ~F_SEVRE;
		break;
#endif notdef

	    default:
		error = devioctl(io, cmd, arg);
		break;
	}
	if (error < 0)
		errno = io->i_error;
	return (error);
}
