/*
 *   Integrated Solutions SIO I/O Routines
 */
#define XONXOFF

#include "../h/param.h"
#include "../is68kdev/sioreg.h"

int	putlocal(), wputlocal(), putremote(), wputremote();
int	getlocal(), wgetlocal(), getremote(), wgetremote();
int	getchar(),  putchar();

int (*putch)() = putchar;
int (*getch)() = getchar;
int putslow = 0;
int autoboot = 0; 
#ifdef XONXOFF
#define CTLQ 	 0x11
#define CTLS 	 0x13
static char lochar = 0, rmchar = 0;
#endif XONXOFF

#define SPLOCAL ((struct siodevice *)SIO0_ADR)
#define SPREMOTE ((struct siodevice *)SIO1_ADR)

#define RXRDY 0x01
#define TXRDY 0x04

/* wait for and return a character from the remote */
wgetremote()
{
	register int c;

#ifdef XONXOFF
	if (lochar) 
		return(lochar);
#endif XONXOFF
	while ((c = getremote()) == 0) ;
	return(c);
}

/* wait for and return a character from the local */
wgetlocal()
{
	register int c;

#ifdef XONXOFF
	if (lochar) 
		return(lochar);
#endif XONXOFF
	while ((c = getlocal()) == 0) ;
	return(c);
}

/* wait for local to be ready and output a charater */
wputlocal(c)
{
#ifdef XONXOFF
	if ((lochar = getlocal()) == CTLS) {
		while (getlocal() != CTLQ) ;
		lochar = 0;
	}
#endif XONXOFF
	while (putlocal(c) == 0) ;
}

/* wait for remote to be ready and output a charater */
wputremote(c)
{
#ifdef XONXOFF
	if ((rmchar = getremote()) == CTLS) {
		while (getremote() == CTLQ) ;
		rmchar = 0;
	}
#endif XONXOFF
	while (putremote(c) == 0) ;
}

/*
 * getremote()
 *	get a character from the remote port
 *	do not wait! return 0 if there is none
 */
getremote()
{
	if ((SPREMOTE->sio_ctrl & SIOR0_RXRDY) == 0)
		return (0);
	return(SPREMOTE->sio_data & 0177);
}

/*
 * putremote()
 *	put a character to the remote port
 *	do not wait! return 0 if it is not ready
 */
putremote(c)
char c;
{
	if ((SPREMOTE->sio_ctrl & SIOR0_TXRDY) == 0)
		return (0);
	SPREMOTE->sio_data = c;
	if (putslow)
		DELAY(2000);
	return(1);
}

/*
 * getlocal()
 *	get a character from the local port
 *	do not wait! return 0 if there is none
 */
getlocal(x)
{
	if ((SPLOCAL->sio_ctrl & SIOR0_RXRDY) == 0)
		return (0);
	return(SPLOCAL->sio_data & 0177);
}

/*
 * putlocal()
 *	put a character to the local port
 *	do not wait! return 0 if it is not ready
 */
putlocal(c)
char c;
{
	putslow = 0;
	if ((SPLOCAL->sio_ctrl & SIOR0_TXRDY) == 0)
		return (0);
	SPLOCAL->sio_data = c;
#ifdef	VBUS
	g_putc(c);		/* graphics putc */
#else	VBUS
	putparallax(c);		/* graphics putc */
#endif	VBUS
	return(1);
}

getchar ()
{
	int c;

	c = wgetlocal();
	if (c == '\r')
		wputlocal('\n');
	putchar(c);
	return c;
}

putchar (c)
{
	if (autoboot)
		return;
	wputlocal(c);
	if (c == '\n')
		wputlocal('\r');
}
