/*
 * Standalone driver for the IS SASI host adaptor disk controller.
 */
#include "../h/param.h"
#include "../h/inode.h"
#include "../h/fs.h"

#include "../is68kdev/sdreg.h"

#include "saio.h"
#include "sais68k.h"

#ifdef	M68020
#define	SDADDR0	  	((struct sddevice *) 0xFFFFE0) /* 1st addr */
#define	SDADDR1	  	((struct sddevice *) 0xFFFFFF) /* 2nd addr */
#else	M68020
#define	SDADDR0	  	((struct sddevice *) 0x7FFFE0) /* 1st addr */
#define	SDADDR1	  	((struct sddevice *) 0x7FFFFF) /* 2nd addr */
#endif	M68020

#define	SD_CN		2			/* number of controllers */
#define	SD_DR		4			/* drives per controller */
#define	SD_MAXCNT	0x1FE00			/* must be multiple of nbsec */

static struct sddevice *sdstd[SD_CN] = { SDADDR0, SDADDR1};

int forbb, sdstrat();

sdopen(io)
	register struct iob *io;
{
	register int			cn = UTOCN(io->i_unit); 
	register int 			dr = UTODR(io->i_unit);
	register struct sddevice 	*sdaddr;

	if (dr >= SD_DR || cn >= SD_CN) {
		printf("sd: bad unit\n");
		return (-1);
	}
	sdaddr = sdstd[cn];
	if (!probe(&sdaddr->sdba,&sdaddr->sdba)) {
		printf("sd%d: not present\n", dr);
		return (-1);
	}
	if (sdwait(sdaddr))
		return (-1);
	sdaddr->sdcs = (dr<<8) | SD_SIZE | SD_CBSY;
	if (sdwait(sdaddr) || (sdaddr->sdcs & SD_ERR) || (sdaddr->sdda == 0) ||
	    (sdaddr->sdcs == ((dr<<8)|SD_SIZE|SD_CBSY)))
		return (-1);
	io->i_st.nsect = sdaddr->sdwc;
	io->i_st.ntpc = sdaddr->sdda;
	io->i_st.nspc = io->i_st.nsect * io->i_st.ntpc;
	io->i_st.nbsec = sdaddr->sdba;
	io->i_st.ncyl = sdaddr->sdae;
	io->i_st.off = NULL;
/*	printf("(%dx%dx%d)\n",io->i_st.nsect,io->i_st.ntpc,io->i_st.ncyl); /**/
	if ((io->i_boff = diskpart(io)) < 0) {
		printf("sd%d: bad offset\n", dr);
		return (-1);
	}
	return(0);
}

sdstrategy(io, func)
	register struct iob *io;
{
	register int			bleft, 
					bpart;
	register int 			bn = io->i_bn;
	register int 			dr = UTODR(io->i_unit);

	switch (func) {
	  case READ:
		func = SD_READ; 
		break;
	  case WRITE:
		func = SD_WRITE; 
		break;
	  default:
		printf("sd%d: bad func 0x%x\n", func, dr);
		return -1;
	}
	bleft = io->i_cc;	/* byte cnt */
	do {
		bpart = (bleft < SD_MAXCNT) ? bleft : SD_MAXCNT;
		if (forbb) {
			if (sdstrat(io,bn,bpart,func) == -1)
				return -1;
			io->i_ma += bpart;
		} else if (badstrat(io,bn,bpart,func,sdstrat,SD_READ) == -1)
			return -1;
		bleft -= bpart;
		bn += bpart / io->i_st.nbsec;
	} while (bleft > 0);
	return io->i_cc;
}

sdstrat(io,bn,bpart,func)
	register struct iob *io;
	register int bn;
	int bpart, func;
{
	register int 			cn = UTOCN(io->i_unit);
	register int 			dr = UTODR(io->i_unit);
	register struct sddevice 	*sdaddr = sdstd[cn];
	static int 			errcnt = 0;

	while (1) {
		sdaddr->sdda = bn;
		sdaddr->sdba = io->i_ma;
		sdaddr->sdae = ((bn >> 8) &0xFF00) | ((io->i_ma >> 16) & 0xFF);
		sdaddr->sdwc = bpart >> 1;
		sdaddr->sdcs = dr<<8 | func | SD_CBSY;
		if (sdwait(sdaddr)) {
			printf("sd%d: HUNG sn=%d ",dr,bn);
			printf("cs=%b sw=%x %x %x\n", dr, bn, 
				sdaddr->sdcs, SDCS_BITS, sdaddr->sdsw[0], 
				sdaddr->sdsw[1], sdaddr->sdsw[2]);
			return (-1);
		}
		if (sdaddr->sdcs & SD_ERR) {
			printf("sd%d: sn=%d cs=%b sw=%x %x %x\n", dr, bn, 
				sdaddr->sdcs, SDCS_BITS, sdaddr->sdsw[0], 
				sdaddr->sdsw[1], sdaddr->sdsw[2]);
			if (++errcnt < 5)
				continue;
			errcnt = 0;
			return -1;
		}
		return 0;
	}
}

static 
sdwait(sdaddr)
	register struct sddevice *sdaddr;
{ 	
	register int l = 0;

	DELAY(400);
/*	while (sdaddr->sdcs & SD_CBSY)  { /**/
	while (sdaddr->sdcs == 0xffff)  { /**/
#ifdef	M68020
		if (++l == 200000) {
#else	M68020
		if (++l == 50000) {
#endif	M68020
			printf("sd: timeout\n");
			return (-1);
		}
		DELAY(400);
	}
	return (0);
}
