/*	sais68k.h	6.1	83/07/29	*/

/*
 * Standalone definitions peculiar to is68k.
 */

#define setjmp(x)	_setjmp(x)
#define longjmp(x,y)	_longjmp(x,y)

/*
 * Devices in the standalone system are referenced as 
 *	xx(unit,[section|boff]){file}
 *		xx=		type of device {rl,hp,ra,rk, etc..}
 * 		unit=		8*controller+drive.
 *		section=	standard file system section {1-7}
 *		boff=		block offset {1000b}
 */

int 		cpu;		/* see <sys/cpu.h> */
extern	short	cpusw;		/* CPU Switches */
extern	int	cpuchip;	/* Type of CPU chip 68000 or 68010 */

#define	LINEBUF		0x700
#define	LINELEN		0x100

#define	MAXCN		2	/* Max number of controller of one type */
#define	MAXDR		8	/* Max number of drives off a controller */

#define	UTODR(u)	((u) & 0x07)		/* minor # to drive */
#define	UTOCN(u)	((u)>>3 & 0x01)		/* minor # to controller */

/*
 * The standalone rx driver is different. 
 *		unit=		unit | density
 */
#define	RX_UNIT(u)	(u&0x01)	/* Unit Number: 0=left,1=right*/
#define	RX_DENSITY(u)	(u&0x02)	/* Density: 0=single,2=double */
#define	RX_SIDES(u)	(u&0x04)	/* Sides: 0=single,4=double */
