#define ETHERPUP_BOOT		0x0807		/* Boot protocol */

/*
 * Ethernet address - 6 octets
 */
struct ether_addr {
	u_char	ether_addr_octet[6];
};

/*
 * Structure of a 10Mb/s Ethernet header.
 */
struct	ether_header {
	struct	ether_addr ether_dhost;
	struct	ether_addr ether_shost;
	u_short	ether_type;
};

struct boot_packet {
	struct ether_header	bp_eh;		/* standard ethernet header */
	int			bp_pkid;	/* packet id */
	char			bp_cmd;		/* command */
#define	BOOT_CONNECT		0x0
#define	BOOT_OPEN		0x1
#define	BOOT_READ		0x2
#define	BOOT_WRITE		0x3
#define	BOOT_CLOSE		0x4
	int			bp_offset;	/* offset */
#define	BOOT_DATACNT		(1024+256+128)
	int			bp_len;		/* length */
	char			bp_data[BOOT_DATACNT];	/* data */
};
