/*	rk.c	6.1	83/07/29	*/

/*
 * RK611/RK07
 */
#include "../machine/pte.h"

#include "../h/param.h"
#include "../h/inode.h"
#include "../h/fs.h"

#include "../is68kdev/rkreg.h"

#include "saio.h"
#include "sais68k.h"

static struct rkdevice	*rkstd[] = { (struct rkdevice *)0x3FFF20 };
static int		rk_off[][8] =  {{ 0, 241, 0, -1, -1, -1, -1, -1},
			  		{ 0, 241, 0, -1, -1, -1, 393, -1}};
static struct st 	rkst[] =       {{512, 22, 3, 66, 411, rk_off[0]},
			  	  	{512, 22, 3, 66, 815, rk_off[1]}};
static short 		rk_type[] = 	{ 0, 0, 0, 0, 0, 0, 0 };
static short 		rk_init[] = 	{ 0, 0, 0, 0, 0, 0, 0 };
static short 		rk_22bit[] = 	{ 0, 0, 0, 0, 0, 0, 0 };

#define RK_DELAY	40

int rkstrat(), forbb;

rkopen(io)
	register struct iob *io;
{
	register struct rkdevice *rkaddr = rkstd[UTOCN(io->i_unit)];

	if (!probe(&rkaddr->rkba,&rkaddr->rkba)) {
		printf("rk: controller not present\n");
		return (-1);
	}
	if (!(io->i_flgs & F_BLKOFF)) {
		if (rk_off[0][io->i_boff] == -1 || io->i_boff < 0 || 
			io->i_boff > 7) {
			printf("rk: bad offset\n");
			return (-1);
		}
		io->i_boff = rk_off[0][io->i_boff] * NRKSECT*NRKTRK;
	}
	if (!rk_init[io->i_unit]) {
		rk_init[io->i_unit]++;
		rk_22bit[io->i_unit] = probe(&rkaddr->rkbae, &rkaddr->rkbae);
		rkaddr->rkcs2 = RKCS2_SCLR;
		DELAY(RK_DELAY);
		if (rkwait(rkaddr))
			return (-1);
		rk_type[io->i_unit] = 0;
		io->i_st = rkst[0];
		rkaddr->rkcs2 = UTODR(io->i_unit);
		rkaddr->rkcs1 = rk_type[io->i_unit] | RK_PACK | RK_GO;
		if (rkwait(rkaddr))
			return (-1);
		if (rkaddr->rkcs1 & RK_CERR && rkaddr->rker & RKER_DTYE) {
			rk_type[io->i_unit] = RK_CDT;
			io->i_st = rkst[1];
			rkaddr->rkcs1 = rk_type[io->i_unit] | RK_CERR;
			DELAY(RK_DELAY);
			rkaddr->rkcs1 = rk_type[io->i_unit] | RK_PACK | RK_GO;
			if (rkwait(rkaddr))
				return (-1);
		}
	}
	return (0);
}

rkstrategy(io, func)
register struct iob *io;
{
	register int wc = io->i_cc;

	if (forbb)
		return rkstrat(io,io->i_bn,wc,func);
	else if (badstrat(io,io->i_bn,wc,func,rkstrat,READ) == -1)
		return -1;
	else
		return wc;
}

rkstrat(io, bn, wc, func)
register struct iob *io;
register int bn, wc;
int func;
{
	register struct rkdevice *rkaddr = rkstd[UTOCN(io->i_unit)];
	register int com;
	short dn, cn, sn, tn;
	register int errcnt = 0;

	dn = UTODR(io->i_unit);
	cn = bn/(NRKSECT*NRKTRK);
	sn = bn%(NRKSECT*NRKTRK);
	tn = sn / NRKSECT;
	sn %= NRKSECT; 

retry:
	rkaddr->rkcs1 = rk_type[io->i_unit] | RK_CCLR;
	DELAY(RK_DELAY);
	rkaddr->rkcs2 = dn;
	rkaddr->rkcs1 = rk_type[io->i_unit]|RK_PACK|RK_GO;
	if (rkwait(rkaddr))
		return (-1);
	rkaddr->rkcs1 = rk_type[io->i_unit]|RK_DCLR|RK_GO;
	if (rkwait(rkaddr))
		return (-1);
	rkaddr->rkcyl = cn;
	rkaddr->rkda = sn | (tn << 8);
	rkaddr->rkba = loword(io->i_ma);
	if (rk_22bit[io->i_unit])
		rkaddr->rkbae = RKBAE_22 | (hiword(io->i_ma) & 0x3F);
	else if (!addr18(io->i_ma)) {
		printf("rk: 22 bit address\n");
		return (-1);
	}
	rkaddr->rkwc = -((wc + sizeof(short) - 1) >> 1);
	com = rk_type[io->i_unit]|(((long)io->i_ma>>8)&0x300)|RK_GO;
	if (func == READ)
		com |= RK_READ;
	else
		com |= RK_WRITE;
more:
	rkaddr->rkcs1 = com;
	if (rkwait(rkaddr))
		return (-1);
	if (rkaddr->rkcs1 < 0) {
		printf("rk: error (cyl,trk,sec)=(%d,%d,%d) cs2=%b er=%b\n",
		    cn, tn, sn, rkaddr->rkcs2, RKCS2_BITS,
		    rkaddr->rker, RKER_BITS);
		rkaddr->rkcs1 = rk_type[io->i_unit] | RK_CERR;
		DELAY(RK_DELAY);
		rkaddr->rkcs1 = rk_type[io->i_unit]|RK_DCLR|RK_GO;
		if (rkwait(rkaddr))
			return (-1);
		if (errcnt == 10) {
			printf("rk: unrecovered error\n");
			return (-1);
		}
		errcnt++;
		goto retry;
	}
	if (errcnt) {
		printf("rk: recovered by retry\n");
		errcnt = 0;
	}
	if (rkaddr->rkwc)
		goto more;
	if (forbb)
		io->i_ma += wc;
	io->i_bn += bn;
	return (wc);
}

static
rkwait(rkaddr)
	register struct rkdevice *rkaddr;
{
	register int i;
	short cs1;

#ifdef	M68020
	for ( i = 2000000; i ; i--)
#else	M68020
	for ( i = 500000; i ; i--)
#endif	M68020
		if (probe(&rkaddr->rkcs1, &cs1) && (cs1 & RK_CRDY) != 0)
			break;
	if (i == 0) {
		printf("rk: timeout\n");
		return(-1);
	}
	return (0);
}
