/*#define BAD144DEBUG	/* */
/*	qb.c	stand-alone 1.0 	84/12/11	*/

#include "../h/param.h"
#include "../h/inode.h"
#include "../h/fs.h"
#include "../h/dir.h"
#include "saio.h"
#include "../h/dkbad.h"
#include <sys/file.h>

# define min(x,y) (x<y ? x : y)

int forbb = 0;
struct dkbad dkbad = { 0 };

badstrat(io, sbn, len, func, strat, read)
register struct iob *io;
register int sbn, len;
register int func, read;
int (*strat)();
{
	int hadbad = 0;
	register int i;
	register int lbn = sbn + ((len+511) >> DEV_BSHIFT) - 1;
	register struct dkbad *bad = &dkbad;
	register int badbn = io->i_st.ncyl*io->i_st.nspc - io->i_st.nsect;
	register int sz;
	register int bbn;
	int nbs;
	int savema = io->i_ma;

# define ncpd io->i_st.ncyl
# define ntrks io->i_st.ntpc
# define nspt io->i_st.nsect

	/*
	 * if the bad sector map has not yet been read in then read it in
	 * and convert from DEC-144 (cyl/trk/sec) to block number.
	 */
  retry:
	if (bad->bt_csn == 0) {
		nbs = 0;
		io->i_ma = paddr(bad);
		if ((*strat)(io,badbn,sizeof(struct dkbad),read) == -1) {
			printf("can't read bad sector map\n");
			io->i_ma = savema;
			goto done;	/* so we'll keep trying */
		}
#ifdef	BAD144DEBUG
		printf("read bad144 map from block %d\n", badbn);
#endif	BAD144DEBUG
		io->i_ma = savema;
		if (bad->bt_csn != 0 && bad->bt_flag == 0) {
		    for (i = 0; i < 126; i++) {
		   	if (bad->bt_bad[i].bt_cyl == 0xFFFF)
	    		    bad->bt_bad[i].bt_bn = -1;
			else if ((bad->bt_bad[i].bt_cyl >= ncpd) ||
			 ((bad->bt_bad[i].bt_trksec >> 8) >= ntrks) ||
			 ((bad->bt_bad[i].bt_trksec & 0xff) >= nspt)) {
#undef	DEBUG
#ifdef	DEBUG
				printf("bad bad144 map: ");
				printf("(cyl %d,trk %d,sec %d\n)",
				    bad->bt_bad[i].bt_cyl,
				    (bad->bt_bad[i].bt_trksec>>8) & 0xff,
		            	    bad->bt_bad[i].bt_trksec&0xff);
#else	DEBUG
				printf("bad bad144 map\n");
				bad->bt_csn = -1;
				break;
#endif	DEBUG
		        } else {
#ifdef	BAD144DEBUG
				printf("(cyl %d,trk %d,sec %d)",
				    bad->bt_bad[i].bt_cyl,
				    (bad->bt_bad[i].bt_trksec>>8) & 0xff,
		            	    bad->bt_bad[i].bt_trksec&0xff);
#endif	BAD144DEBUG
	    	    		bad->bt_bad[i].bt_bn = 
				   (((bad->bt_bad[i].bt_cyl * ntrks) +
				   ((bad->bt_bad[i].bt_trksec>>8)&0xff)) *nspt)+
				    (bad->bt_bad[i].bt_trksec&0xff);
				nbs++;
#ifdef	BAD144DEBUG
				printf("[blk %d] remapped to %d\n",
				    bad->bt_bad[i].bt_bn, badbn - nbs);
#endif	BAD144DEBUG
				
		        }
			
		    }
# ifdef BAD144DEBUG
		    if (nbs != 0)
			    printf("%d remapped sectors\n", nbs);
# endif BAD144DEBUG
		    bad->bt_csn = 1;
		    bad->bt_mbz = nbs;
		} else
		    bad->bt_csn = -1;
	}
	/*
	 * search the bad sector map for remapped sectors 
	 */
	if (bad->bt_csn > 0) {
	    for (i=0; i < bad->bt_mbz; i++) {

		if ((bbn = bad->bt_bad[i].bt_bn) > lbn)
			break;
		if (bbn == -1)
			break;

		if (sbn <= bbn && bbn <= lbn) {
#ifdef	BAD144DEBUG
		printf("REMAP index i=%d of len=%d ",i,len);
		printf("to bbn=%d sbn=%d lbn=%d\n ",
			io->i_ma, bbn, sbn, lbn);
#endif	BAD144DEBUG
			if (!hadbad) {
				hadbad++;
			}
			/* 
			 * transfer from sbn to bad block bbn
			 */
			if (sbn < bbn) {
				sz = min(len,(bbn - sbn) * 512);
#ifdef	BAD144DEBUG
				printf("do up to bad block %d, size is %d\n",
					sbn,sz);
#endif	BAD144DEBUG
				if ((*strat)(io,sbn,sz,func) == -1)
					goto error;
				io->i_ma += sz;
				len -= sz;
			}
			/* 
			 * transfer remapped bbn
			 */
			sz = min(len, 512);
#ifdef	BAD144DEBUG
			printf("remap bad sector to %d sz=%d\n",
				badbn - i - 1, sz);
#endif	BAD144DEBUG
			if ((*strat)(io,badbn-i-1,sz,func) == -1)
				goto error;
			io->i_ma += sz;
			len -= sz;
			sbn = bbn+1;
		}
	    }
	    if (hadbad) {
		/* 
		 * transfer from sbn to lbn
		 */
		if (sbn <= lbn) {
			if ((*strat)(io,sbn,len,func) == -1)
				goto error;
			io->i_ma += len;
#ifdef	BAD144DEBUG
			printf("do bad block to end bs=%d sz=%d\n",
				sbn,len);
#endif	BAD144DEBUG
		}
#ifdef	BAD144DEBUG
		printf("done REMAP\n");
#endif	BAD144DEBUG
		return 0;
error:
#ifdef	BAD144DEBUG
		printf("error in badstrat\n");
#endif	BAD144DEBUG
		return -1;
	    }
	}
done:
	i = (*strat)(io,sbn,len,func);
	io->i_ma += len;
	return (i);
}
