/*	prf.c	6.1	83/07/29	*/

#include "../h/param.h"

extern int (*putch)();
extern int (*getch)();

/*
 * Scaled down version of C Library printf.
 * Used to print diagnostic information directly on console tty.
 * Since it is not interrupt driven, all system activities are
 * suspended.  Printf should not be used for chit-chat.
 *
 * One additional format: %b is supported to decode error registers.
 * Usage is:
 *	printf("reg=%b\n", regval, "<base><arg>*");
 * Where <base> is the output base expressed as a control character,
 * e.g. \10 gives octal; \20 gives hex.  Each arg is a sequence of
 * characters, the first of which gives the bit number to be inspected
 * (origin 1), and the next characters (up to a control character, i.e.
 * a character <= 32), give the name of the register.  Thus
 *	printf("reg=%b\n", 3, "\10\2BITTWO\1BITONE\n");
 * would produce output:
 *	reg=2<BITTWO,BITONE>
 */
/*VARARGS1*/
printf(fmt, x1)
	char *fmt;
	unsigned x1;
{
	prf(fmt, &x1);
}

prf(fmt, adx)
	register char *fmt;
	register u_int *adx;
{
	register int b, c, i;
	register char *s;
	register int any;

loop:
	while ((c = *fmt++) != '%') {
		if(c == '\0')
			return;
		(*putch)(c);
	}
again:
	c = *fmt++;
	/* THIS CODE IS VAX DEPENDENT IN HANDLING %l? AND %c */
	switch (c) {

	case 'l':
		goto again;
	case 'x': case 'X':
		b = 16;
		goto number;
	case 'd': case 'D':
	case 'u':		/* what a joke */
		b = 10;
		goto number;
	case 'o': case 'O':
		b = 8;
number:
		printn((u_long)*adx, b);
		break;
	case 'c':
		b = *adx;
		for (i = 24; i >= 0; i -= 8)
			if (c = (b >> i) & 0x7f)
				(*putch)(c);
		break;
	case 'b':
		b = *adx++;
		s = (char *)*adx;
		printn((u_long)b, *s++);
		any = 0;
		if (b) {
			(*putch)('<');
			while (i = *s++) {
				if (b & (1 << (i-1))) {
					if (any)
						(*putch)(',');
					any = 1;
					for (; (c = *s) > 32; s++)
						(*putch)(c);
				} else
					for (; *s > 32; s++)
						;
			}
			(*putch)('>');
		}
		break;

	case 'm':
		i = (int)*adx;
		b = i >> 20;
		printn(b, 10);
		(*putch)('.');
		b = 100-(((0x100 - ((i>>12)&0xFF))*100)/0x100);
		if (b < 10)
			(*putch)('0');
		printn(b, 10);
		break;

	case 's':
		s = (char *)*adx;
		while (c = *s++)
			(*putch)(c);
		break;

	case 'i':		/* identify bus/cpu type */
#ifdef	QBUS
# ifdef	M68020
		s = "QBUS 68020";
# else	M68020
		s = "QBUS 68010";
# endif	M68020
#else	QBUS
# ifdef	M68020
		s = "VMEBUS 68020";
# else	M68020
		s = "VMEBUS 68010";
# endif	M68020
#endif	QBUS
		for (; c = *s; s++)
			(*putch)(c);
		goto loop;
	}
	adx++;
	goto loop;
}

/*
 * Printn prints a number n in base b.
 * We don't use recursion to avoid deep kernel stacks.
 */
printn(n, b)
	register u_long n;
{
	char prbuf[11];
	register char *cp;

	if (b == 10 && (int)n < 0) {
		(*putch)('-');
		n = (unsigned)(-(int)n);
	}
	cp = prbuf;
	do {
		*cp++ = "0123456789ABCDEF"[n%b];
		n /= b;
	} while (n);
	do
		(*putch)(*--cp);
	while (cp > prbuf);
}

char *
stripwhite(buf)
	char *buf;
{
	register char c;
	register char *s1, *s2;

	for (s1 = s2 = buf ;  c = *s2 ; s2++)
		if (c != ' ' && c != '\t')
			*s1++ = c;
	*s1 = c;
	return (buf);
}

char *
striplwhite(buf)		/* remove leading white space */
	char *buf;
{
	register char *s1, *s2;

	for (s2 = buf ; *s2 == ' ' || *s2 == '\t'; s2++)
		;
	for (s1 = buf ;  *s2 ;)
		*s1++ = *s2++;
	*s1 = 0;
	return (buf);
}

char *
zerowhite(buf)
	char *buf;
{
	register char *s = buf;

	for (s = buf;  *s;  s += 1)
		if (*s == ' ' || *s == '\t')
			*s = '\0';
	return (buf);
}

gets(buf)
	char *buf;
{
	getsi(buf,0);
}
	
getsi(buf,i)
	char *buf;
	int i;
{

	register char *lp = &buf[i];
	register int c;

	for (;;) {
		c = (*getch)() & 0177;
	store:
		switch(c) {
		case '\n':
		case '\r':
			c = '\n';
			*lp++ = '\0';
			return;
/* Interferes with debug
		case '#':
			(*putch)('\b');
			(*putch)(' ');
			(*putch)('\b');
*/
		case '':
			(*putch)('\b');
		case '\b':
			lp--;
			if (lp < buf)
				lp = buf;
			(*putch)(' ');
			(*putch)('\b');
			continue;
/*		case '@': 		/* Interferes with autoboot */
		case 'u'&037:
			lp = buf;
			(*putch)('\n');
			continue;
		case 0x04:
			exit ();
		default:
			*lp++ = c;
		}
	}
}

getnum(string)
	unsigned char *string;
{
	register unsigned char *sp = string;
	register unsigned char c;
	register int base, num, digit;

	num = 0;
	while ((c = *sp) == ' ' || c == '\t')
		sp++;
	if (*sp == '0') {
		sp++;
		if (*sp == 'x' || *sp == 'X') {
			sp++;
			base = 16;
		} else
			base = 8;
	} else
		base = 10;

	while (c = *sp++) {
		switch (base) {
		  case 8:
			if ('0' <= c && c <= '7') {
				digit = c - '0';
				break;
			} else {
				printf("Invalid octal digit (%c)\n", c);
				return -1;
			}

		  case 16:
			digit = ctoh(c);
			if (digit == -1) {
				printf("Invalid hex digit (%c)\n", c);
				return -1;
			} else
				break;

		  case 10:
			if ('0' <= c && c <= '9') {
				digit = c - '0';
				break;
			} else {
				printf("Invalid decimal digit (%c)\n", c);
				return -1;
			}
		}
		num = num*base + digit;
	}
	return num;
}

gethex(cp)
register char *cp;
{
	register int c, n;

	n = 0;
	while (c = *cp++)
		if ((c = ctoh(c)) != -1)
			n = n * 16 + c;
		else 
			return(-1);
	return(n);
}

ctoh(c)
register char c;
{
	if (c >= '0' && c <= '9')
		return (c - '0');
	else if (c >= 'a' && c <= 'f')
		return (c - 'a' + 10);
	else if (c >= 'A' && c <= 'F')
		return (c - 'A' + 10);
	else
		return -1;
}

exit()
{
	printf("\nExit called\n");
	_rtt();
}
