#include	"../is68k/board.h"

char buf[80];
int lerrs;
int terrs;
int toterrs;


#define PTP		0
#define STBUF  		1
#define UTBUF  		2
char *test_name[]= {"PTP","TBUF_SYS","TBUF_USR"};

#define PTPSTART	PTP_BASE
#define PTPSTOP		(PTP_BASE + PTP_INCR*(NPTPS-1))
#define PTPINCR		PTP_INCR
#define PTPMASK		PTP_MASK

#define TBUFSSTART	TBUF_BASE_SYS
#define TBUFSSTOP	(TBUF_BASE_SYS + TBUF_INCR*(NTBUFS-1))
#define TBUFUSTART	TBUF_BASE_USR
#define TBUFUSTOP	(TBUF_BASE_USR + TBUF_INCR*(NTBUFS-1))
#define TBUFINCR	TBUF_INCR
#define TBUFMASK	TBUF_MASK

main()
{
	long repeat, forever;
	char test, sorp;
	int lapcnt, abort;
	int runptp, runstbuf, runutbuf;

	lerrs = 0;
	terrs = 0;
	toterrs = 0;
	printf("\n--- Integrated Solutions %i MMU RAM Diagnostic Tests ---");
	printf("\n                 Version 2.0\n");
regdef:	runptp = 0;
	runstbuf = 0;
	runutbuf = 0;
	printf("\nTest functionality of:\n");
	printf("  a) TBUF_SYS RAM\n  b) TBUF_USR RAM\n  c) PTP RAM\n");
	printf("  d) All\n\n");
	printf("Enter letter of functionality: ");
	stripwhite(gets(buf));
	sorp = buf[0];
	if (sorp == 'a')
		runstbuf = 1;
	else if (sorp == 'b')
		runutbuf = 1;
	else if (sorp == 'c')
		runptp = 1;
	else if (sorp == 'd') {
		runstbuf = 1; runutbuf = 1; runptp = 1;
	} else if (sorp == 'x')
		exit(0);
	else 
		goto regdef;
menu:	printf("\nTests available:\n");
	printf("  a) Patterns\n  b) Walk\n  c) Ping-pong\n");
	printf("  d) Uniqueness\n  z) All tests\n\n");
	while (1) {
		printf("Enter letter of desired test ('H' for help, 'X' for region redefinition): ");
		stripwhite(gets(buf));
		test = buf[0];
		if (test == 'H')
			goto menu;
		else if (test == 'X')
			goto regdef;
		else if (test == 'x')
			exit();
		printf("Repeat count in decimal (0 means forever): ");
		stripwhite(gets(buf));
		repeat = atol(buf);
		forever = (repeat == 0 ? 1 : 0);
		printf("\n");
		for (lapcnt = 1; (forever || repeat-- > 0); lapcnt++) {
			if (abort = getlocal())
				break;
			printf("Lap %d\n", lapcnt);
			switch (test) {
			  case 'a':
				if (runstbuf && (abort = patt(STBUF)))
					goto endfor;
				if (runutbuf && (abort = patt(UTBUF)))
					goto endfor;
				if (runptp && (abort = patt(PTP)))
					goto endfor;
				break;

			  case 'b':
				if (runstbuf && (abort = walk(STBUF)))
					goto endfor;
				if (runutbuf && (abort = walk(UTBUF)))
					goto endfor;
				if (runptp && (abort = walk(PTP)))
					goto endfor;
				break;

			  case 'c':
				if (runstbuf && (abort = ping(STBUF)))
					goto endfor;
				if (runutbuf && (abort = ping(UTBUF)))
					goto endfor;
				if (runptp && (abort = ping(PTP)))
					goto endfor;
				break;

			  case 'd':
				if (runstbuf && (abort = uniq(STBUF)))
					goto endfor;
				if (runutbuf && (abort = uniq(UTBUF)))
					goto endfor;
				if (runptp && (abort = uniq(PTP)))
					goto endfor;
				break;

			  case 'z':
				if (runstbuf && (abort = patt(STBUF)))
					goto endfor;
				if (runstbuf && (abort = walk(STBUF)))
					goto endfor;
				if (runstbuf && (abort = ping(STBUF)))
					goto endfor;
				if (runstbuf && (abort = uniq(STBUF)))
					goto endfor;
				if (runutbuf && (abort = patt(UTBUF)))
					goto endfor;
				if (runutbuf && (abort = walk(UTBUF)))
					goto endfor;
				if (runutbuf && (abort = ping(UTBUF)))
					goto endfor;
				if (runutbuf && (abort = uniq(UTBUF)))
					goto endfor;
				if (runptp && (abort = patt(PTP)))
					goto endfor;
				if (runptp && (abort = walk(PTP)))
					goto endfor;
				if (runptp && (abort = ping(PTP)))
					goto endfor;
				if (runptp && (abort = uniq(PTP)))
					goto endfor;
				break;

			  default:
				printf("No such test\n");
				goto endfor;
			}
			printf("  %d errors this lap\n", lerrs);
			lerrs = 0;
		}
endfor:
		if (abort) {
			printf("\nTest aborted");
			abort = 0;
		} else
			printf("Test completed");
		printf(" with %d errors this test, %d total errors\n\n",
			terrs, toterrs);
		terrs = 0;
	}
}

# define NPATT 4
# define NPATT2 68
unsigned int tpatt[NPATT2] = {0, 0xffffffff, 0x55555555, 0xaaaaaaaa,
			0x1, 0x2, 0x4, 0x8,
			0x10, 0x20, 0x40, 0x80,
			0x100, 0x200, 0x400, 0x800,
			0x1000, 0x2000, 0x4000, 0x8000,
			0x10000, 0x20000, 0x40000, 0x80000,
			0x100000, 0x200000, 0x400000, 0x800000,
			0x1000000, 0x2000000, 0x4000000, 0x8000000,
			0x10000000, 0x20000000, 0x40000000, 0x80000000,
			~0x1, ~0x2, ~0x4, ~0x8,
			~0x10, ~0x20, ~0x40, ~0x80,
			~0x100, ~0x200, ~0x400, ~0x800,
			~0x1000, ~0x2000, ~0x4000, ~0x8000,
			~0x10000, ~0x20000, ~0x40000, ~0x80000,
			~0x100000, ~0x200000, ~0x400000, ~0x800000,
			~0x1000000, ~0x2000000, ~0x4000000, ~0x8000000,
			~0x10000000, ~0x20000000, ~0x40000000, ~0x80000000};

patt(regtype)
int	regtype;
{
	register int incr;
	register int x, n, mask;

	if (regtype == STBUF || regtype == UTBUF) {
		register unsigned int *start, *stop;
		register unsigned int *addr;
		register unsigned int cpatt, rpatt;

		if (regtype == STBUF ) {
			start = (unsigned int *)TBUFSSTART;
			stop = (unsigned int *)TBUFSSTOP;
		} else {
			start = (unsigned int *)TBUFUSTART;
			stop = (unsigned int *)TBUFUSTOP;
		}
		incr = TBUFINCR/sizeof(int);
		mask = TBUFMASK;
		printf("  Pattern test - %s\n",test_name[regtype]);
		for (n = 0; n < NPATT2; n++) {
			cpatt = tpatt[n] & mask;
			printf("\r    Write  %x:    ", cpatt);
			for (addr = start; addr <= stop; addr+=incr)
				*addr = cpatt;
			printf("\r    Verify %x:    ", cpatt);
			for (addr = start; addr <= stop; addr+=incr) {
				rpatt = *addr & mask;
				if (rpatt != cpatt)
					error(addr, cpatt, rpatt);
			}
			if (getlocal())
				return 1;
		}
	} else {
		register unsigned int *start, *stop;
		register unsigned int *addr;
		register unsigned int cpatt, rpatt;

		printf("  Pattern test - PTP\n");
		mask = PTPMASK;
		incr = PTPINCR/sizeof(unsigned int);
		for (x = 0 ; x < 8 ; x++) {
		    *CTX = x;
		    start = (unsigned int *)PTPSTART;
		    stop = (unsigned int *)PTPSTOP;
		    for (n = 0; n < NPATT2; n++) {
			cpatt = tpatt[n] & mask;
			printf("\r    Write  %x:    ", cpatt);
			for (addr = start; addr <= stop; addr+=incr)
				*addr = cpatt;
			printf("\r    Verify %x:    ", cpatt);
			for (addr = start; addr <= stop; addr+=incr) {
				rpatt = *addr & mask;
				if (rpatt != cpatt)
					ptprror(addr, cpatt, rpatt, x);
			}
			if (getlocal())
				return 1;
		    }
		}
	}
	printf("\r                                     \r");
	return 0;
}

/*
**	Should I modify this to accept the function to call as an argument?
*/
walk(regtype)
int regtype;
{
	register int x, n, mask;
	register int incr;

	if (regtype == STBUF || regtype == UTBUF) {
		register unsigned int *addr, *start, *stop;
		register unsigned int cpatt;

		if (regtype == STBUF ) {
			start = (unsigned int *)TBUFSSTART;
			stop = (unsigned int *)TBUFSSTOP;
		} else {
			start = (unsigned int *)TBUFUSTART;
			stop = (unsigned int *)TBUFUSTOP;
		}
		incr = TBUFINCR/sizeof(unsigned int);
		mask = TBUFMASK;
		printf("  Walking test - %s\n",test_name[regtype]);
		for (n = 0; n < NPATT; n++) {
			cpatt = tpatt[n];
			printf("\r    Write  %x:    ", cpatt);
			for (addr = start; addr <= stop; addr += incr)
				*addr = cpatt;
			printf("\r    Walk   %x:    ", cpatt);
			if (walk1tbuf(start, stop, cpatt, mask))
				return 1;
		}
	} else {
		register unsigned int *addr, *start, *stop;
		register unsigned int cpatt;

		printf("  Walking test - PTP\n");
		mask = PTPMASK;
		incr = PTPINCR/sizeof(unsigned int);
		for (x= 0 ; x < 8 ; x++) {
		    *CTX = x;
		    start = (unsigned int *)PTPSTART;
		    stop = (unsigned int *)PTPSTOP;
		    for (n = 0; n < NPATT; n++) {
			cpatt = tpatt[n];
			printf("\r    Write  %x:    ", cpatt);
			for (addr = start; addr <= stop; addr += incr)
				*addr = cpatt;
			printf("\r    Walk   %x:    ", cpatt);
			if (walk1ptp(start, stop, cpatt, mask, x))
				return 1;
		    }
		}
	}
	printf("\r                                     \r");
	return 0;
}

walk1tbuf(start, stop, cpatt, mask)
unsigned int *start;
register unsigned int *stop, cpatt;
unsigned int mask;
{
	register unsigned int *addr, *addr2;
	register unsigned int pattc, rpatt;
	int incr;

	incr = TBUFINCR/sizeof(unsigned int);
	pattc = ~cpatt;
	pattc &= mask;
	cpatt &= mask;
	for (addr = start; addr <= stop; addr +=incr) {
		getlocal();	/* clear port */
		*addr = pattc;
		for (addr2 = start; addr2 <= stop; addr2 += incr) {
			rpatt = *addr2 & mask;
			if (rpatt != cpatt && addr2 != addr)
				error(addr2, cpatt, rpatt);
		}
		rpatt = *addr & mask;
		if (rpatt != pattc)
			error(addr, pattc, rpatt);
		*addr = cpatt;
		if (getlocal())
			return 1;
	}
	for (addr = start; addr <= stop; addr += incr) {
		rpatt = *addr & mask;
		if (rpatt != cpatt)
			error(addr, cpatt, rpatt);
	}
	return 0;
}

walk1ptp(start, stop, cpatt, mask, x)
unsigned int *start;
register unsigned int *stop, cpatt;
unsigned int mask;
{
	register unsigned int *addr, *addr2;
	register unsigned int pattc, rpatt;
	int incr;
	
	incr = PTPINCR/sizeof(unsigned int);
	pattc = ~cpatt;
	pattc &= mask;
	cpatt &= mask;
	for (addr = start; addr <= stop; addr +=incr) {
		getlocal();	/* clear port */
		*addr = pattc;
		for (addr2 = start; addr2 <= stop; addr2 += incr) {
			rpatt = *addr2 & mask;
			if (rpatt != cpatt && addr2 != addr)
				ptprror(addr2, cpatt, rpatt, x);
		}
		rpatt = *addr & mask;
		if (rpatt != pattc)
			ptprror(addr, pattc, rpatt, x);
		*addr = cpatt;
		if (getlocal())
			return 1;
	}
	for (addr = start; addr <= stop; addr += incr) {
		rpatt = *addr & mask;
		if (rpatt != cpatt)
			ptprror(addr, cpatt, rpatt, x);
	}
	return 0;
}



ping(regtype)
int regtype;
{
	register int x, n, mask;
	if (regtype == STBUF || regtype == UTBUF) {
		register unsigned int *addr, *start, *stop;
		register unsigned int cpatt;

		if (regtype == STBUF ) {
			start = (unsigned int *)TBUFSSTART;
			stop = (unsigned int *)TBUFSSTOP;
		} else {
			start = (unsigned int *)TBUFUSTART;
			stop = (unsigned int *)TBUFUSTOP;
		}
		mask = TBUFMASK;
		printf("  Ping-pong test - %s\n",test_name[regtype]);
		for (n = 0; n < NPATT; n++) {
			printf("\r    ping-pong %x from %x to %x              ",
				(unsigned int)tpatt[n], (int)start, (int)stop);
			if (ping1tbuf(start, stop, tpatt[n], mask))
				return 1;
		}
	} else {
		register unsigned int *addr, *start, *stop;
		register unsigned int cpatt;

		mask = PTPMASK;
		printf("  Ping-pong test - PTP\n");
		for (x = 0 ; x < 8 ; x++) {
		    *CTX = x;
		    start = (unsigned int *)PTPSTART;
		    stop = (unsigned int *)PTPSTOP;
		    for (n = 0; n < NPATT; n++) {
			printf("\r    ping-pong %x from %x to %x              ",
				(int)tpatt[n], (int)start, (int)stop);
			if (ping1ptp(start, stop, tpatt[n], mask, x))
				return 1;
		    }
		}
	}
	printf("\r                                                 \r");
	return 0;
}

ping1tbuf(start, stop, cpatt, mask)
unsigned int *start, *stop, cpatt, mask;
{
	register unsigned int *addr1, *addr2, *addr3, *addr4;
	register unsigned int pattc;
	int n;
	int incr;

	
	incr = TBUFINCR/sizeof(unsigned int);
	pattc = ~cpatt & mask;
	cpatt &= mask;

	for (addr1 = start; addr1 <= stop; addr1 += incr)
		*addr1 = cpatt;
	for (addr1=start,addr2=stop; addr1<addr2; addr1 += incr,addr2 -= incr) {
		getlocal();	/* clear buffer */
		*addr1 = pattc;
		*addr2 = pattc;
		for (addr3=start, addr4=stop; addr3 <= addr1; addr3 += incr,
			addr4 -= incr) {
			if ((*addr3 & mask) != pattc)
				error(addr3, pattc, *addr3 & mask);
			if ((*addr4 & mask) != pattc)
				error(addr4, pattc, *addr4 & mask);
		}
		for (addr3 = addr1+incr, addr4 = addr2-incr; addr3 <= addr4;
			addr3 += incr, addr4 -= incr) {
			if ((*addr3 & mask) != cpatt)
				error(addr3, cpatt, *addr3 & mask);
			if ((*addr4 & mask) != cpatt)
				error(addr4, cpatt, *addr4 & mask);
		}

		if (getlocal())
			return 1;
	}
	for ( addr1 -= incr, addr2 += incr; addr1 >= start;
		addr1 -= incr, addr2 += incr) {
		getlocal();	/* clear buffer */

		*addr1 = cpatt;
		*addr2 = cpatt;
		for (addr3=start, addr4=stop; addr3 < addr1; addr3 += incr,
			addr4 -= incr) {
			if ((*addr3 & mask) != pattc)
				error(addr3, pattc, *addr3 & mask);
			if ((*addr4 & mask) != pattc)
				error(addr4, pattc, *addr4 & mask);
		}
		for (addr3 = addr1, addr4 = addr2; addr3 <= addr4;
			addr3 += incr, addr4 -= incr) {
			if ((*addr3 & mask) != cpatt)
				error(addr3, cpatt, *addr3 & mask);
			if ((*addr4 & mask) != cpatt)
				error(addr4, cpatt, *addr4 & mask);
		}

		if (getlocal())
			return 1;
	}
	return 0;
}

ping1ptp(start, stop, cpatt, mask, x)
unsigned int *start, *stop, cpatt, mask;
{
	register unsigned int *addr1, *addr2, *addr3, *addr4;
	register unsigned int pattc;
	int n;
	int incr;

	
	incr = PTPINCR/sizeof(unsigned int);
	pattc = ~cpatt & mask;
	cpatt &= mask;

	for (addr1 = start; addr1 <= stop; addr1 += incr)
		*addr1 = cpatt;
	for (addr1=start,addr2=stop; addr1<addr2; addr1 += incr,addr2 -= incr) {
		getlocal();	/* clear buffer */
		*addr1 = pattc;
		*addr2 = pattc;
		for (addr3=start, addr4=stop; addr3 <= addr1; addr3 += incr,
			addr4 -= incr) {
			if ((*addr3 & mask) != pattc)
				ptprror(addr3, pattc, *addr3 & mask, x);
			if ((*addr4 & mask) != pattc)
				ptprror(addr4, pattc, *addr4 & mask, x);
		}
		for (addr3 = addr1+incr, addr4 = addr2-incr; addr3 <= addr4;
			addr3 += incr, addr4 -= incr) {
			if ((*addr3 & mask) != cpatt)
				ptprror(addr3, cpatt, *addr3 & mask, x);
			if ((*addr4 & mask) != cpatt)
				ptprror(addr4, cpatt, *addr4 & mask, x);
		}

		if (getlocal())
			return 1;
	}
	for ( addr1 -= incr, addr2 += incr; addr1 >= start;
		addr1 -= incr, addr2 += incr) {
		getlocal();	/* clear buffer */

		*addr1 = cpatt;
		*addr2 = cpatt;
		for (addr3=start, addr4=stop; addr3 < addr1; addr3 += incr,
			addr4 -= incr) {
			if ((*addr3 & mask) != pattc)
				ptprror(addr3, pattc, *addr3 & mask, x);
			if ((*addr4 & mask) != pattc)
				ptprror(addr4, pattc, *addr4 & mask, x);
		}
		for (addr3 = addr1, addr4 = addr2; addr3 <= addr4;
			addr3 += incr, addr4 -= incr) {
			if ((*addr3 & mask) != cpatt)
				ptprror(addr3, cpatt, *addr3 & mask, x);
			if ((*addr4 & mask) != cpatt)
				ptprror(addr4, cpatt, *addr4 & mask, x);
		}

		if (getlocal())
			return 1;
	}
	return 0;
}

uniq(regtype)
int regtype;
{
	int incr;
	unsigned int x, n, k;

	if (regtype == STBUF || regtype == UTBUF) {
		register unsigned int *start, *stop;
		register unsigned int *addr, *addr2;
		register unsigned int cpatt, rpatt, mask;

		if (regtype == STBUF ) {
			start = (unsigned int *)TBUFSSTART;
			stop = (unsigned int *)TBUFSSTOP;
		} else {
			start = (unsigned int *)TBUFUSTART;
			stop = (unsigned int *)TBUFUSTOP;
		}
		incr = TBUFINCR/sizeof(unsigned int);
		mask = TBUFMASK;
		printf("  Uniqueness test - %s\n",test_name[regtype]);
		for (addr = start, k = 0; addr <= stop; addr += incr, k++) {
			printf("\r    seed %x    ",k);
			getlocal();	/* clear port */
			for (addr2=start, n=0; addr2 <= stop; addr2+=incr, n++)
				*addr2 = (n + k) & mask;
			for (addr2=start,n=0; addr2 <= stop; addr2+=incr, n++) {
				rpatt = *addr2 & mask;
				cpatt = (n + k) & mask;
				if (rpatt != cpatt)
					error(addr, cpatt, rpatt);
			}
			if (getlocal())
				return 1;
		}
	} else {
		register unsigned int *start, *stop;
		register unsigned int *addr, *addr2;
		register unsigned int cpatt, rpatt, mask;

		start = (unsigned int *)PTPSTART;
		stop = (unsigned int *)PTPSTOP;
		incr = PTPINCR/sizeof(unsigned int);
		mask = PTPMASK;
		printf("  Uniqueness test - PTP\n");
		for (addr = start, k = 0; addr <= stop; addr += incr, k++) {
		    printf("\r    seed %x    ",k);
		    getlocal();	/* clear port */
		    for (x = 0, n = 0 ; x < 8 ; x++) {
			*CTX = x;
			for (addr2 = start; addr2 <= stop; addr2+=incr, n++)
				*addr2 = (n + k) & mask;
		    }
		    for (x = 0, n = 0 ; x < 8 ; x++) {
		    *CTX = x;
			for (addr2 = start; addr2 <= stop; addr2+=incr, n++) {
				rpatt = *addr2 & mask;
				cpatt = (n + k) & mask;
				if (rpatt != cpatt)
					ptprror(addr, cpatt, rpatt, x);
			}
		    }
		    if (getlocal())
			return 1;
		}
	}
	printf("\r                    \r");
	return 0;
}

error(addr, wrote, read)
register unsigned int *addr, wrote, read;
{
	register int i;

	printf("TBUF error at %x: wrote %x, read %x\n", 
		(int)addr, wrote, read);
	*addr = wrote;	/* Try to reset to correct value */
	if (lerrs == 0)	/* pause on first error */
		for (i = 100000; i > 0 ; i--);
	lerrs++; terrs++; toterrs++;
}

ptprror(addr, wrote, read, x)
register unsigned int *addr, wrote, read;
{
	register int i;

	printf("PTP error at ctx %d %x: wrote %x, read %x\n", 
		x, (int)addr, wrote, read);
	*addr = wrote;	/* Try to reset to correct value */
	if (lerrs == 0) /* pause on first error */
		for (i = 100000; i > 0 ; i--);
	lerrs++; terrs++; toterrs++;
}
