char buf[80];
int lerrs;
int terrs;
int toterrs;


# define SEGMENT 0
# define PAGE    1
# define SGSTART 0x441000
# define SGSTOP  0x7ff000
# define PGSTART 0x840000
# define PGSTOP  0xbff000

main()
{
	long repeat, forever;
	char test, sorp;
	int lapcnt, abort;
	int runseg, runpage;

	lerrs = 0;
	terrs = 0;
	toterrs = 0;
	printf("\n--- Integrated Solutions MMU Diagnostic Tests ---");
	printf("\n                 Version 2.0\n");
regdef:	runseg = 1;
	runpage = 1;
	printf("\nTest functionality of:\n");
	printf("  a) Segment Registers\n  b) Page Registers\n");
	printf("  c) Both\n\n");
	printf("Enter letter of functionality: ");
	stripwhite(gets(buf));
	sorp = buf[0];
	if (sorp == 'a')
		runpage = 0;
	else if (sorp == 'b')
		runseg = 0;
	else if (sorp == 'x')
		exit(0);
menu:	printf("\nTests available:\n");
	printf("  a) Patterns\n  b) Walk\n  c) Ping-pong\n");
	printf("  d) Uniqueness\n  z) All tests\n\n");
	while (1)
	{
		printf("Enter letter of desired test ('H' for help, 'X' for region redefinition): ");
		stripwhite(gets(buf));
		test = buf[0];
		if (test == 'H')
			goto menu;
		else if (test == 'X')
			goto regdef;
		else if (test == 'x')
			exit();
		printf("Repeat count in decimal (0 means forever): ");
		stripwhite(gets(buf));
		repeat = atol(buf);
		forever = (repeat == 0 ? 1 : 0);
		printf("\n");
		for (lapcnt = 1; (forever || repeat-- > 0); lapcnt++) {
			if (abort = getlocal())
				break;
			printf("Lap %d\n", lapcnt);
			switch (test) {
			  case 'a':
				if (runseg && (abort = patt(SEGMENT)))
					goto endfor;
				if (runpage && (abort = patt(PAGE)))
					goto endfor;
				break;

			  case 'b':
				if (runseg && (abort = walk(SEGMENT)))
					goto endfor;
				if (runpage && (abort = walk(PAGE)))
					goto endfor;
				break;

			  case 'c':
				if (runseg && (abort = ping(SEGMENT)))
					goto endfor;
				if (runpage && (abort = ping(PAGE)))
					goto endfor;
				break;

			  case 'd':
				if (runseg && (abort = uniq(SEGMENT)))
					goto endfor;
				if (runpage && (abort = uniq(PAGE)))
					goto endfor;
				break;

			  case 'z':
				if (runseg && (abort = patt(SEGMENT)))
					goto endfor;
				if (runseg && (abort = walk(SEGMENT)))
					goto endfor;
				if (runseg && (abort = ping(SEGMENT)))
					goto endfor;
				if (runseg && (abort = uniq(SEGMENT)))
					goto endfor;
				if (runpage && (abort = patt(PAGE)))
					goto endfor;
				if (runpage && (abort = walk(PAGE)))
					goto endfor;
				if (runpage && (abort = ping(PAGE)))
					goto endfor;
				if (runpage && (abort = uniq(PAGE)))
					goto endfor;
				break;

			  default:
				printf("No such test\n");
				goto endfor;
			}
			printf("  %d errors this lap\n", lerrs);
			lerrs = 0;
		}
endfor:
		if (abort) {
			printf("\nTest aborted");
			abort = 0;
		}
		else
			printf("Test completed");
		printf(" with %d errors this test, %d total errors\n\n",
			terrs, toterrs);
		terrs = 0;
	}
}

# define NPATT 4
# define NPATT2 36
unsigned short tpatt[NPATT2] = {0, 0xffff, 0x5555, 0xaaaa,
			0x1, 0x2, 0x4, 0x8,
			0x10, 0x20, 0x40, 0x80,
			0x100, 0x200, 0x400, 0x800,
			0x1000, 0x2000, 0x4000, 0x8000,
			~0x1, ~0x2, ~0x4, ~0x8,
			~0x10, ~0x20, ~0x40, ~0x80,
			~0x100, ~0x200, ~0x400, ~0x800,
			~0x1000, ~0x2000, ~0x4000, ~0x8000};

patt(regtype)
int	regtype;
{
	int incr;
	short n, mask;

	if (regtype == PAGE) {
		register unsigned short *start, *stop;
		register unsigned short *addr;
		register unsigned short cpatt, rpatt;

		start = (unsigned short *)PGSTART;
		stop = (unsigned short *)PGSTOP;
		incr = 0x1000/sizeof(unsigned short);
		mask = 0xfff;
		printf("  Pattern test - page registers\n");
		for (n = 0; n < NPATT2; n++) {
			cpatt = tpatt[n] & mask;
			printf("\r    Write  %x:    ", cpatt);
			for (addr = start; addr <= stop; addr+=incr)
				*addr = cpatt;
			printf("\r    Verify %x:    ", cpatt);
			for (addr = start; addr <= stop; addr+=incr) {
				rpatt = *addr & mask;
				if (rpatt != cpatt)
					error(addr, cpatt, rpatt);
			}
			if (getlocal())
				return 1;
		}
	} else {
		register unsigned short *start, *stop;
		register unsigned short *addr;
		register unsigned short cpatt, rpatt;

		start = (unsigned short *)SGSTART;
		stop = (unsigned short *)SGSTOP;
		incr = 0x1000/sizeof(unsigned short);
		mask = 0xff;
		printf("  Pattern test - segment registers\n");
loop:
		for (n = 0; n < NPATT2; n++) {
			cpatt = tpatt[n] & mask;
			printf("\r    Write  %x:    ", cpatt);
			for (addr = start; addr <= stop; addr+=incr)
				*addr = cpatt;
			printf("\r    Verify %x:    ", cpatt);
			for (addr = start; addr <= stop; addr+=incr) {
				rpatt = *addr & mask;
				if (rpatt != cpatt)
					error(addr, cpatt, rpatt);
			}
			if (getlocal())
				return 1;
		}
	}
	printf("\r                                     \r");
	return 0;
}

/*
**	Should I modify this to accept the function to call as an argument?
*/
walk(regtype)
int regtype;
{
	short n, mask;
	int incr;

	if (regtype == PAGE) {
		register unsigned short *addr, *start, *stop;
		register unsigned short cpatt;

		start = (unsigned short *)PGSTART;
		stop = (unsigned short *)PGSTOP;
		incr = 0x1000/sizeof(unsigned short);
		mask = 0xfff;
		printf("  Walking test - page registers\n");
		for (n = 0; n < NPATT; n++) {
			cpatt = tpatt[n];
			printf("\r    Write  %x:    ", cpatt);
			for (addr = start; addr <= stop; addr += incr)
				*addr = cpatt;
			printf("\r    Walk   %x:    ", cpatt);
			if (walk1pag(start, stop, cpatt, mask))
				return 1;
		}
	} else {
		register unsigned short *addr, *start, *stop;
		register unsigned short cpatt;

		start = (unsigned short *)SGSTART;
		stop = (unsigned short *)SGSTOP;
		incr = 0x1000/sizeof(unsigned short);
		mask = 0xff;
		printf("  Walking test - segment registers\n");
loop:
		for (n = 0; n < NPATT; n++) {
			cpatt = tpatt[n];
			printf("\r    Write  %x:    ", cpatt);
			for (addr = start; addr <= stop; addr += incr)
				*addr = cpatt;
			printf("\r    Walk   %x:    ", cpatt);
			if (walk1seg(start, stop, cpatt, mask))
				return 1;
		}
	}
	printf("\r                                     \r");
	return 0;
}

walk1pag(start, stop, cpatt, mask)
unsigned short *start;
register unsigned short *stop, cpatt;
unsigned short mask;
{
	register unsigned short *addr, *addr2;
	register unsigned short pattc, rpatt;
	int incr;

	incr = 0x1000/sizeof(unsigned short);
	pattc = ~cpatt;
	pattc &= mask;
	cpatt &= mask;
	for (addr = start; addr <= stop; addr +=incr) {
		getlocal();	/* clear port */
		*addr = pattc;
		for (addr2 = start; addr2 <= stop; addr2 += incr) {
			rpatt = *addr2 & mask;
			if (rpatt != cpatt && addr2 != addr)
				error(addr2, cpatt, rpatt);
		}
		rpatt = *addr & mask;
		if (rpatt != pattc)
			error(addr, pattc, rpatt);
		*addr = cpatt;
		if (getlocal())
			return 1;
	}
	for (addr = start; addr <= stop; addr += incr) {
		rpatt = *addr & mask;
		if (rpatt != cpatt)
			error(addr, cpatt, rpatt);
	}
	return 0;
}

walk1seg(start, stop, cpatt, mask)
unsigned short *start;
register unsigned short *stop, cpatt;
unsigned short mask;
{
	register unsigned short *addr, *addr2;
	register unsigned short pattc, rpatt;
	int incr;
	
	incr = 0x1000/sizeof(unsigned short);
	pattc = ~cpatt;
	pattc &= mask;
	cpatt &= mask;
	for (addr = start; addr <= stop; addr +=incr) {
		getlocal();	/* clear port */
		*addr = pattc;
		for (addr2 = start; addr2 <= stop; addr2 += incr) {
			rpatt = *addr2 & mask;
			if (rpatt != cpatt && addr2 != addr)
				error(addr2, cpatt, rpatt);
		}
		rpatt = *addr & mask;
		if (rpatt != pattc)
			error(addr, pattc, rpatt);
		*addr = cpatt;
		if (getlocal())
			return 1;
	}
	for (addr = start; addr <= stop; addr += incr) {
		rpatt = *addr & mask;
		if (rpatt != cpatt)
			error(addr, cpatt, rpatt);
	}
	return 0;
}



ping(regtype)
int regtype;
{
	register short n, mask;
	if (regtype == PAGE) {
		register unsigned short *addr, *start, *stop;
		register unsigned short cpatt;

		start = (unsigned short *)PGSTART;
		stop = (unsigned short *)PGSTOP;
		mask = 0xfff;
		printf("  Ping-pong test - page registers\n");
		for (n = 0; n < NPATT; n++) {
			printf("\r    ping-pong %x from %x to %x              ",
				(unsigned short)tpatt[n], (int)start, (int)stop);
			if (ping1pag(start, stop, tpatt[n], mask))
				return 1;
		}
	} else {
		register unsigned short *addr, *start, *stop;
		register unsigned short cpatt;

		start = (unsigned short *)SGSTART;
		stop = (unsigned short *)SGSTOP;
		mask = 0xff;
		printf("  Ping-pong test - segment registers\n");
		for (n = 0; n < NPATT; n++) {
			printf("\r    ping-pong %x from %x to %x              ",
				(short)tpatt[n], (int)start, (int)stop);
			if (ping1seg(start, stop, tpatt[n], mask))
				return 1;
		}
	}
	printf("\r                                               \r");
	return 0;
}

ping1pag(start, stop, cpatt, mask)
unsigned short *start, *stop, cpatt, mask;
{
	register unsigned short *addr1, *addr2, *addr3, *addr4;
	register unsigned short pattc;
	short n;
	int incr;

	
	incr = 0x1000/sizeof(unsigned short);
	pattc = ~cpatt & mask;
	cpatt &= mask;

	for (addr1 = start; addr1 <= stop; addr1 += incr)
		*addr1 = cpatt;
	for (addr1=start, addr2=stop; addr1<addr2; addr1 += incr, addr2 -= incr) {
		getlocal();	/* clear buffer */
		*addr1 = pattc;
		*addr2 = pattc;
		for (addr3=start, addr4=stop; addr3 <= addr1; addr3 += incr,
			addr4 -= incr) {
			if ((*addr3 & mask) != pattc)
				error(addr3, pattc, *addr3 & mask);
			if ((*addr4 & mask) != pattc)
				error(addr4, pattc, *addr4 & mask);
		}
		for (addr3 = addr1+incr, addr4 = addr2-incr; addr3 <= addr4;
			addr3 += incr, addr4 -= incr) {
			if ((*addr3 & mask) != cpatt)
				error(addr3, cpatt, *addr3 & mask);
			if ((*addr4 & mask) != cpatt)
				error(addr4, cpatt, *addr4 & mask);
		}

		if (getlocal())
			return 1;
	}
	for ( addr1 -= incr, addr2 += incr; addr1 >= start;
		addr1 -= incr, addr2 += incr) {
		getlocal();	/* clear buffer */

		*addr1 = cpatt;
		*addr2 = cpatt;
		for (addr3=start, addr4=stop; addr3 < addr1; addr3 += incr,
			addr4 -= incr) {
			if ((*addr3 & mask) != pattc)
				error(addr3, pattc, *addr3 & mask);
			if ((*addr4 & mask) != pattc)
				error(addr4, pattc, *addr4 & mask);
		}
		for (addr3 = addr1, addr4 = addr2; addr3 <= addr4;
			addr3 += incr, addr4 -= incr) {
			if ((*addr3 & mask) != cpatt)
				error(addr3, cpatt, *addr3 & mask);
			if ((*addr4 & mask) != cpatt)
				error(addr4, cpatt, *addr4 & mask);
		}

		if (getlocal())
			return 1;
	}
	return 0;
}

ping1seg(start, stop, cpatt, mask)
unsigned short *start, *stop, cpatt, mask;
{
	register unsigned short *addr1, *addr2, *addr3, *addr4;
	register unsigned short pattc;
	short n;
	int incr;

	
	incr = 0x1000/sizeof(unsigned short);
	pattc = ~cpatt & mask;
	cpatt &= mask;

	for (addr1 = start; addr1 <= stop; addr1 += incr)
		*addr1 = cpatt;
	for (addr1=start, addr2=stop; addr1<addr2; addr1 += incr, addr2 -= incr)
	{
		getlocal();	/* clear buffer */
		*addr1 = pattc;
		*addr2 = pattc;
		for (addr3=start, addr4=stop; addr3 <= addr1; addr3 += incr,
			addr4 -= incr) {
			if ((*addr3 & mask) != pattc)
				error(addr3, pattc, *addr3 & mask);
			if ((*addr4 & mask) != pattc)
				error(addr4, pattc, *addr4 & mask);
		}
		for (addr3 = addr1+incr, addr4 = addr2-incr; addr3 <= addr4;
			addr3 += incr, addr4 -= incr) {
			if ((*addr3 & mask) != cpatt)
				error(addr3, cpatt, *addr3 & mask);
			if ((*addr4 & mask) != cpatt)
				error(addr4, cpatt, *addr4 & mask);
		}

		if (getlocal())
			return 1;
	}
	for ( addr1 -= incr, addr2 += incr; addr1 >= start;
		addr1 -= incr, addr2 += incr) {
		getlocal();	/* clear buffer */

		*addr1 = cpatt;
		*addr2 = cpatt;
		for (addr3=start, addr4=stop; addr3 < addr1; addr3 += incr,
			addr4 -= incr) {
			if ((*addr3 & mask) != pattc)
				error(addr3, pattc, *addr3 & mask);
			if ((*addr4 & mask) != pattc)
				error(addr4, pattc, *addr4 & mask);
		}
		for (addr3 = addr1, addr4 = addr2; addr3 <= addr4;
			addr3 += incr, addr4 -= incr) {
			if ((*addr3 & mask) != cpatt)
				error(addr3, cpatt, *addr3 & mask);
			if ((*addr4 & mask) != cpatt)
				error(addr4, cpatt, *addr4 & mask);
		}

		if (getlocal())
			return 1;
	}
	return 0;
}

error(addr, wrote, read)
register unsigned short *addr, wrote, read;
{
	lerrs++;
	terrs++;
	toterrs++;
	printf("Error at %x: wrote %x, read %x\n", (int)addr, wrote, read);
	*addr = wrote;	/* Try to reset to correct value */
}


uniq(regtype)
int regtype;
{
	int incr;
	unsigned short n, k;

	if (regtype == PAGE) {
		register unsigned short *start, *stop;
		register unsigned short *addr, *addr2;
		register unsigned short cpatt, rpatt, mask;

		start = (unsigned short *)PGSTART;
		stop = (unsigned short *)PGSTOP;
		incr = 0x1000/sizeof(unsigned short);
		mask = 0xfff;
		printf("  Uniqueness test - page registers\n");
		for (addr = start, k = 0; addr <= stop; addr += incr, k++) {
			printf("\r    seed %x    ",k);
			getlocal();	/* clear port */
			for (addr2 = start, n=0; addr2 <= stop; addr2+=incr, n++)
				*addr2 = (n + k) & mask;
			for (addr2 = start, n=0; addr2 <= stop; addr2+=incr, n++)
			{
				rpatt = *addr2 & mask;
				cpatt = (n + k) & mask;
				if (rpatt != cpatt)
					error(addr, cpatt, rpatt);
			}
			if (getlocal())
				return 1;
		}
	}
	else
	{
		register unsigned short *start, *stop;
		register unsigned short *addr, *addr2;
		register unsigned short cpatt, rpatt, mask;

		start = (unsigned short *)SGSTART;
		stop = (unsigned short *)SGSTOP;
		incr = 0x1000/sizeof(unsigned short);
		mask = 0xff;
		printf("  Uniqueness test - segment registers\n");
loop:
		for (addr = start, k = 0; addr <= stop; addr += incr, k++) {
			printf("\r    seed %x    ",k);
			getlocal();	/* clear port */
			for (addr2 = start, n=0; addr2 <= stop; addr2+=incr, n++)
				*addr2 = (n + k) & mask;
			for (addr2 = start, n=0; addr2 <= stop; addr2+=incr, n++)
			{
				rpatt = *addr2 & mask;
				cpatt = (n + k) & mask;
				if (rpatt != cpatt)
					error(addr, cpatt, rpatt);
			}
			if (getlocal())
				return 1;
		}
	}
	printf("\r                    \r");
	return 0;
}
