/*
 * memtest:
 *	standalone memory test program
 */

#include "../is68k/board.h"
extern short end;

main()
{
	register char *start, *last;
        int i, ret;
        char buf[50], allc;

	printf("\n--- Integrated Solutions %i Memory Diagnostics 2 ---");
	printf("\n                 Version 2.0\n\n");
#ifdef	M68020
	onetoone();
#endif	M68020
loop:
	printf("Enter p to return to PROM, anything else to continue: ");
	if (getchar() == 'p')
		goto dortt;
	printf(" Test with parity? ('y' or 'n'): ");
	stripwhite(gets(buf));
	if ((allc = buf[0]) == 'y')
		_parityon();
	else if (allc == 'p')
		exit();
	printf("\n  Memory (0 - %x) reserved\n",&end);
memdef:	printf("  Enter hex start address: ");
	gets(buf);
	if ((start = (char *) gethex(buf)) == (char *) -1) {
		printf("Illegal number\n\n");
		goto memdef;
	}
	if (start >= (char *)0 && start <= (char *)&end) {
		printf("that would clobber you\n");
		goto memdef;
	}
	printf("  Enter hex stop address:  ");
	gets(buf);
	if ((last = (char *) gethex(buf)) == (char *) -1) {
		printf("Illegal number\n\n");
		goto loop;
	}
	if (last >= (char *)0 && last <= (char *)&end) {
		printf("that would clobber you\n");
		goto memdef;
	}
	if (last <= start) {
		printf("last <= start\n");
		goto memdef;
	}
	for (i = 0; i < 10; i++) {
		printf("00 ");
		ret = test1(0x00, start, last);
		if (ret == 1)
			goto loop;
		else if (ret == 2)
			goto dortt;
		printf("55 ");
		ret = test1(0x55, start, last);
		if (ret == 1)
			goto loop;
		else if (ret == 2)
			goto dortt;
		printf("aa ");
		ret = test1(0xaa, start, last);
		if (ret == 1)
			goto loop;
		else if (ret == 2)
			goto dortt;
		printf("ff ");
		ret = test1(0xff, start, last);
		if (ret == 1)
			goto loop;
		else if (ret == 2)
			goto dortt;
		printf("checker ");
		ret = checker(start, last);
		if (ret == 1)
			goto loop;
		else if (ret == 2)
			goto dortt;
		printf("interact5 ");
		ret = interact(5, start, last);
		if (ret == 1)
			goto loop;
		else if (ret == 2)
			goto dortt;
		if (i != 0) {
			printf("interact11 ");
			ret = interact(11, start, last);
			if (ret == 1)
				goto loop;
			else if (ret == 2)
				goto dortt;
		}
		run(start, last);
		printf("\007End of pass %d\n", i+1);
	}
	printf("Done\n\n");
	goto loop;
dortt:	_rtt();
}

/*
 * test1(pat, start, last)
 *	test all words with a fixed pattern
 */
test1(pat, start, last)
register unsigned char pat;
unsigned char *start;
register unsigned char *last;
{
	register unsigned char *cp, cval, sc;

	for (cp = start; cp < last; cp++)	/* load pattern */
		*cp = pat;
	for (cp = start; cp < last; cp++) 	/* check pattern */
	{
		if ((cval = *cp) != pat)
			printf("0x%x should be 0x%x is 0x%x\n", cp, pat, cval);
		if ((sc = getlocal()) == 'p')
			return 2;
		else if (sc == 'x')
			return 1;
	}
	return 0;
}

/*
 * checker(start, last)
 *	test with a checkerboard pattern
 */
checker(start, last)
register unsigned char *start, *last;
{
	register unsigned char *cp, cval, sc;

	for (cp = start; cp < last; ) {	/* load pattern */
		*cp++ = 0x55;
		*cp++ = 0xaa;
	}
	for (cp = start; cp < last; ) 	/* check pattern */
	{
		if ((cval = *cp++) != 0x55)
			printf("0x%x  should be 0x%x  is 0x%x\n",
				cp-1, 0x55, cval);
		if ((cval = *cp++) != 0xaa)
			printf("0x%x  should be 0x%x  is 0x%x\n",
				cp-1, 0xaa, cval);
		if ((sc = getlocal()) == 'p')
			return 2;
		else if (sc == 'x')
			return 1;
	}
	for (cp = start; cp < last; ) 	/* load complement pattern */
	{
		*cp++ = 0xaa;
		*cp++ = 0x55;
	}
	for (cp = start; cp < last; ) 	/* check pattern */
	{
		if ((cval = *cp++) != 0xaa)
			printf("0x%x  should be 0x%x  is 0x%x\n",
				cp-1, 0xaa, cval);
		if ((cval = *cp++) != 0x55)
			printf("0x%x  should be 0x%x  is 0x%x\n",
				cp-1, 0x55, cval);
		if ((sc = getlocal()) == 'p')
			return 2;
		else if (sc == 'x')
			return 1;
	}
	return 0;
}

/*
 * interact(mod, start, last)
 *	test interaction between words
 */
interact(mod, start, last)
register int mod;
register unsigned char *start, *last;
{
	register unsigned char *cp, cval, sc;
	register int i;
	int is;

	for (is = 0; is < mod; is++)
	{
		for (cp = start; cp < last; )
			*cp++ = 0;
		for (cp = &start[is]; cp < last; cp += mod)
			*cp = 0xff;
		i = 0;
		for (cp = start; cp < last; cp++)
		{
			if ((i++ % mod) != is)
			{
				if ((cval = *cp) != 0)
					printf("0x%x should be 0x%x  is 0x%x\n",
						cp, 0, cval);
			}
			else if ((cval = *cp) != 0xff)
				printf("0x%x  should be 0x%x  is 0x%x\n",
					cp, 0xff, cval);
			if ((sc = getlocal()) == 'p')
				return 2;
			else if (sc == 'x')
				return 1;
		}
		for (cp = start; cp < last; )
			*cp++ = 0xff;
		for (cp = &start[is]; cp < last; cp += mod)
			*cp = 0;
		i = 0;
		for (cp = start; cp < last; cp++)
		{
			if ((i++ % mod) != is)
			{
				if ((cval = *cp) != 0xff)
					printf("0x%x should be 0x%x  is 0x%x\n",
						cp, 0xff, cval);
			}
			else if ((cval = *cp) != 0)
				printf("0x%x should be 0x%x is 0x%x\n",
					cp, 0, cval);
			if ((sc = getlocal()) == 'p')
				return 2;
			else if (sc == 'x')
				return 1;
		}
	}
	return 0;
}

#define NOP	0x4E71
#define RTS	0x4E75

run(start, last)
register short *start, *last;
{
	register short *p;

	for (p = start; p < last; p++)
		*p = NOP;
	*(last-1) = RTS;
	printf("starting run");
	((int (*)())(char *)start)();
	printf(" -- done\n");
	return 0;
}
