#define	KLUDGE_COLOR_GIP_PROBLEM_WITH_020
#include 	"sais68k.h"
#include	"../is68k/board.h"
#include	"../is68k/pte.h"
#include	<setjmp.h>

#define 	MEMTRAP		*(int *)(0x08)

static jmp_buf	env;

static 
probetrp()
{
	longjmp(env,1);
}

probe(addr,val)
	register short *addr, *val;
{
	register int 	ret = 1;
	register int	savtrap = MEMTRAP;

	MEMTRAP = (int)probetrp;

	if ( !setjmp(env) ) {
#ifdef	KLUDGE_COLOR_GIP_PROBLEM_WITH_020
		register int zzz = *addr;

		if (*val);		/* dont delete !!! */
		*val = zzz;
#else	KLUDGE_COLOR_GIP_PROBLEM_WITH_020
		*val = *addr;
#endif	KLUDGE_COLOR_GIP_PROBLEM_WITH_020
	} else
		ret = 0;
		
	MEMTRAP = savtrap;
	return (ret);
}

probeb(addr,val)
	register char *addr, *val;
{
	register int 	ret = 1;
	register int	savtrap = MEMTRAP;

	MEMTRAP = (int)probetrp;

	if ( !setjmp(env) )
		*val = *addr;
	else
		ret = 0;
		
	MEMTRAP = savtrap;
	return (ret);
}

struct exsframe {
	unsigned short	sr;
	unsigned int	pc;
	unsigned short	formoff;
	unsigned short	ir;
	unsigned short	ssw;
	unsigned short	ipc;
	unsigned short	ipb;
	int		faddr;
}	frame;

traperr(x)
	int x;
{
	extern int autoboot;
	extern int hadint;
	register struct exsframe *frame;

	/* see code in M.s for (4 regs) */
	frame = (struct exsframe *)(((int *)&x)+4);
	autoboot = 0;
	printf("Trap: pc=0x(%x,%x) sr=0x%x ", frame->pc, 
		paddr(frame->pc), frame->sr);
	if (cpuchip == 68020) {
		hadint = (frame->formoff&0x3FF) / 4;
		printf("vec=0x%x/0%o ", hadint, hadint);
		printf("format=%x ",(frame->formoff & 0xF000) >> 12);
		if ((frame->formoff & 0xE000) == 0xA000)
			printf("esr=%x ssw=0x%x faddr=0x(%x,%x)",*ESR&0xff,
				frame->ssw, frame->faddr,paddr(frame->faddr));
	} else if (cpuchip == 68010) {
		hadint = (frame->formoff&0x3FF) / 4;
		printf("vec=0x%x/0%o ", hadint, hadint);
		if ((frame->formoff & 0xF000) == 0x8000)
			printf("ssw=0x%x faddr=0x(%x,%x)", frame->ssw,
				frame->faddr,paddr(frame->faddr & 0x7fffff));
	} else
		hadint = 1;
	printf("\n");
}

paddr(x)
	register long x;
{
	register long ret;
#ifdef	QBUS
	ret=((((long)((*(short *)((x&0x3FF000)|0x800000))&0xFFC))<<10)|
		(x&0xFFF));
#else	QBUS
#ifdef	M68020
	ret = x & NONT_MASK;
#else	M68020
	ret=((((long)((*(short *)(((x&0x7FF000)>>11)|PAGREGBASE))&0xFFF))<<12)
		|(x&0xFFF));
#endif	M68020
#endif	QBUS
	return (ret);
}

#ifdef	M68020
onetoone()
{
	register int i, *tb;
	
	tb = (int *)TBUF_BASE_SYS;
	for (i = 0; i < NTBUFS ; i++) {
		*tb = TBUF_VALID | PG_V|PG_R|PG_M | i;	/* system valid 1:1 */
		tb += (TBUF_INCR/sizeof( int));
	}
	tb = (int *)TBUF_BASE_USR;
	for (i = 0; i < NTBUFS ; i++) {
		*tb = TBUF_VALID | PG_V|PG_R|PG_M | i;	/* user valid 1:1 */
		tb += (TBUF_INCR/sizeof( int));
	}
}
#endif	M68020

cpux()
{
	register int n = (~(*BSR))&BSR_CNODE;

	if (n == BSR_CNODE)
		n = 0;
	return n;	/* return cluster node number */
}
