#include "../h/param.h"
#include "../is68k/board.h"
#include "sais68k.h"
#include <setjmp.h>

#define 	MEMTRAP		*(int *)(0x08)

static jmp_buf	env;
int	interrupt_on;

static 
probetrp()
{
	longjmp(env,1);
}

probe(addr,val)
	register short *addr, *val;
{
	register int 	ret = 1;
	register int	savtrap = MEMTRAP;

	MEMTRAP = (int)probetrp;

	if ( !setjmp(env) )
		*val = *addr;
	else
		ret = 0;
		
	MEMTRAP = savtrap;
	return (ret);
}

probeb(addr,val)
	register char *addr, *val;
{
	register int 	ret = 1;
	register int	savtrap = MEMTRAP;

	MEMTRAP = (int)probetrp;

	if ( !setjmp(env) )
		*val = *addr;
	else
		ret = 0;
		
	MEMTRAP = savtrap;
	return (ret);
}

struct exsframe {
	unsigned short	sr;
	unsigned int	pc;
	unsigned short	formoff;
	unsigned short	ssw;
	int		faddr;
}	frame;

traperr(x)
	int x;
{
	extern int autoboot;
	extern int hadint;
	extern int dorte;
	register struct exsframe *frame;

	/* see code in M.s for (4 regs) */
	frame = (struct exsframe *)(((int *)&x)+4);
	if (interrupt_on  &&  frame->formoff == 96) {
		turnoffint();			/* take away interrupt req */
		return;
	}
	autoboot = 0;
	printf("Trap: pc=0x(%x,%x) sr=0x%x ", frame->pc & 0x7fffff, 
		paddr(frame->pc & 0x7fffff), frame->sr);
	if (cpuchip == 68010) {
		hadint = (frame->formoff&0x3FF) / 4;
		printf("vec=0x%x/0%o ", hadint, hadint);
		if ((frame->formoff & 0xF000) == 0x8000)
			printf("ssw=0x%x faddr=0x(%x,%x)", frame->ssw,
				frame->faddr,paddr(frame->faddr & 0x7fffff));
	} else
		hadint = 1;
	printf("\n");
}

#ifdef	QBUS
addr18(x)
{
	return( (x&0xFFC00000) ? 0 : 1);
}
#endif	QBUS

paddr(x)
{
	register long ret;
#ifdef	QBUS
	ret=((((long)((*(short *)((x&0x3FF000)|0x800000))&0xFFC))<<10)|
		(x&0xFFF));
#else	QBUS
#ifdef	M68020
	ret = x & NONT_MASK;
#else	M68020
	ret=((((long)((*(short *)(((x&0x7FF000)>>11)|PAGREGBASE))&0xFFF))<<12)
		|(x&0xFFF));
#endif	M68020
#endif	QBUS
	return (ret);
}

mapin(vaddr, paddr, len)
	register unsigned long vaddr, paddr;
	register int len;
{
	do {
		*(short *)(((vaddr >> 11) | PAGREGBASE) & ~1) = paddr >> 12;
		vaddr += NBPG;
		paddr += NBPG;
	} while ((len -= NBPG) > 0);
}

turnonint()
{
	short s = *(short *)0xC1E000;

	interrupt_on = 1;
	return s;
}

turnoffint()
{
	short s = *(short *)0xC1A000;

	interrupt_on = 0;
	return s;
}

int
cpux()
{
	register int i;

	dorte = 1;
	turnonint();
	for (i = 7;  i >= 0;  i -= 1) {
		_splx(0x2000 + (i << 8));
		DELAY(1000);
		_splx(0x2700);
		if (!interrupt_on) {
			dorte = 0;
			return i + 1;
		}
	}
	turnoffint();
	dorte = 0;
	return 0;
}
